@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.inputs

import com.pulumi.aws.keyspaces.inputs.TableTtlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status Valid values: `ENABLED`.
 */
public data class TableTtlArgs(
    public val status: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.keyspaces.inputs.TableTtlArgs> {
    override fun toJava(): com.pulumi.aws.keyspaces.inputs.TableTtlArgs =
        com.pulumi.aws.keyspaces.inputs.TableTtlArgs.builder()
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableTtlArgs].
 */
@PulumiTagMarker
public class TableTtlArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value Valid values: `ENABLED`.
     */
    @JvmName("oebajgvyvppekdlh")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Valid values: `ENABLED`.
     */
    @JvmName("neecxgcuxeyhjgbp")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): TableTtlArgs = TableTtlArgs(
        status = status ?: throw PulumiNullFieldException("status"),
    )
}
