@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property readCapacityUnits The throughput capacity specified for read operations defined in read capacity units (RCUs).
 * @property throughputMode The read/write throughput capacity mode for a table. Valid values: `PAY_PER_REQUEST`, `PROVISIONED`. The default value is `PAY_PER_REQUEST`.
 * @property writeCapacityUnits The throughput capacity specified for write operations defined in write capacity units (WCUs).
 */
public data class TableCapacitySpecification(
    public val readCapacityUnits: Int? = null,
    public val throughputMode: String? = null,
    public val writeCapacityUnits: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.keyspaces.outputs.TableCapacitySpecification): TableCapacitySpecification = TableCapacitySpecification(
            readCapacityUnits = javaType.readCapacityUnits().map({ args0 -> args0 }).orElse(null),
            throughputMode = javaType.throughputMode().map({ args0 -> args0 }).orElse(null),
            writeCapacityUnits = javaType.writeCapacityUnits().map({ args0 -> args0 }).orElse(null),
        )
    }
}
