@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyIdentifier The Amazon Resource Name (ARN) of the customer managed KMS key.
 * @property type The encryption option specified for the table. Valid values: `AWS_OWNED_KMS_KEY`, `CUSTOMER_MANAGED_KMS_KEY`. The default value is `AWS_OWNED_KMS_KEY`.
 */
public data class TableEncryptionSpecification(
    public val kmsKeyIdentifier: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.keyspaces.outputs.TableEncryptionSpecification): TableEncryptionSpecification = TableEncryptionSpecification(
            kmsKeyIdentifier = javaType.kmsKeyIdentifier().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
