@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the column.
 * @property type The data type of the column. See the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types) for a list of available data types.
 */
public data class TableSchemaDefinitionColumn(
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.keyspaces.outputs.TableSchemaDefinitionColumn): TableSchemaDefinitionColumn = TableSchemaDefinitionColumn(
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
