@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin

import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs.builder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamKinesisSourceConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamKinesisSourceConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamMskSourceConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamMskSourceConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamServerSideEncryptionArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamServerSideEncryptionArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamSnowflakeConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamSnowflakeConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamSplunkConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamSplunkConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Kinesis Firehose Delivery Stream resource. Amazon Kinesis Firehose is a fully managed, elastic service to easily deliver real-time data streams to destinations such as Amazon S3 , Amazon Redshift and Snowflake.
 * For more details, see the [Amazon Kinesis Firehose Documentation](https://aws.amazon.com/documentation/firehose/).
 * ## Example Usage
 * ### Extended S3 Destination
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const bucket = new aws.s3.BucketV2("bucket", {bucket: "tf-test-bucket"});
 * const firehoseAssumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["firehose&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const firehoseRole = new aws.iam.Role("firehose_role", {
 *     name: "firehose_test_role",
 *     assumeRolePolicy: firehoseAssumeRole.then(firehoseAssumeRole => firehoseAssumeRole.json),
 * });
 * const lambdaAssumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["lambda&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const lambdaIam = new aws.iam.Role("lambda_iam", {
 *     name: "lambda_iam",
 *     assumeRolePolicy: lambdaAssumeRole.then(lambdaAssumeRole => lambdaAssumeRole.json),
 * });
 * const lambdaProcessor = new aws.lambda.Function("lambda_processor", {
 *     code: new pulumi.asset.FileArchive("lambda.zip"),
 *     name: "firehose_lambda_processor",
 *     role: lambdaIam.arn,
 *     handler: "exports.handler",
 *     runtime: aws.lambda.Runtime.NodeJS16dX,
 * });
 * const extendedS3Stream = new aws.kinesis.FirehoseDeliveryStream("extended_s3_stream", {
 *     name: "kinesis-firehose-extended-s3-test-stream",
 *     destination: "extended_s3",
 *     extendedS3Configuration: {
 *         roleArn: firehoseRole.arn,
 *         bucketArn: bucket.arn,
 *         processingConfiguration: {
 *             enabled: true,
 *             processors: [{
 *                 type: "Lambda",
 *                 parameters: [{
 *                     parameterName: "LambdaArn",
 *                     parameterValue: pulumi.interpolate`${lambdaProcessor.arn}:$LATEST`,
 *                 }],
 *             }],
 *         },
 *     },
 * });
 * const bucketAcl = new aws.s3.BucketAclV2("bucket_acl", {
 *     bucket: bucket.id,
 *     acl: "private",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * bucket = aws.s3.BucketV2("bucket", bucket="tf-test-bucket")
 * firehose_assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["firehose&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * firehose_role = aws.iam.Role("firehose_role",
 *     name="firehose_test_role",
 *     assume_role_policy=firehose_assume_role.json)
 * lambda_assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["lambda&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * lambda_iam = aws.iam.Role("lambda_iam",
 *     name="lambda_iam",
 *     assume_role_policy=lambda_assume_role.json)
 * lambda_processor = aws.lambda_.Function("lambda_processor",
 *     code=pulumi.FileArchive("lambda.zip"),
 *     name="firehose_lambda_processor",
 *     role=lambda_iam.arn,
 *     handler="exports.handler",
 *     runtime=aws.lambda_.Runtime.NODE_JS16D_X)
 * extended_s3_stream = aws.kinesis.FirehoseDeliveryStream("extended_s3_stream",
 *     name="kinesis-firehose-extended-s3-test-stream",
 *     destination="extended_s3",
 *     extended_s3_configuration={
 *         "role_arn": firehose_role.arn,
 *         "bucket_arn": bucket.arn,
 *         "processing_configuration": {
 *             "enabled": True,
 *             "processors": [{
 *                 "type": "Lambda",
 *                 "parameters": [{
 *                     "parameter_name": "LambdaArn",
 *                     "parameter_value": lambda_processor.arn.apply(lambda arn: f"{arn}:$LATEST"),
 *                 }],
 *             }],
 *         },
 *     })
 * bucket_acl = aws.s3.BucketAclV2("bucket_acl",
 *     bucket=bucket.id,
 *     acl="private")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bucket = new Aws.S3.BucketV2("bucket", new()
 *     {
 *         Bucket = "tf-test-bucket",
 *     });
 *     var firehoseAssumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "firehose.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var firehoseRole = new Aws.Iam.Role("firehose_role", new()
 *     {
 *         Name = "firehose_test_role",
 *         AssumeRolePolicy = firehoseAssumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var lambdaAssumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "lambda.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var lambdaIam = new Aws.Iam.Role("lambda_iam", new()
 *     {
 *         Name = "lambda_iam",
 *         AssumeRolePolicy = lambdaAssumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var lambdaProcessor = new Aws.Lambda.Function("lambda_processor", new()
 *     {
 *         Code = new FileArchive("lambda.zip"),
 *         Name = "firehose_lambda_processor",
 *         Role = lambdaIam.Arn,
 *         Handler = "exports.handler",
 *         Runtime = Aws.Lambda.Runtime.NodeJS16dX,
 *     });
 *     var extendedS3Stream = new Aws.Kinesis.FirehoseDeliveryStream("extended_s3_stream", new()
 *     {
 *         Name = "kinesis-firehose-extended-s3-test-stream",
 *         Destination = "extended_s3",
 *         ExtendedS3Configuration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs
 *         {
 *             RoleArn = firehoseRole.Arn,
 *             BucketArn = bucket.Arn,
 *             ProcessingConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs
 *             {
 *                 Enabled = true,
 *                 Processors = new[]
 *                 {
 *                     new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs
 *                     {
 *                         Type = "Lambda",
 *                         Parameters = new[]
 *                         {
 *                             new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs
 *                             {
 *                                 ParameterName = "LambdaArn",
 *                                 ParameterValue = lambdaProcessor.Arn.Apply(arn => $"{arn}:$LATEST"),
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var bucketAcl = new Aws.S3.BucketAclV2("bucket_acl", new()
 *     {
 *         Bucket = bucket.Id,
 *         Acl = "private",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		bucket, err := s3.NewBucketV2(ctx, "bucket", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("tf-test-bucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		firehoseAssumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"firehose.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		firehoseRole, err := iam.NewRole(ctx, "firehose_role", &iam.RoleArgs{
 * 			Name:             pulumi.String("firehose_test_role"),
 * 			AssumeRolePolicy: pulumi.String(firehoseAssumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		lambdaAssumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"lambda.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		lambdaIam, err := iam.NewRole(ctx, "lambda_iam", &iam.RoleArgs{
 * 			Name:             pulumi.String("lambda_iam"),
 * 			AssumeRolePolicy: pulumi.String(lambdaAssumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		lambdaProcessor, err := lambda.NewFunction(ctx, "lambda_processor", &lambda.FunctionArgs{
 * 			Code:    pulumi.NewFileArchive("lambda.zip"),
 * 			Name:    pulumi.String("firehose_lambda_processor"),
 * 			Role:    lambdaIam.Arn,
 * 			Handler: pulumi.String("exports.handler"),
 * 			Runtime: pulumi.String(lambda.RuntimeNodeJS16dX),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kinesis.NewFirehoseDeliveryStream(ctx, "extended_s3_stream", &kinesis.FirehoseDeliveryStreamArgs{
 * 			Name:        pulumi.String("kinesis-firehose-extended-s3-test-stream"),
 * 			Destination: pulumi.String("extended_s3"),
 * 			ExtendedS3Configuration: &kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationArgs{
 * 				RoleArn:   firehoseRole.Arn,
 * 				BucketArn: bucket.Arn,
 * 				ProcessingConfiguration: &kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs{
 * 					Enabled: pulumi.Bool(true),
 * 					Processors: kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArray{
 * 						&kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs{
 * 							Type: pulumi.String("Lambda"),
 * 							Parameters: kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArray{
 * 								&kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs{
 * 									ParameterName: pulumi.String("LambdaArn"),
 * 									ParameterValue: lambdaProcessor.Arn.ApplyT(func(arn string) (string, error) {
 * 										return fmt.Sprintf("%v:$LATEST", arn), nil
 * 									}).(pulumi.StringOutput),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketAclV2(ctx, "bucket_acl", &s3.BucketAclV2Args{
 * 			Bucket: bucket.ID(),
 * 			Acl:    pulumi.String("private"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucket = new BucketV2("bucket", BucketV2Args.builder()
 *             .bucket("tf-test-bucket")
 *             .build());
 *         final var firehoseAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("firehose.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var firehoseRole = new Role("firehoseRole", RoleArgs.builder()
 *             .name("firehose_test_role")
 *             .assumeRolePolicy(firehoseAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var lambdaAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("lambda.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var lambdaIam = new Role("lambdaIam", RoleArgs.builder()
 *             .name("lambda_iam")
 *             .assumeRolePolicy(lambdaAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var lambdaProcessor = new Function("lambdaProcessor", FunctionArgs.builder()
 *             .code(new FileArchive("lambda.zip"))
 *             .name("firehose_lambda_processor")
 *             .role(lambdaIam.arn())
 *             .handler("exports.handler")
 *             .runtime("nodejs16.x")
 *             .build());
 *         var extendedS3Stream = new FirehoseDeliveryStream("extendedS3Stream", FirehoseDeliveryStreamArgs.builder()
 *             .name("kinesis-firehose-extended-s3-test-stream")
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(firehoseRole.arn())
 *                 .bucketArn(bucket.arn())
 *                 .processingConfiguration(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder()
 *                         .type("Lambda")
 *                         .parameters(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                             .parameterName("LambdaArn")
 *                             .parameterValue(lambdaProcessor.arn().applyValue(arn -> String.format("%s:$LATEST", arn)))
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *         var bucketAcl = new BucketAclV2("bucketAcl", BucketAclV2Args.builder()
 *             .bucket(bucket.id())
 *             .acl("private")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   extendedS3Stream:
 *     type: aws:kinesis:FirehoseDeliveryStream
 *     name: extended_s3_stream
 *     properties:
 *       name: kinesis-firehose-extended-s3-test-stream
 *       destination: extended_s3
 *       extendedS3Configuration:
 *         roleArn: ${firehoseRole.arn}
 *         bucketArn: ${bucket.arn}
 *         processingConfiguration:
 *           enabled: 'true'
 *           processors:
 *             - type: Lambda
 *               parameters:
 *                 - parameterName: LambdaArn
 *                   parameterValue: ${lambdaProcessor.arn}:$LATEST
 *   bucket:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: tf-test-bucket
 *   bucketAcl:
 *     type: aws:s3:BucketAclV2
 *     name: bucket_acl
 *     properties:
 *       bucket: ${bucket.id}
 *       acl: private
 *   firehoseRole:
 *     type: aws:iam:Role
 *     name: firehose_role
 *     properties:
 *       name: firehose_test_role
 *       assumeRolePolicy: ${firehoseAssumeRole.json}
 *   lambdaIam:
 *     type: aws:iam:Role
 *     name: lambda_iam
 *     properties:
 *       name: lambda_iam
 *       assumeRolePolicy: ${lambdaAssumeRole.json}
 *   lambdaProcessor:
 *     type: aws:lambda:Function
 *     name: lambda_processor
 *     properties:
 *       code:
 *         fn::FileArchive: lambda.zip
 *       name: firehose_lambda_processor
 *       role: ${lambdaIam.arn}
 *       handler: exports.handler
 *       runtime: nodejs16.x
 * variables:
 *   firehoseAssumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - firehose.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   lambdaAssumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - lambda.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Extended S3 Destination with dynamic partitioning
 * These examples use built-in Firehose functionality, rather than requiring a lambda.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const extendedS3Stream = new aws.kinesis.FirehoseDeliveryStream("extended_s3_stream", {
 *     name: "kinesis-firehose-extended-s3-test-stream",
 *     destination: "extended_s3",
 *     extendedS3Configuration: {
 *         roleArn: firehoseRole.arn,
 *         bucketArn: bucket.arn,
 *         bufferingSize: 64,
 *         dynamicPartitioningConfiguration: {
 *             enabled: true,
 *         },
 *         prefix: "data/customer_id=!{partitionKeyFromQuery:customer_id}/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/",
 *         errorOutputPrefix: "errors/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/!{firehose:error-output-type}/",
 *         processingConfiguration: {
 *             enabled: true,
 *             processors: [
 *                 {
 *                     type: "RecordDeAggregation",
 *                     parameters: [{
 *                         parameterName: "SubRecordType",
 *                         parameterValue: "JSON",
 *                     }],
 *                 },
 *                 {
 *                     type: "AppendDelimiterToRecord",
 *                 },
 *                 {
 *                     type: "MetadataExtraction",
 *                     parameters: [
 *                         {
 *                             parameterName: "JsonParsingEngine",
 *                             parameterValue: "JQ-1.6",
 *                         },
 *                         {
 *                             parameterName: "MetadataExtractionQuery",
 *                             parameterValue: "{customer_id:.customer_id}",
 *                         },
 *                     ],
 *                 },
 *             ],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * extended_s3_stream = aws.kinesis.FirehoseDeliveryStream("extended_s3_stream",
 *     name="kinesis-firehose-extended-s3-test-stream",
 *     destination="extended_s3",
 *     extended_s3_configuration={
 *         "role_arn": firehose_role["arn"],
 *         "bucket_arn": bucket["arn"],
 *         "buffering_size": 64,
 *         "dynamic_partitioning_configuration": {
 *             "enabled": True,
 *         },
 *         "prefix": "data/customer_id=!{partitionKeyFromQuery:customer_id}/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/",
 *         "error_output_prefix": "errors/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/!{firehose:error-output-type}/",
 *         "processing_configuration": {
 *             "enabled": True,
 *             "processors": [
 *                 {
 *                     "type": "RecordDeAggregation",
 *                     "parameters": [{
 *                         "parameter_name": "SubRecordType",
 *                         "parameter_value": "JSON",
 *                     }],
 *                 },
 *                 {
 *                     "type": "AppendDelimiterToRecord",
 *                 },
 *                 {
 *                     "type": "MetadataExtraction",
 *                     "parameters": [
 *                         {
 *                             "parameter_name": "JsonParsingEngine",
 *                             "parameter_value": "JQ-1.6",
 *                         },
 *                         {
 *                             "parameter_name": "MetadataExtractionQuery",
 *                             "parameter_value": "{customer_id:.customer_id}",
 *                         },
 *                     ],
 *                 },
 *             ],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extendedS3Stream = new Aws.Kinesis.FirehoseDeliveryStream("extended_s3_stream", new()
 *     {
 *         Name = "kinesis-firehose-extended-s3-test-stream",
 *         Destination = "extended_s3",
 *         ExtendedS3Configuration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs
 *         {
 *             RoleArn = firehoseRole.Arn,
 *             BucketArn = bucket.Arn,
 *             BufferingSize = 64,
 *             DynamicPartitioningConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs
 *             {
 *                 Enabled = true,
 *             },
 *             Prefix = "data/customer_id=!{partitionKeyFromQuery:customer_id}/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/",
 *             ErrorOutputPrefix = "errors/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/!{firehose:error-output-type}/",
 *             ProcessingConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs
 *             {
 *                 Enabled = true,
 *                 Processors = new[]
 *                 {
 *                     new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs
 *                     {
 *                         Type = "RecordDeAggregation",
 *                         Parameters = new[]
 *                         {
 *                             new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs
 *                             {
 *                                 ParameterName = "SubRecordType",
 *                                 ParameterValue = "JSON",
 *                             },
 *                         },
 *                     },
 *                     new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs
 *                     {
 *                         Type = "AppendDelimiterToRecord",
 *                     },
 *                     new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs
 *                     {
 *                         Type = "MetadataExtraction",
 *                         Parameters = new[]
 *                         {
 *                             new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs
 *                             {
 *                                 ParameterName = "JsonParsingEngine",
 *                                 ParameterValue = "JQ-1.6",
 *                             },
 *                             new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs
 *                             {
 *                                 ParameterName = "MetadataExtractionQuery",
 *                                 ParameterValue = "{customer_id:.customer_id}",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kinesis.NewFirehoseDeliveryStream(ctx, "extended_s3_stream", &kinesis.FirehoseDeliveryStreamArgs{
 * 			Name:        pulumi.String("kinesis-firehose-extended-s3-test-stream"),
 * 			Destination: pulumi.String("extended_s3"),
 * 			ExtendedS3Configuration: &kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationArgs{
 * 				RoleArn:       pulumi.Any(firehoseRole.Arn),
 * 				BucketArn:     pulumi.Any(bucket.Arn),
 * 				BufferingSize: pulumi.Int(64),
 * 				DynamicPartitioningConfiguration: &kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs{
 * 					Enabled: pulumi.Bool(true),
 * 				},
 * 				Prefix:            pulumi.String("data/customer_id=!{partitionKeyFromQuery:customer_id}/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/"),
 * 				ErrorOutputPrefix: pulumi.String("errors/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/!{firehose:error-output-type}/"),
 * 				ProcessingConfiguration: &kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs{
 * 					Enabled: pulumi.Bool(true),
 * 					Processors: kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArray{
 * 						&kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs{
 * 							Type: pulumi.String("RecordDeAggregation"),
 * 							Parameters: kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArray{
 * 								&kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs{
 * 									ParameterName:  pulumi.String("SubRecordType"),
 * 									ParameterValue: pulumi.String("JSON"),
 * 								},
 * 							},
 * 						},
 * 						&kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs{
 * 							Type: pulumi.String("AppendDelimiterToRecord"),
 * 						},
 * 						&kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs{
 * 							Type: pulumi.String("MetadataExtraction"),
 * 							Parameters: kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArray{
 * 								&kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs{
 * 									ParameterName:  pulumi.String("JsonParsingEngine"),
 * 									ParameterValue: pulumi.String("JQ-1.6"),
 * 								},
 * 								&kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs{
 * 									ParameterName:  pulumi.String("MetadataExtractionQuery"),
 * 									ParameterValue: pulumi.String("{customer_id:.customer_id}"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extendedS3Stream = new FirehoseDeliveryStream("extendedS3Stream", FirehoseDeliveryStreamArgs.builder()
 *             .name("kinesis-firehose-extended-s3-test-stream")
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(firehoseRole.arn())
 *                 .bucketArn(bucket.arn())
 *                 .bufferingSize(64)
 *                 .dynamicPartitioningConfiguration(FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .build())
 *                 .prefix("data/customer_id=!{partitionKeyFromQuery:customer_id}/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/")
 *                 .errorOutputPrefix("errors/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/!{firehose:error-output-type}/")
 *                 .processingConfiguration(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(
 *                         FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder()
 *                             .type("RecordDeAggregation")
 *                             .parameters(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                                 .parameterName("SubRecordType")
 *                                 .parameterValue("JSON")
 *                                 .build())
 *                             .build(),
 *                         FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder()
 *                             .type("AppendDelimiterToRecord")
 *                             .build(),
 *                         FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder()
 *                             .type("MetadataExtraction")
 *                             .parameters(
 *                                 FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                                     .parameterName("JsonParsingEngine")
 *                                     .parameterValue("JQ-1.6")
 *                                     .build(),
 *                                 FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                                     .parameterName("MetadataExtractionQuery")
 *                                     .parameterValue("{customer_id:.customer_id}")
 *                                     .build())
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   extendedS3Stream:
 *     type: aws:kinesis:FirehoseDeliveryStream
 *     name: extended_s3_stream
 *     properties:
 *       name: kinesis-firehose-extended-s3-test-stream
 *       destination: extended_s3
 *       extendedS3Configuration:
 *         roleArn: ${firehoseRole.arn}
 *         bucketArn: ${bucket.arn}
 *         bufferingSize: 64
 *         dynamicPartitioningConfiguration:
 *           enabled: 'true'
 *         prefix: data/customer_id=!{partitionKeyFromQuery:customer_id}/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/
 *         errorOutputPrefix: errors/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/!{firehose:error-output-type}/
 *         processingConfiguration:
 *           enabled: 'true'
 *           processors:
 *             - type: RecordDeAggregation
 *               parameters:
 *                 - parameterName: SubRecordType
 *                   parameterValue: JSON
 *             - type: AppendDelimiterToRecord
 *             - type: MetadataExtraction
 *               parameters:
 *                 - parameterName: JsonParsingEngine
 *                   parameterValue: JQ-1.6
 *                 - parameterName: MetadataExtractionQuery
 *                   parameterValue: '{customer_id:.customer_id}'
 * ```
 * <!--End PulumiCodeChooser -->
 * Multiple Dynamic Partitioning Keys (maximum of 50) can be added by comma separating the `parameter_value`.
 * The following example adds the Dynamic Partitioning Keys: `store_id` and `customer_id` to the S3 prefix.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const extendedS3Stream = new aws.kinesis.FirehoseDeliveryStream("extended_s3_stream", {
 *     name: "kinesis-firehose-extended-s3-test-stream",
 *     destination: "extended_s3",
 *     extendedS3Configuration: {
 *         roleArn: firehoseRole.arn,
 *         bucketArn: bucket.arn,
 *         bufferingSize: 64,
 *         dynamicPartitioningConfiguration: {
 *             enabled: true,
 *         },
 *         prefix: "data/store_id=!{partitionKeyFromQuery:store_id}/customer_id=!{partitionKeyFromQuery:customer_id}/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/",
 *         errorOutputPrefix: "errors/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/!{firehose:error-output-type}/",
 *         processingConfiguration: {
 *             enabled: true,
 *             processors: [{
 *                 type: "MetadataExtraction",
 *                 parameters: [
 *                     {
 *                         parameterName: "JsonParsingEngine",
 *                         parameterValue: "JQ-1.6",
 *                     },
 *                     {
 *                         parameterName: "MetadataExtractionQuery",
 *                         parameterValue: "{store_id:.store_id,customer_id:.customer_id}",
 *                     },
 *                 ],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * extended_s3_stream = aws.kinesis.FirehoseDeliveryStream("extended_s3_stream",
 *     name="kinesis-firehose-extended-s3-test-stream",
 *     destination="extended_s3",
 *     extended_s3_configuration={
 *         "role_arn": firehose_role["arn"],
 *         "bucket_arn": bucket["arn"],
 *         "buffering_size": 64,
 *         "dynamic_partitioning_configuration": {
 *             "enabled": True,
 *         },
 *         "prefix": "data/store_id=!{partitionKeyFromQuery:store_id}/customer_id=!{partitionKeyFromQuery:customer_id}/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/",
 *         "error_output_prefix": "errors/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/!{firehose:error-output-type}/",
 *         "processing_configuration": {
 *             "enabled": True,
 *             "processors": [{
 *                 "type": "MetadataExtraction",
 *                 "parameters": [
 *                     {
 *                         "parameter_name": "JsonParsingEngine",
 *                         "parameter_value": "JQ-1.6",
 *                     },
 *                     {
 *                         "parameter_name": "MetadataExtractionQuery",
 *                         "parameter_value": "{store_id:.store_id,customer_id:.customer_id}",
 *                     },
 *                 ],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extendedS3Stream = new Aws.Kinesis.FirehoseDeliveryStream("extended_s3_stream", new()
 *     {
 *         Name = "kinesis-firehose-extended-s3-test-stream",
 *         Destination = "extended_s3",
 *         ExtendedS3Configuration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs
 *         {
 *             RoleArn = firehoseRole.Arn,
 *             BucketArn = bucket.Arn,
 *             BufferingSize = 64,
 *             DynamicPartitioningConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs
 *             {
 *                 Enabled = true,
 *             },
 *             Prefix = "data/store_id=!{partitionKeyFromQuery:store_id}/customer_id=!{partitionKeyFromQuery:customer_id}/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/",
 *             ErrorOutputPrefix = "errors/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/!{firehose:error-output-type}/",
 *             ProcessingConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs
 *             {
 *                 Enabled = true,
 *                 Processors = new[]
 *                 {
 *                     new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs
 *                     {
 *                         Type = "MetadataExtraction",
 *                         Parameters = new[]
 *                         {
 *                             new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs
 *                             {
 *                                 ParameterName = "JsonParsingEngine",
 *                                 ParameterValue = "JQ-1.6",
 *                             },
 *                             new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs
 *                             {
 *                                 ParameterName = "MetadataExtractionQuery",
 *                                 ParameterValue = "{store_id:.store_id,customer_id:.customer_id}",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kinesis.NewFirehoseDeliveryStream(ctx, "extended_s3_stream", &kinesis.FirehoseDeliveryStreamArgs{
 * 			Name:        pulumi.String("kinesis-firehose-extended-s3-test-stream"),
 * 			Destination: pulumi.String("extended_s3"),
 * 			ExtendedS3Configuration: &kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationArgs{
 * 				RoleArn:       pulumi.Any(firehoseRole.Arn),
 * 				BucketArn:     pulumi.Any(bucket.Arn),
 * 				BufferingSize: pulumi.Int(64),
 * 				DynamicPartitioningConfiguration: &kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs{
 * 					Enabled: pulumi.Bool(true),
 * 				},
 * 				Prefix:            pulumi.String("data/store_id=!{partitionKeyFromQuery:store_id}/customer_id=!{partitionKeyFromQuery:customer_id}/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/"),
 * 				ErrorOutputPrefix: pulumi.String("errors/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/!{firehose:error-output-type}/"),
 * 				ProcessingConfiguration: &kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs{
 * 					Enabled: pulumi.Bool(true),
 * 					Processors: kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArray{
 * 						&kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs{
 * 							Type: pulumi.String("MetadataExtraction"),
 * 							Parameters: kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArray{
 * 								&kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs{
 * 									ParameterName:  pulumi.String("JsonParsingEngine"),
 * 									ParameterValue: pulumi.String("JQ-1.6"),
 * 								},
 * 								&kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs{
 * 									ParameterName:  pulumi.String("MetadataExtractionQuery"),
 * 									ParameterValue: pulumi.String("{store_id:.store_id,customer_id:.customer_id}"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extendedS3Stream = new FirehoseDeliveryStream("extendedS3Stream", FirehoseDeliveryStreamArgs.builder()
 *             .name("kinesis-firehose-extended-s3-test-stream")
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(firehoseRole.arn())
 *                 .bucketArn(bucket.arn())
 *                 .bufferingSize(64)
 *                 .dynamicPartitioningConfiguration(FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .build())
 *                 .prefix("data/store_id=!{partitionKeyFromQuery:store_id}/customer_id=!{partitionKeyFromQuery:customer_id}/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/")
 *                 .errorOutputPrefix("errors/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/!{firehose:error-output-type}/")
 *                 .processingConfiguration(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder()
 *                         .type("MetadataExtraction")
 *                         .parameters(
 *                             FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                                 .parameterName("JsonParsingEngine")
 *                                 .parameterValue("JQ-1.6")
 *                                 .build(),
 *                             FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                                 .parameterName("MetadataExtractionQuery")
 *                                 .parameterValue("{store_id:.store_id,customer_id:.customer_id}")
 *                                 .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   extendedS3Stream:
 *     type: aws:kinesis:FirehoseDeliveryStream
 *     name: extended_s3_stream
 *     properties:
 *       name: kinesis-firehose-extended-s3-test-stream
 *       destination: extended_s3
 *       extendedS3Configuration:
 *         roleArn: ${firehoseRole.arn}
 *         bucketArn: ${bucket.arn}
 *         bufferingSize: 64
 *         dynamicPartitioningConfiguration:
 *           enabled: 'true'
 *         prefix: data/store_id=!{partitionKeyFromQuery:store_id}/customer_id=!{partitionKeyFromQuery:customer_id}/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/
 *         errorOutputPrefix: errors/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/!{firehose:error-output-type}/
 *         processingConfiguration:
 *           enabled: 'true'
 *           processors:
 *             - type: MetadataExtraction
 *               parameters:
 *                 - parameterName: JsonParsingEngine
 *                   parameterValue: JQ-1.6
 *                 - parameterName: MetadataExtractionQuery
 *                   parameterValue: '{store_id:.store_id,customer_id:.customer_id}'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Redshift Destination
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testCluster = new aws.redshift.Cluster("test_cluster", {
 *     clusterIdentifier: "tf-redshift-cluster",
 *     databaseName: "test",
 *     masterUsername: "testuser",
 *     masterPassword: "T3stPass",
 *     nodeType: "dc1.large",
 *     clusterType: "single-node",
 * });
 * const testStream = new aws.kinesis.FirehoseDeliveryStream("test_stream", {
 *     name: "kinesis-firehose-test-stream",
 *     destination: "redshift",
 *     redshiftConfiguration: {
 *         roleArn: firehoseRole.arn,
 *         clusterJdbcurl: pulumi.interpolate`jdbc:redshift://${testCluster.endpoint}/${testCluster.databaseName}`,
 *         username: "testuser",
 *         password: "T3stPass",
 *         dataTableName: "test-table",
 *         copyOptions: "delimiter '|'",
 *         dataTableColumns: "test-col",
 *         s3BackupMode: "Enabled",
 *         s3Configuration: {
 *             roleArn: firehoseRole.arn,
 *             bucketArn: bucket.arn,
 *             bufferingSize: 10,
 *             bufferingInterval: 400,
 *             compressionFormat: "GZIP",
 *         },
 *         s3BackupConfiguration: {
 *             roleArn: firehoseRole.arn,
 *             bucketArn: bucket.arn,
 *             bufferingSize: 15,
 *             bufferingInterval: 300,
 *             compressionFormat: "GZIP",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_cluster = aws.redshift.Cluster("test_cluster",
 *     cluster_identifier="tf-redshift-cluster",
 *     database_name="test",
 *     master_username="testuser",
 *     master_password="T3stPass",
 *     node_type="dc1.large",
 *     cluster_type="single-node")
 * test_stream = aws.kinesis.FirehoseDeliveryStream("test_stream",
 *     name="kinesis-firehose-test-stream",
 *     destination="redshift",
 *     redshift_configuration={
 *         "role_arn": firehose_role["arn"],
 *         "cluster_jdbcurl": pulumi.Output.all(test_cluster.endpoint, test_cluster.database_name).apply(lambda endpoint, database_name: f"jdbc:redshift://{endpoint}/{database_name}"),
 *         "username": "testuser",
 *         "password": "T3stPass",
 *         "data_table_name": "test-table",
 *         "copy_options": "delimiter '|'",
 *         "data_table_columns": "test-col",
 *         "s3_backup_mode": "Enabled",
 *         "s3_configuration": {
 *             "role_arn": firehose_role["arn"],
 *             "bucket_arn": bucket["arn"],
 *             "buffering_size": 10,
 *             "buffering_interval": 400,
 *             "compression_format": "GZIP",
 *         },
 *         "s3_backup_configuration": {
 *             "role_arn": firehose_role["arn"],
 *             "bucket_arn": bucket["arn"],
 *             "buffering_size": 15,
 *             "buffering_interval": 300,
 *             "compression_format": "GZIP",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testCluster = new Aws.RedShift.Cluster("test_cluster", new()
 *     {
 *         ClusterIdentifier = "tf-redshift-cluster",
 *         DatabaseName = "test",
 *         MasterUsername = "testuser",
 *         MasterPassword = "T3stPass",
 *         NodeType = "dc1.large",
 *         ClusterType = "single-node",
 *     });
 *     var testStream = new Aws.Kinesis.FirehoseDeliveryStream("test_stream", new()
 *     {
 *         Name = "kinesis-firehose-test-stream",
 *         Destination = "redshift",
 *         RedshiftConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs
 *         {
 *             RoleArn = firehoseRole.Arn,
 *             ClusterJdbcurl = Output.Tuple(testCluster.Endpoint, testCluster.DatabaseName).Apply(values =>
 *             {
 *                 var endpoint = values.Item1;
 *                 var databaseName = values.Item2;
 *                 return $"jdbc:redshift://{endpoint}/{databaseName}";
 *             }),
 *             Username = "testuser",
 *             Password = "T3stPass",
 *             DataTableName = "test-table",
 *             CopyOptions = "delimiter '|'",
 *             DataTableColumns = "test-col",
 *             S3BackupMode = "Enabled",
 *             S3Configuration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs
 *             {
 *                 RoleArn = firehoseRole.Arn,
 *                 BucketArn = bucket.Arn,
 *                 BufferingSize = 10,
 *                 BufferingInterval = 400,
 *                 CompressionFormat = "GZIP",
 *             },
 *             S3BackupConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationArgs
 *             {
 *                 RoleArn = firehoseRole.Arn,
 *                 BucketArn = bucket.Arn,
 *                 BufferingSize = 15,
 *                 BufferingInterval = 300,
 *                 CompressionFormat = "GZIP",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testCluster, err := redshift.NewCluster(ctx, "test_cluster", &redshift.ClusterArgs{
 * 			ClusterIdentifier: pulumi.String("tf-redshift-cluster"),
 * 			DatabaseName:      pulumi.String("test"),
 * 			MasterUsername:    pulumi.String("testuser"),
 * 			MasterPassword:    pulumi.String("T3stPass"),
 * 			NodeType:          pulumi.String("dc1.large"),
 * 			ClusterType:       pulumi.String("single-node"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kinesis.NewFirehoseDeliveryStream(ctx, "test_stream", &kinesis.FirehoseDeliveryStreamArgs{
 * 			Name:        pulumi.String("kinesis-firehose-test-stream"),
 * 			Destination: pulumi.String("redshift"),
 * 			RedshiftConfiguration: &kinesis.FirehoseDeliveryStreamRedshiftConfigurationArgs{
 * 				RoleArn: pulumi.Any(firehoseRole.Arn),
 * 				ClusterJdbcurl: pulumi.All(testCluster.Endpoint, testCluster.DatabaseName).ApplyT(func(_args []interface{}) (string, error) {
 * 					endpoint := _args[0].(string)
 * 					databaseName := _args[1].(string)
 * 					return fmt.Sprintf("jdbc:redshift://%v/%v", endpoint, databaseName), nil
 * 				}).(pulumi.StringOutput),
 * 				Username:         pulumi.String("testuser"),
 * 				Password:         pulumi.String("T3stPass"),
 * 				DataTableName:    pulumi.String("test-table"),
 * 				CopyOptions:      pulumi.String("delimiter '|'"),
 * 				DataTableColumns: pulumi.String("test-col"),
 * 				S3BackupMode:     pulumi.String("Enabled"),
 * 				S3Configuration: &kinesis.FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs{
 * 					RoleArn:           pulumi.Any(firehoseRole.Arn),
 * 					BucketArn:         pulumi.Any(bucket.Arn),
 * 					BufferingSize:     pulumi.Int(10),
 * 					BufferingInterval: pulumi.Int(400),
 * 					CompressionFormat: pulumi.String("GZIP"),
 * 				},
 * 				S3BackupConfiguration: &kinesis.FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationArgs{
 * 					RoleArn:           pulumi.Any(firehoseRole.Arn),
 * 					BucketArn:         pulumi.Any(bucket.Arn),
 * 					BufferingSize:     pulumi.Int(15),
 * 					BufferingInterval: pulumi.Int(300),
 * 					CompressionFormat: pulumi.String("GZIP"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Cluster;
 * import com.pulumi.aws.redshift.ClusterArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Cluster("testCluster", ClusterArgs.builder()
 *             .clusterIdentifier("tf-redshift-cluster")
 *             .databaseName("test")
 *             .masterUsername("testuser")
 *             .masterPassword("T3stPass")
 *             .nodeType("dc1.large")
 *             .clusterType("single-node")
 *             .build());
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .name("kinesis-firehose-test-stream")
 *             .destination("redshift")
 *             .redshiftConfiguration(FirehoseDeliveryStreamRedshiftConfigurationArgs.builder()
 *                 .roleArn(firehoseRole.arn())
 *                 .clusterJdbcurl(Output.tuple(testCluster.endpoint(), testCluster.databaseName()).applyValue(values -> {
 *                     var endpoint = values.t1;
 *                     var databaseName = values.t2;
 *                     return String.format("jdbc:redshift://%s/%s", endpoint,databaseName);
 *                 }))
 *                 .username("testuser")
 *                 .password("T3stPass")
 *                 .dataTableName("test-table")
 *                 .copyOptions("delimiter '|'")
 *                 .dataTableColumns("test-col")
 *                 .s3BackupMode("Enabled")
 *                 .s3Configuration(FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(firehoseRole.arn())
 *                     .bucketArn(bucket.arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .s3BackupConfiguration(FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationArgs.builder()
 *                     .roleArn(firehoseRole.arn())
 *                     .bucketArn(bucket.arn())
 *                     .bufferingSize(15)
 *                     .bufferingInterval(300)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testCluster:
 *     type: aws:redshift:Cluster
 *     name: test_cluster
 *     properties:
 *       clusterIdentifier: tf-redshift-cluster
 *       databaseName: test
 *       masterUsername: testuser
 *       masterPassword: T3stPass
 *       nodeType: dc1.large
 *       clusterType: single-node
 *   testStream:
 *     type: aws:kinesis:FirehoseDeliveryStream
 *     name: test_stream
 *     properties:
 *       name: kinesis-firehose-test-stream
 *       destination: redshift
 *       redshiftConfiguration:
 *         roleArn: ${firehoseRole.arn}
 *         clusterJdbcurl: jdbc:redshift://${testCluster.endpoint}/${testCluster.databaseName}
 *         username: testuser
 *         password: T3stPass
 *         dataTableName: test-table
 *         copyOptions: delimiter '|'
 *         dataTableColumns: test-col
 *         s3BackupMode: Enabled
 *         s3Configuration:
 *           roleArn: ${firehoseRole.arn}
 *           bucketArn: ${bucket.arn}
 *           bufferingSize: 10
 *           bufferingInterval: 400
 *           compressionFormat: GZIP
 *         s3BackupConfiguration:
 *           roleArn: ${firehoseRole.arn}
 *           bucketArn: ${bucket.arn}
 *           bufferingSize: 15
 *           bufferingInterval: 300
 *           compressionFormat: GZIP
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Elasticsearch Destination
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testCluster = new aws.elasticsearch.Domain("test_cluster", {domainName: "firehose-es-test"});
 * const testStream = new aws.kinesis.FirehoseDeliveryStream("test_stream", {
 *     name: "kinesis-firehose-test-stream",
 *     destination: "elasticsearch",
 *     elasticsearchConfiguration: {
 *         domainArn: testCluster.arn,
 *         roleArn: firehoseRole.arn,
 *         indexName: "test",
 *         typeName: "test",
 *         s3Configuration: {
 *             roleArn: firehoseRole.arn,
 *             bucketArn: bucket.arn,
 *             bufferingSize: 10,
 *             bufferingInterval: 400,
 *             compressionFormat: "GZIP",
 *         },
 *         processingConfiguration: {
 *             enabled: true,
 *             processors: [{
 *                 type: "Lambda",
 *                 parameters: [{
 *                     parameterName: "LambdaArn",
 *                     parameterValue: `${lambdaProcessor.arn}:$LATEST`,
 *                 }],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_cluster = aws.elasticsearch.Domain("test_cluster", domain_name="firehose-es-test")
 * test_stream = aws.kinesis.FirehoseDeliveryStream("test_stream",
 *     name="kinesis-firehose-test-stream",
 *     destination="elasticsearch",
 *     elasticsearch_configuration={
 *         "domain_arn": test_cluster.arn,
 *         "role_arn": firehose_role["arn"],
 *         "index_name": "test",
 *         "type_name": "test",
 *         "s3_configuration": {
 *             "role_arn": firehose_role["arn"],
 *             "bucket_arn": bucket["arn"],
 *             "buffering_size": 10,
 *             "buffering_interval": 400,
 *             "compression_format": "GZIP",
 *         },
 *         "processing_configuration": {
 *             "enabled": True,
 *             "processors": [{
 *                 "type": "Lambda",
 *                 "parameters": [{
 *                     "parameter_name": "LambdaArn",
 *                     "parameter_value": f"{lambda_processor['arn']}:$LATEST",
 *                 }],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testCluster = new Aws.ElasticSearch.Domain("test_cluster", new()
 *     {
 *         DomainName = "firehose-es-test",
 *     });
 *     var testStream = new Aws.Kinesis.FirehoseDeliveryStream("test_stream", new()
 *     {
 *         Name = "kinesis-firehose-test-stream",
 *         Destination = "elasticsearch",
 *         ElasticsearchConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgs
 *         {
 *             DomainArn = testCluster.Arn,
 *             RoleArn = firehoseRole.Arn,
 *             IndexName = "test",
 *             TypeName = "test",
 *             S3Configuration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs
 *             {
 *                 RoleArn = firehoseRole.Arn,
 *                 BucketArn = bucket.Arn,
 *                 BufferingSize = 10,
 *                 BufferingInterval = 400,
 *                 CompressionFormat = "GZIP",
 *             },
 *             ProcessingConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs
 *             {
 *                 Enabled = true,
 *                 Processors = new[]
 *                 {
 *                     new Aws.Kinesis.Inputs.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgs
 *                     {
 *                         Type = "Lambda",
 *                         Parameters = new[]
 *                         {
 *                             new Aws.Kinesis.Inputs.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorParameterArgs
 *                             {
 *                                 ParameterName = "LambdaArn",
 *                                 ParameterValue = $"{lambdaProcessor.Arn}:$LATEST",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticsearch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testCluster, err := elasticsearch.NewDomain(ctx, "test_cluster", &elasticsearch.DomainArgs{
 * 			DomainName: pulumi.String("firehose-es-test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kinesis.NewFirehoseDeliveryStream(ctx, "test_stream", &kinesis.FirehoseDeliveryStreamArgs{
 * 			Name:        pulumi.String("kinesis-firehose-test-stream"),
 * 			Destination: pulumi.String("elasticsearch"),
 * 			ElasticsearchConfiguration: &kinesis.FirehoseDeliveryStreamElasticsearchConfigurationArgs{
 * 				DomainArn: testCluster.Arn,
 * 				RoleArn:   pulumi.Any(firehoseRole.Arn),
 * 				IndexName: pulumi.String("test"),
 * 				TypeName:  pulumi.String("test"),
 * 				S3Configuration: &kinesis.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs{
 * 					RoleArn:           pulumi.Any(firehoseRole.Arn),
 * 					BucketArn:         pulumi.Any(bucket.Arn),
 * 					BufferingSize:     pulumi.Int(10),
 * 					BufferingInterval: pulumi.Int(400),
 * 					CompressionFormat: pulumi.String("GZIP"),
 * 				},
 * 				ProcessingConfiguration: &kinesis.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs{
 * 					Enabled: pulumi.Bool(true),
 * 					Processors: kinesis.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArray{
 * 						&kinesis.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgs{
 * 							Type: pulumi.String("Lambda"),
 * 							Parameters: kinesis.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorParameterArray{
 * 								&kinesis.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorParameterArgs{
 * 									ParameterName:  pulumi.String("LambdaArn"),
 * 									ParameterValue: pulumi.Sprintf("%v:$LATEST", lambdaProcessor.Arn),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Domain("testCluster", DomainArgs.builder()
 *             .domainName("firehose-es-test")
 *             .build());
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .name("kinesis-firehose-test-stream")
 *             .destination("elasticsearch")
 *             .elasticsearchConfiguration(FirehoseDeliveryStreamElasticsearchConfigurationArgs.builder()
 *                 .domainArn(testCluster.arn())
 *                 .roleArn(firehoseRole.arn())
 *                 .indexName("test")
 *                 .typeName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(firehoseRole.arn())
 *                     .bucketArn(bucket.arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .processingConfiguration(FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgs.builder()
 *                         .type("Lambda")
 *                         .parameters(FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                             .parameterName("LambdaArn")
 *                             .parameterValue(String.format("%s:$LATEST", lambdaProcessor.arn()))
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testCluster:
 *     type: aws:elasticsearch:Domain
 *     name: test_cluster
 *     properties:
 *       domainName: firehose-es-test
 *   testStream:
 *     type: aws:kinesis:FirehoseDeliveryStream
 *     name: test_stream
 *     properties:
 *       name: kinesis-firehose-test-stream
 *       destination: elasticsearch
 *       elasticsearchConfiguration:
 *         domainArn: ${testCluster.arn}
 *         roleArn: ${firehoseRole.arn}
 *         indexName: test
 *         typeName: test
 *         s3Configuration:
 *           roleArn: ${firehoseRole.arn}
 *           bucketArn: ${bucket.arn}
 *           bufferingSize: 10
 *           bufferingInterval: 400
 *           compressionFormat: GZIP
 *         processingConfiguration:
 *           enabled: 'true'
 *           processors:
 *             - type: Lambda
 *               parameters:
 *                 - parameterName: LambdaArn
 *                   parameterValue: ${lambdaProcessor.arn}:$LATEST
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Elasticsearch Destination With VPC
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testCluster = new aws.elasticsearch.Domain("test_cluster", {
 *     domainName: "es-test",
 *     clusterConfig: {
 *         instanceCount: 2,
 *         zoneAwarenessEnabled: true,
 *         instanceType: "t2.small.elasticsearch",
 *     },
 *     ebsOptions: {
 *         ebsEnabled: true,
 *         volumeSize: 10,
 *     },
 *     vpcOptions: {
 *         securityGroupIds: [first&#46;id],
 *         subnetIds: [
 *             firstAwsSubnet.id,
 *             second.id,
 *         ],
 *     },
 * });
 * const firehose-elasticsearch = aws.iam.getPolicyDocumentOutput({
 *     statements: [
 *         {
 *             effect: "Allow",
 *             actions: ["es:*"],
 *             resources: [
 *                 testCluster.arn,
 *                 pulumi.interpolate`${testCluster.arn}/*`,
 *             ],
 *         },
 *         {
 *             effect: "Allow",
 *             actions: [
 *                 "ec2:DescribeVpcs",
 *                 "ec2:DescribeVpcAttribute",
 *                 "ec2:DescribeSubnets",
 *                 "ec2:DescribeSecurityGroups",
 *                 "ec2:DescribeNetworkInterfaces",
 *                 "ec2:CreateNetworkInterface",
 *                 "ec2:CreateNetworkInterfacePermission",
 *                 "ec2:DeleteNetworkInterface",
 *             ],
 *             resources: ["*"],
 *         },
 *     ],
 * });
 * const firehose_elasticsearchRolePolicy = new aws.iam.RolePolicy("firehose-elasticsearch", {
 *     name: "elasticsearch",
 *     role: firehose.id,
 *     policy: firehose_elasticsearch.apply(firehose_elasticsearch => firehose_elasticsearch.json),
 * });
 * const test = new aws.kinesis.FirehoseDeliveryStream("test", {
 *     name: "kinesis-firehose-es",
 *     destination: "elasticsearch",
 *     elasticsearchConfiguration: {
 *         domainArn: testCluster.arn,
 *         roleArn: firehose.arn,
 *         indexName: "test",
 *         typeName: "test",
 *         s3Configuration: {
 *             roleArn: firehose.arn,
 *             bucketArn: bucket.arn,
 *         },
 *         vpcConfig: {
 *             subnetIds: [
 *                 firstAwsSubnet.id,
 *                 second.id,
 *             ],
 *             securityGroupIds: [first&#46;id],
 *             roleArn: firehose.arn,
 *         },
 *     },
 * }, {
 *     dependsOn: [firehose_elasticsearchRolePolicy],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_cluster = aws.elasticsearch.Domain("test_cluster",
 *     domain_name="es-test",
 *     cluster_config={
 *         "instance_count": 2,
 *         "zone_awareness_enabled": True,
 *         "instance_type": "t2.small.elasticsearch",
 *     },
 *     ebs_options={
 *         "ebs_enabled": True,
 *         "volume_size": 10,
 *     },
 *     vpc_options={
 *         "security_group_ids": [first["id"]],
 *         "subnet_ids": [
 *             first_aws_subnet["id"],
 *             second["id"],
 *         ],
 *     })
 * firehose_elasticsearch = aws.iam.get_policy_document_output(statements=[
 *     {
 *         "effect": "Allow",
 *         "actions": ["es:*"],
 *         "resources": [
 *             test_cluster.arn,
 *             test_cluster.arn.apply(lambda arn: f"{arn}/*"),
 *         ],
 *     },
 *     {
 *         "effect": "Allow",
 *         "actions": [
 *             "ec2:DescribeVpcs",
 *             "ec2:DescribeVpcAttribute",
 *             "ec2:DescribeSubnets",
 *             "ec2:DescribeSecurityGroups",
 *             "ec2:DescribeNetworkInterfaces",
 *             "ec2:CreateNetworkInterface",
 *             "ec2:CreateNetworkInterfacePermission",
 *             "ec2:DeleteNetworkInterface",
 *         ],
 *         "resources": ["*"],
 *     },
 * ])
 * firehose_elasticsearch_role_policy = aws.iam.RolePolicy("firehose-elasticsearch",
 *     name="elasticsearch",
 *     role=firehose["id"],
 *     policy=firehose_elasticsearch.json)
 * test = aws.kinesis.FirehoseDeliveryStream("test",
 *     name="kinesis-firehose-es",
 *     destination="elasticsearch",
 *     elasticsearch_configuration={
 *         "domain_arn": test_cluster.arn,
 *         "role_arn": firehose["arn"],
 *         "index_name": "test",
 *         "type_name": "test",
 *         "s3_configuration": {
 *             "role_arn": firehose["arn"],
 *             "bucket_arn": bucket["arn"],
 *         },
 *         "vpc_config": {
 *             "subnet_ids": [
 *                 first_aws_subnet["id"],
 *                 second["id"],
 *             ],
 *             "security_group_ids": [first["id"]],
 *             "role_arn": firehose["arn"],
 *         },
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[firehose_elasticsearch_role_policy]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testCluster = new Aws.ElasticSearch.Domain("test_cluster", new()
 *     {
 *         DomainName = "es-test",
 *         ClusterConfig = new Aws.ElasticSearch.Inputs.DomainClusterConfigArgs
 *         {
 *             InstanceCount = 2,
 *             ZoneAwarenessEnabled = true,
 *             InstanceType = "t2.small.elasticsearch",
 *         },
 *         EbsOptions = new Aws.ElasticSearch.Inputs.DomainEbsOptionsArgs
 *         {
 *             EbsEnabled = true,
 *             VolumeSize = 10,
 *         },
 *         VpcOptions = new Aws.ElasticSearch.Inputs.DomainVpcOptionsArgs
 *         {
 *             SecurityGroupIds = new[]
 *             {
 *                 first.Id,
 *             },
 *             SubnetIds = new[]
 *             {
 *                 firstAwsSubnet.Id,
 *                 second.Id,
 *             },
 *         },
 *     });
 *     var firehose_elasticsearch = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "es:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     testCluster.Arn,
 *                     $"{testCluster.Arn}/*",
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "ec2:DescribeVpcs",
 *                     "ec2:DescribeVpcAttribute",
 *                     "ec2:DescribeSubnets",
 *                     "ec2:DescribeSecurityGroups",
 *                     "ec2:DescribeNetworkInterfaces",
 *                     "ec2:CreateNetworkInterface",
 *                     "ec2:CreateNetworkInterfacePermission",
 *                     "ec2:DeleteNetworkInterface",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var firehose_elasticsearchRolePolicy = new Aws.Iam.RolePolicy("firehose-elasticsearch", new()
 *     {
 *         Name = "elasticsearch",
 *         Role = firehose.Id,
 *         Policy = firehose_elasticsearch.Apply(firehose_elasticsearch => firehose_elasticsearch.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json)),
 *     });
 *     var test = new Aws.Kinesis.FirehoseDeliveryStream("test", new()
 *     {
 *         Name = "kinesis-firehose-es",
 *         Destination = "elasticsearch",
 *         ElasticsearchConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgs
 *         {
 *             DomainArn = testCluster.Arn,
 *             RoleArn = firehose.Arn,
 *             IndexName = "test",
 *             TypeName = "test",
 *             S3Configuration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs
 *             {
 *                 RoleArn = firehose.Arn,
 *                 BucketArn = bucket.Arn,
 *             },
 *             VpcConfig = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs
 *             {
 *                 SubnetIds = new[]
 *                 {
 *                     firstAwsSubnet.Id,
 *                     second.Id,
 *                 },
 *                 SecurityGroupIds = new[]
 *                 {
 *                     first.Id,
 *                 },
 *                 RoleArn = firehose.Arn,
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             firehose_elasticsearchRolePolicy,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticsearch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testCluster, err := elasticsearch.NewDomain(ctx, "test_cluster", &elasticsearch.DomainArgs{
 * 			DomainName: pulumi.String("es-test"),
 * 			ClusterConfig: &elasticsearch.DomainClusterConfigArgs{
 * 				InstanceCount:        pulumi.Int(2),
 * 				ZoneAwarenessEnabled: pulumi.Bool(true),
 * 				InstanceType:         pulumi.String("t2.small.elasticsearch"),
 * 			},
 * 			EbsOptions: &elasticsearch.DomainEbsOptionsArgs{
 * 				EbsEnabled: pulumi.Bool(true),
 * 				VolumeSize: pulumi.Int(10),
 * 			},
 * 			VpcOptions: &elasticsearch.DomainVpcOptionsArgs{
 * 				SecurityGroupIds: pulumi.StringArray{
 * 					first.Id,
 * 				},
 * 				SubnetIds: pulumi.StringArray{
 * 					firstAwsSubnet.Id,
 * 					second.Id,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		firehose_elasticsearch := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("es:*"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						testCluster.Arn,
 * 						testCluster.Arn.ApplyT(func(arn string) (string, error) {
 * 							return fmt.Sprintf("%v/*", arn), nil
 * 						}).(pulumi.StringOutput),
 * 					},
 * 				},
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("ec2:DescribeVpcs"),
 * 						pulumi.String("ec2:DescribeVpcAttribute"),
 * 						pulumi.String("ec2:DescribeSubnets"),
 * 						pulumi.String("ec2:DescribeSecurityGroups"),
 * 						pulumi.String("ec2:DescribeNetworkInterfaces"),
 * 						pulumi.String("ec2:CreateNetworkInterface"),
 * 						pulumi.String("ec2:CreateNetworkInterfacePermission"),
 * 						pulumi.String("ec2:DeleteNetworkInterface"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = iam.NewRolePolicy(ctx, "firehose-elasticsearch", &iam.RolePolicyArgs{
 * 			Name: pulumi.String("elasticsearch"),
 * 			Role: pulumi.Any(firehose.Id),
 * 			Policy: pulumi.String(firehose_elasticsearch.ApplyT(func(firehose_elasticsearch iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &firehose_elasticsearch.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kinesis.NewFirehoseDeliveryStream(ctx, "test", &kinesis.FirehoseDeliveryStreamArgs{
 * 			Name:        pulumi.String("kinesis-firehose-es"),
 * 			Destination: pulumi.String("elasticsearch"),
 * 			ElasticsearchConfiguration: &kinesis.FirehoseDeliveryStreamElasticsearchConfigurationArgs{
 * 				DomainArn: testCluster.Arn,
 * 				RoleArn:   pulumi.Any(firehose.Arn),
 * 				IndexName: pulumi.String("test"),
 * 				TypeName:  pulumi.String("test"),
 * 				S3Configuration: &kinesis.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs{
 * 					RoleArn:   pulumi.Any(firehose.Arn),
 * 					BucketArn: pulumi.Any(bucket.Arn),
 * 				},
 * 				VpcConfig: &kinesis.FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs{
 * 					SubnetIds: pulumi.StringArray{
 * 						firstAwsSubnet.Id,
 * 						second.Id,
 * 					},
 * 					SecurityGroupIds: pulumi.StringArray{
 * 						first.Id,
 * 					},
 * 					RoleArn: pulumi.Any(firehose.Arn),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			firehose_elasticsearchRolePolicy,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainEbsOptionsArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainVpcOptionsArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Domain("testCluster", DomainArgs.builder()
 *             .domainName("es-test")
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceCount(2)
 *                 .zoneAwarenessEnabled(true)
 *                 .instanceType("t2.small.elasticsearch")
 *                 .build())
 *             .ebsOptions(DomainEbsOptionsArgs.builder()
 *                 .ebsEnabled(true)
 *                 .volumeSize(10)
 *                 .build())
 *             .vpcOptions(DomainVpcOptionsArgs.builder()
 *                 .securityGroupIds(first.id())
 *                 .subnetIds(
 *                     firstAwsSubnet.id(),
 *                     second.id())
 *                 .build())
 *             .build());
 *         final var firehose-elasticsearch = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("es:*")
 *                     .resources(
 *                         testCluster.arn(),
 *                         testCluster.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "ec2:DescribeVpcs",
 *                         "ec2:DescribeVpcAttribute",
 *                         "ec2:DescribeSubnets",
 *                         "ec2:DescribeSecurityGroups",
 *                         "ec2:DescribeNetworkInterfaces",
 *                         "ec2:CreateNetworkInterface",
 *                         "ec2:CreateNetworkInterfacePermission",
 *                         "ec2:DeleteNetworkInterface")
 *                     .resources("*")
 *                     .build())
 *             .build());
 *         var firehose_elasticsearchRolePolicy = new RolePolicy("firehose-elasticsearchRolePolicy", RolePolicyArgs.builder()
 *             .name("elasticsearch")
 *             .role(firehose.id())
 *             .policy(firehose_elasticsearch.applyValue(firehose_elasticsearch -> firehose_elasticsearch.json()))
 *             .build());
 *         var test = new FirehoseDeliveryStream("test", FirehoseDeliveryStreamArgs.builder()
 *             .name("kinesis-firehose-es")
 *             .destination("elasticsearch")
 *             .elasticsearchConfiguration(FirehoseDeliveryStreamElasticsearchConfigurationArgs.builder()
 *                 .domainArn(testCluster.arn())
 *                 .roleArn(firehose.arn())
 *                 .indexName("test")
 *                 .typeName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(firehose.arn())
 *                     .bucketArn(bucket.arn())
 *                     .build())
 *                 .vpcConfig(FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs.builder()
 *                     .subnetIds(
 *                         firstAwsSubnet.id(),
 *                         second.id())
 *                     .securityGroupIds(first.id())
 *                     .roleArn(firehose.arn())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(firehose_elasticsearchRolePolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testCluster:
 *     type: aws:elasticsearch:Domain
 *     name: test_cluster
 *     properties:
 *       domainName: es-test
 *       clusterConfig:
 *         instanceCount: 2
 *         zoneAwarenessEnabled: true
 *         instanceType: t2.small.elasticsearch
 *       ebsOptions:
 *         ebsEnabled: true
 *         volumeSize: 10
 *       vpcOptions:
 *         securityGroupIds:
 *           - ${first.id}
 *         subnetIds:
 *           - ${firstAwsSubnet.id}
 *           - ${second.id}
 *   firehose-elasticsearchRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: firehose-elasticsearch
 *     properties:
 *       name: elasticsearch
 *       role: ${firehose.id}
 *       policy: ${["firehose-elasticsearch"].json}
 *   test:
 *     type: aws:kinesis:FirehoseDeliveryStream
 *     properties:
 *       name: kinesis-firehose-es
 *       destination: elasticsearch
 *       elasticsearchConfiguration:
 *         domainArn: ${testCluster.arn}
 *         roleArn: ${firehose.arn}
 *         indexName: test
 *         typeName: test
 *         s3Configuration:
 *           roleArn: ${firehose.arn}
 *           bucketArn: ${bucket.arn}
 *         vpcConfig:
 *           subnetIds:
 *             - ${firstAwsSubnet.id}
 *             - ${second.id}
 *           securityGroupIds:
 *             - ${first.id}
 *           roleArn: ${firehose.arn}
 *     options:
 *       dependson:
 *         - ${["firehose-elasticsearchRolePolicy"]}
 * variables:
 *   firehose-elasticsearch:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - es:*
 *             resources:
 *               - ${testCluster.arn}
 *               - ${testCluster.arn}/*
 *           - effect: Allow
 *             actions:
 *               - ec2:DescribeVpcs
 *               - ec2:DescribeVpcAttribute
 *               - ec2:DescribeSubnets
 *               - ec2:DescribeSecurityGroups
 *               - ec2:DescribeNetworkInterfaces
 *               - ec2:CreateNetworkInterface
 *               - ec2:CreateNetworkInterfacePermission
 *               - ec2:DeleteNetworkInterface
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### OpenSearch Destination
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testCluster = new aws.opensearch.Domain("test_cluster", {domainName: "firehose-os-test"});
 * const testStream = new aws.kinesis.FirehoseDeliveryStream("test_stream", {
 *     name: "kinesis-firehose-test-stream",
 *     destination: "opensearch",
 *     opensearchConfiguration: {
 *         domainArn: testCluster.arn,
 *         roleArn: firehoseRole.arn,
 *         indexName: "test",
 *         s3Configuration: {
 *             roleArn: firehoseRole.arn,
 *             bucketArn: bucket.arn,
 *             bufferingSize: 10,
 *             bufferingInterval: 400,
 *             compressionFormat: "GZIP",
 *         },
 *         processingConfiguration: {
 *             enabled: true,
 *             processors: [{
 *                 type: "Lambda",
 *                 parameters: [{
 *                     parameterName: "LambdaArn",
 *                     parameterValue: `${lambdaProcessor.arn}:$LATEST`,
 *                 }],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_cluster = aws.opensearch.Domain("test_cluster", domain_name="firehose-os-test")
 * test_stream = aws.kinesis.FirehoseDeliveryStream("test_stream",
 *     name="kinesis-firehose-test-stream",
 *     destination="opensearch",
 *     opensearch_configuration={
 *         "domain_arn": test_cluster.arn,
 *         "role_arn": firehose_role["arn"],
 *         "index_name": "test",
 *         "s3_configuration": {
 *             "role_arn": firehose_role["arn"],
 *             "bucket_arn": bucket["arn"],
 *             "buffering_size": 10,
 *             "buffering_interval": 400,
 *             "compression_format": "GZIP",
 *         },
 *         "processing_configuration": {
 *             "enabled": True,
 *             "processors": [{
 *                 "type": "Lambda",
 *                 "parameters": [{
 *                     "parameter_name": "LambdaArn",
 *                     "parameter_value": f"{lambda_processor['arn']}:$LATEST",
 *                 }],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testCluster = new Aws.OpenSearch.Domain("test_cluster", new()
 *     {
 *         DomainName = "firehose-os-test",
 *     });
 *     var testStream = new Aws.Kinesis.FirehoseDeliveryStream("test_stream", new()
 *     {
 *         Name = "kinesis-firehose-test-stream",
 *         Destination = "opensearch",
 *         OpensearchConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs
 *         {
 *             DomainArn = testCluster.Arn,
 *             RoleArn = firehoseRole.Arn,
 *             IndexName = "test",
 *             S3Configuration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs
 *             {
 *                 RoleArn = firehoseRole.Arn,
 *                 BucketArn = bucket.Arn,
 *                 BufferingSize = 10,
 *                 BufferingInterval = 400,
 *                 CompressionFormat = "GZIP",
 *             },
 *             ProcessingConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs
 *             {
 *                 Enabled = true,
 *                 Processors = new[]
 *                 {
 *                     new Aws.Kinesis.Inputs.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs
 *                     {
 *                         Type = "Lambda",
 *                         Parameters = new[]
 *                         {
 *                             new Aws.Kinesis.Inputs.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgs
 *                             {
 *                                 ParameterName = "LambdaArn",
 *                                 ParameterValue = $"{lambdaProcessor.Arn}:$LATEST",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testCluster, err := opensearch.NewDomain(ctx, "test_cluster", &opensearch.DomainArgs{
 * 			DomainName: pulumi.String("firehose-os-test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kinesis.NewFirehoseDeliveryStream(ctx, "test_stream", &kinesis.FirehoseDeliveryStreamArgs{
 * 			Name:        pulumi.String("kinesis-firehose-test-stream"),
 * 			Destination: pulumi.String("opensearch"),
 * 			OpensearchConfiguration: &kinesis.FirehoseDeliveryStreamOpensearchConfigurationArgs{
 * 				DomainArn: testCluster.Arn,
 * 				RoleArn:   pulumi.Any(firehoseRole.Arn),
 * 				IndexName: pulumi.String("test"),
 * 				S3Configuration: &kinesis.FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs{
 * 					RoleArn:           pulumi.Any(firehoseRole.Arn),
 * 					BucketArn:         pulumi.Any(bucket.Arn),
 * 					BufferingSize:     pulumi.Int(10),
 * 					BufferingInterval: pulumi.Int(400),
 * 					CompressionFormat: pulumi.String("GZIP"),
 * 				},
 * 				ProcessingConfiguration: &kinesis.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs{
 * 					Enabled: pulumi.Bool(true),
 * 					Processors: kinesis.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArray{
 * 						&kinesis.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs{
 * 							Type: pulumi.String("Lambda"),
 * 							Parameters: kinesis.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArray{
 * 								&kinesis.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgs{
 * 									ParameterName:  pulumi.String("LambdaArn"),
 * 									ParameterValue: pulumi.Sprintf("%v:$LATEST", lambdaProcessor.Arn),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Domain("testCluster", DomainArgs.builder()
 *             .domainName("firehose-os-test")
 *             .build());
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .name("kinesis-firehose-test-stream")
 *             .destination("opensearch")
 *             .opensearchConfiguration(FirehoseDeliveryStreamOpensearchConfigurationArgs.builder()
 *                 .domainArn(testCluster.arn())
 *                 .roleArn(firehoseRole.arn())
 *                 .indexName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(firehoseRole.arn())
 *                     .bucketArn(bucket.arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .processingConfiguration(FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs.builder()
 *                         .type("Lambda")
 *                         .parameters(FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                             .parameterName("LambdaArn")
 *                             .parameterValue(String.format("%s:$LATEST", lambdaProcessor.arn()))
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testCluster:
 *     type: aws:opensearch:Domain
 *     name: test_cluster
 *     properties:
 *       domainName: firehose-os-test
 *   testStream:
 *     type: aws:kinesis:FirehoseDeliveryStream
 *     name: test_stream
 *     properties:
 *       name: kinesis-firehose-test-stream
 *       destination: opensearch
 *       opensearchConfiguration:
 *         domainArn: ${testCluster.arn}
 *         roleArn: ${firehoseRole.arn}
 *         indexName: test
 *         s3Configuration:
 *           roleArn: ${firehoseRole.arn}
 *           bucketArn: ${bucket.arn}
 *           bufferingSize: 10
 *           bufferingInterval: 400
 *           compressionFormat: GZIP
 *         processingConfiguration:
 *           enabled: 'true'
 *           processors:
 *             - type: Lambda
 *               parameters:
 *                 - parameterName: LambdaArn
 *                   parameterValue: ${lambdaProcessor.arn}:$LATEST
 * ```
 * <!--End PulumiCodeChooser -->
 * ### OpenSearch Destination With VPC
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testCluster = new aws.opensearch.Domain("test_cluster", {
 *     domainName: "es-test",
 *     clusterConfig: {
 *         instanceCount: 2,
 *         zoneAwarenessEnabled: true,
 *         instanceType: "m4.large.search",
 *     },
 *     ebsOptions: {
 *         ebsEnabled: true,
 *         volumeSize: 10,
 *     },
 *     vpcOptions: {
 *         securityGroupIds: [first&#46;id],
 *         subnetIds: [
 *             firstAwsSubnet.id,
 *             second.id,
 *         ],
 *     },
 * });
 * const firehose_opensearch = new aws.iam.RolePolicy("firehose-opensearch", {
 *     name: "opensearch",
 *     role: firehose.id,
 *     policy: pulumi.interpolate`{
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Effect": "Allow",
 *       "Action": [
 *         "es:*"
 *       ],
 *       "Resource": [
 *         "${testCluster.arn}",
 *         "${testCluster.arn}/*"
 *       ]
 *         },
 *         {
 *           "Effect": "Allow",
 *           "Action": [
 *             "ec2:DescribeVpcs",
 *             "ec2:DescribeVpcAttribute",
 *             "ec2:DescribeSubnets",
 *             "ec2:DescribeSecurityGroups",
 *             "ec2:DescribeNetworkInterfaces",
 *             "ec2:CreateNetworkInterface",
 *             "ec2:CreateNetworkInterfacePermission",
 *             "ec2:DeleteNetworkInterface"
 *           ],
 *           "Resource": [
 *             "*"
 *           ]
 *         }
 *   ]
 * }
 * `,
 * });
 * const test = new aws.kinesis.FirehoseDeliveryStream("test", {
 *     name: "pulumi-kinesis-firehose-os",
 *     destination: "opensearch",
 *     opensearchConfiguration: {
 *         domainArn: testCluster.arn,
 *         roleArn: firehose.arn,
 *         indexName: "test",
 *         s3Configuration: {
 *             roleArn: firehose.arn,
 *             bucketArn: bucket.arn,
 *         },
 *         vpcConfig: {
 *             subnetIds: [
 *                 firstAwsSubnet.id,
 *                 second.id,
 *             ],
 *             securityGroupIds: [first&#46;id],
 *             roleArn: firehose.arn,
 *         },
 *     },
 * }, {
 *     dependsOn: [firehose_opensearch],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_cluster = aws.opensearch.Domain("test_cluster",
 *     domain_name="es-test",
 *     cluster_config={
 *         "instance_count": 2,
 *         "zone_awareness_enabled": True,
 *         "instance_type": "m4.large.search",
 *     },
 *     ebs_options={
 *         "ebs_enabled": True,
 *         "volume_size": 10,
 *     },
 *     vpc_options={
 *         "security_group_ids": [first["id"]],
 *         "subnet_ids": [
 *             first_aws_subnet["id"],
 *             second["id"],
 *         ],
 *     })
 * firehose_opensearch = aws.iam.RolePolicy("firehose-opensearch",
 *     name="opensearch",
 *     role=firehose["id"],
 *     policy=pulumi.Output.all(test_cluster.arn, test_cluster.arn).apply(lambda testClusterArn, testClusterArn1: f"""{{
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {{
 *       "Effect": "Allow",
 *       "Action": [
 *         "es:*"
 *       ],
 *       "Resource": [
 *         "{test_cluster_arn}",
 *         "{test_cluster_arn1}/*"
 *       ]
 *         }},
 *         {{
 *           "Effect": "Allow",
 *           "Action": [
 *             "ec2:DescribeVpcs",
 *             "ec2:DescribeVpcAttribute",
 *             "ec2:DescribeSubnets",
 *             "ec2:DescribeSecurityGroups",
 *             "ec2:DescribeNetworkInterfaces",
 *             "ec2:CreateNetworkInterface",
 *             "ec2:CreateNetworkInterfacePermission",
 *             "ec2:DeleteNetworkInterface"
 *           ],
 *           "Resource": [
 *             "*"
 *           ]
 *         }}
 *   ]
 * }}
 * """))
 * test = aws.kinesis.FirehoseDeliveryStream("test",
 *     name="pulumi-kinesis-firehose-os",
 *     destination="opensearch",
 *     opensearch_configuration={
 *         "domain_arn": test_cluster.arn,
 *         "role_arn": firehose["arn"],
 *         "index_name": "test",
 *         "s3_configuration": {
 *             "role_arn": firehose["arn"],
 *             "bucket_arn": bucket["arn"],
 *         },
 *         "vpc_config": {
 *             "subnet_ids": [
 *                 first_aws_subnet["id"],
 *                 second["id"],
 *             ],
 *             "security_group_ids": [first["id"]],
 *             "role_arn": firehose["arn"],
 *         },
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[firehose_opensearch]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testCluster = new Aws.OpenSearch.Domain("test_cluster", new()
 *     {
 *         DomainName = "es-test",
 *         ClusterConfig = new Aws.OpenSearch.Inputs.DomainClusterConfigArgs
 *         {
 *             InstanceCount = 2,
 *             ZoneAwarenessEnabled = true,
 *             InstanceType = "m4.large.search",
 *         },
 *         EbsOptions = new Aws.OpenSearch.Inputs.DomainEbsOptionsArgs
 *         {
 *             EbsEnabled = true,
 *             VolumeSize = 10,
 *         },
 *         VpcOptions = new Aws.OpenSearch.Inputs.DomainVpcOptionsArgs
 *         {
 *             SecurityGroupIds = new[]
 *             {
 *                 first.Id,
 *             },
 *             SubnetIds = new[]
 *             {
 *                 firstAwsSubnet.Id,
 *                 second.Id,
 *             },
 *         },
 *     });
 *     var firehose_opensearch = new Aws.Iam.RolePolicy("firehose-opensearch", new()
 *     {
 *         Name = "opensearch",
 *         Role = firehose.Id,
 *         Policy = Output.Tuple(testCluster.Arn, testCluster.Arn).Apply(values =>
 *         {
 *             var testClusterArn = values.Item1;
 *             var testClusterArn1 = values.Item2;
 *             return @$"{{
 *   ""Version"": ""2012-10-17"",
 *   ""Statement"": [
 *     {{
 *       ""Effect"": ""Allow"",
 *       ""Action"": [
 *         ""es:*""
 *       ],
 *       ""Resource"": [
 *         ""{testClusterArn}"",
 *         ""{testClusterArn1}/*""
 *       ]
 *         }},
 *         {{
 *           ""Effect"": ""Allow"",
 *           ""Action"": [
 *             ""ec2:DescribeVpcs"",
 *             ""ec2:DescribeVpcAttribute"",
 *             ""ec2:DescribeSubnets"",
 *             ""ec2:DescribeSecurityGroups"",
 *             ""ec2:DescribeNetworkInterfaces"",
 *             ""ec2:CreateNetworkInterface"",
 *             ""ec2:CreateNetworkInterfacePermission"",
 *             ""ec2:DeleteNetworkInterface""
 *           ],
 *           ""Resource"": [
 *             ""*""
 *           ]
 *         }}
 *   ]
 * }}
 * ";
 *         }),
 *     });
 *     var test = new Aws.Kinesis.FirehoseDeliveryStream("test", new()
 *     {
 *         Name = "pulumi-kinesis-firehose-os",
 *         Destination = "opensearch",
 *         OpensearchConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs
 *         {
 *             DomainArn = testCluster.Arn,
 *             RoleArn = firehose.Arn,
 *             IndexName = "test",
 *             S3Configuration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs
 *             {
 *                 RoleArn = firehose.Arn,
 *                 BucketArn = bucket.Arn,
 *             },
 *             VpcConfig = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs
 *             {
 *                 SubnetIds = new[]
 *                 {
 *                     firstAwsSubnet.Id,
 *                     second.Id,
 *                 },
 *                 SecurityGroupIds = new[]
 *                 {
 *                     first.Id,
 *                 },
 *                 RoleArn = firehose.Arn,
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             firehose_opensearch,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testCluster, err := opensearch.NewDomain(ctx, "test_cluster", &opensearch.DomainArgs{
 * 			DomainName: pulumi.String("es-test"),
 * 			ClusterConfig: &opensearch.DomainClusterConfigArgs{
 * 				InstanceCount:        pulumi.Int(2),
 * 				ZoneAwarenessEnabled: pulumi.Bool(true),
 * 				InstanceType:         pulumi.String("m4.large.search"),
 * 			},
 * 			EbsOptions: &opensearch.DomainEbsOptionsArgs{
 * 				EbsEnabled: pulumi.Bool(true),
 * 				VolumeSize: pulumi.Int(10),
 * 			},
 * 			VpcOptions: &opensearch.DomainVpcOptionsArgs{
 * 				SecurityGroupIds: pulumi.StringArray{
 * 					first.Id,
 * 				},
 * 				SubnetIds: pulumi.StringArray{
 * 					firstAwsSubnet.Id,
 * 					second.Id,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicy(ctx, "firehose-opensearch", &iam.RolePolicyArgs{
 * 			Name: pulumi.String("opensearch"),
 * 			Role: pulumi.Any(firehose.Id),
 * 			Policy: pulumi.All(testCluster.Arn, testCluster.Arn).ApplyT(func(_args []interface{}) (string, error) {
 * 				testClusterArn := _args[0].(string)
 * 				testClusterArn1 := _args[1].(string)
 * 				return fmt.Sprintf(`{
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Effect": "Allow",
 *       "Action": [
 *         "es:*"
 *       ],
 *       "Resource": [
 *         "%v",
 *         "%v/*"
 *       ]
 *         },
 *         {
 *           "Effect": "Allow",
 *           "Action": [
 *             "ec2:DescribeVpcs",
 *             "ec2:DescribeVpcAttribute",
 *             "ec2:DescribeSubnets",
 *             "ec2:DescribeSecurityGroups",
 *             "ec2:DescribeNetworkInterfaces",
 *             "ec2:CreateNetworkInterface",
 *             "ec2:CreateNetworkInterfacePermission",
 *             "ec2:DeleteNetworkInterface"
 *           ],
 *           "Resource": [
 *             "*"
 *           ]
 *         }
 *   ]
 * }
 * `, testClusterArn, testClusterArn1), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kinesis.NewFirehoseDeliveryStream(ctx, "test", &kinesis.FirehoseDeliveryStreamArgs{
 * 			Name:        pulumi.String("pulumi-kinesis-firehose-os"),
 * 			Destination: pulumi.String("opensearch"),
 * 			OpensearchConfiguration: &kinesis.FirehoseDeliveryStreamOpensearchConfigurationArgs{
 * 				DomainArn: testCluster.Arn,
 * 				RoleArn:   pulumi.Any(firehose.Arn),
 * 				IndexName: pulumi.String("test"),
 * 				S3Configuration: &kinesis.FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs{
 * 					RoleArn:   pulumi.Any(firehose.Arn),
 * 					BucketArn: pulumi.Any(bucket.Arn),
 * 				},
 * 				VpcConfig: &kinesis.FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs{
 * 					SubnetIds: pulumi.StringArray{
 * 						firstAwsSubnet.Id,
 * 						second.Id,
 * 					},
 * 					SecurityGroupIds: pulumi.StringArray{
 * 						first.Id,
 * 					},
 * 					RoleArn: pulumi.Any(firehose.Arn),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			firehose_opensearch,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainEbsOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainVpcOptionsArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Domain("testCluster", DomainArgs.builder()
 *             .domainName("es-test")
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceCount(2)
 *                 .zoneAwarenessEnabled(true)
 *                 .instanceType("m4.large.search")
 *                 .build())
 *             .ebsOptions(DomainEbsOptionsArgs.builder()
 *                 .ebsEnabled(true)
 *                 .volumeSize(10)
 *                 .build())
 *             .vpcOptions(DomainVpcOptionsArgs.builder()
 *                 .securityGroupIds(first.id())
 *                 .subnetIds(
 *                     firstAwsSubnet.id(),
 *                     second.id())
 *                 .build())
 *             .build());
 *         var firehose_opensearch = new RolePolicy("firehose-opensearch", RolePolicyArgs.builder()
 *             .name("opensearch")
 *             .role(firehose.id())
 *             .policy(Output.tuple(testCluster.arn(), testCluster.arn()).applyValue(values -> {
 *                 var testClusterArn = values.t1;
 *                 var testClusterArn1 = values.t2;
 *                 return """
 * {
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Effect": "Allow",
 *       "Action": [
 *         "es:*"
 *       ],
 *       "Resource": [
 *         "%s",
 *         "%s/*"
 *       ]
 *         },
 *         {
 *           "Effect": "Allow",
 *           "Action": [
 *             "ec2:DescribeVpcs",
 *             "ec2:DescribeVpcAttribute",
 *             "ec2:DescribeSubnets",
 *             "ec2:DescribeSecurityGroups",
 *             "ec2:DescribeNetworkInterfaces",
 *             "ec2:CreateNetworkInterface",
 *             "ec2:CreateNetworkInterfacePermission",
 *             "ec2:DeleteNetworkInterface"
 *           ],
 *           "Resource": [
 *             "*"
 *           ]
 *         }
 *   ]
 * }
 * ", testClusterArn,testClusterArn1);
 *             }))
 *             .build());
 *         var test = new FirehoseDeliveryStream("test", FirehoseDeliveryStreamArgs.builder()
 *             .name("pulumi-kinesis-firehose-os")
 *             .destination("opensearch")
 *             .opensearchConfiguration(FirehoseDeliveryStreamOpensearchConfigurationArgs.builder()
 *                 .domainArn(testCluster.arn())
 *                 .roleArn(firehose.arn())
 *                 .indexName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(firehose.arn())
 *                     .bucketArn(bucket.arn())
 *                     .build())
 *                 .vpcConfig(FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs.builder()
 *                     .subnetIds(
 *                         firstAwsSubnet.id(),
 *                         second.id())
 *                     .securityGroupIds(first.id())
 *                     .roleArn(firehose.arn())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(firehose_opensearch)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testCluster:
 *     type: aws:opensearch:Domain
 *     name: test_cluster
 *     properties:
 *       domainName: es-test
 *       clusterConfig:
 *         instanceCount: 2
 *         zoneAwarenessEnabled: true
 *         instanceType: m4.large.search
 *       ebsOptions:
 *         ebsEnabled: true
 *         volumeSize: 10
 *       vpcOptions:
 *         securityGroupIds:
 *           - ${first.id}
 *         subnetIds:
 *           - ${firstAwsSubnet.id}
 *           - ${second.id}
 *   firehose-opensearch:
 *     type: aws:iam:RolePolicy
 *     properties:
 *       name: opensearch
 *       role: ${firehose.id}
 *       policy: |
 *         {
 *           "Version": "2012-10-17",
 *           "Statement": [
 *             {
 *               "Effect": "Allow",
 *               "Action": [
 *                 "es:*"
 *               ],
 *               "Resource": [
 *                 "${testCluster.arn}",
 *                 "${testCluster.arn}/*"
 *               ]
 *                 },
 *                 {
 *                   "Effect": "Allow",
 *                   "Action": [
 *                     "ec2:DescribeVpcs",
 *                     "ec2:DescribeVpcAttribute",
 *                     "ec2:DescribeSubnets",
 *                     "ec2:DescribeSecurityGroups",
 *                     "ec2:DescribeNetworkInterfaces",
 *                     "ec2:CreateNetworkInterface",
 *                     "ec2:CreateNetworkInterfacePermission",
 *                     "ec2:DeleteNetworkInterface"
 *                   ],
 *                   "Resource": [
 *                     "*"
 *                   ]
 *                 }
 *           ]
 *         }
 *   test:
 *     type: aws:kinesis:FirehoseDeliveryStream
 *     properties:
 *       name: pulumi-kinesis-firehose-os
 *       destination: opensearch
 *       opensearchConfiguration:
 *         domainArn: ${testCluster.arn}
 *         roleArn: ${firehose.arn}
 *         indexName: test
 *         s3Configuration:
 *           roleArn: ${firehose.arn}
 *           bucketArn: ${bucket.arn}
 *         vpcConfig:
 *           subnetIds:
 *             - ${firstAwsSubnet.id}
 *             - ${second.id}
 *           securityGroupIds:
 *             - ${first.id}
 *           roleArn: ${firehose.arn}
 *     options:
 *       dependson:
 *         - ${["firehose-opensearch"]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### OpenSearch Serverless Destination
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testCollection = new aws.opensearch.ServerlessCollection("test_collection", {name: "firehose-osserverless-test"});
 * const testStream = new aws.kinesis.FirehoseDeliveryStream("test_stream", {
 *     name: "kinesis-firehose-test-stream",
 *     destination: "opensearchserverless",
 *     opensearchserverlessConfiguration: {
 *         collectionEndpoint: testCollection.collectionEndpoint,
 *         roleArn: firehoseRole.arn,
 *         indexName: "test",
 *         s3Configuration: {
 *             roleArn: firehoseRole.arn,
 *             bucketArn: bucket.arn,
 *             bufferingSize: 10,
 *             bufferingInterval: 400,
 *             compressionFormat: "GZIP",
 *         },
 *         processingConfiguration: {
 *             enabled: true,
 *             processors: [{
 *                 type: "Lambda",
 *                 parameters: [{
 *                     parameterName: "LambdaArn",
 *                     parameterValue: `${lambdaProcessor.arn}:$LATEST`,
 *                 }],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_collection = aws.opensearch.ServerlessCollection("test_collection", name="firehose-osserverless-test")
 * test_stream = aws.kinesis.FirehoseDeliveryStream("test_stream",
 *     name="kinesis-firehose-test-stream",
 *     destination="opensearchserverless",
 *     opensearchserverless_configuration={
 *         "collection_endpoint": test_collection.collection_endpoint,
 *         "role_arn": firehose_role["arn"],
 *         "index_name": "test",
 *         "s3_configuration": {
 *             "role_arn": firehose_role["arn"],
 *             "bucket_arn": bucket["arn"],
 *             "buffering_size": 10,
 *             "buffering_interval": 400,
 *             "compression_format": "GZIP",
 *         },
 *         "processing_configuration": {
 *             "enabled": True,
 *             "processors": [{
 *                 "type": "Lambda",
 *                 "parameters": [{
 *                     "parameter_name": "LambdaArn",
 *                     "parameter_value": f"{lambda_processor['arn']}:$LATEST",
 *                 }],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testCollection = new Aws.OpenSearch.ServerlessCollection("test_collection", new()
 *     {
 *         Name = "firehose-osserverless-test",
 *     });
 *     var testStream = new Aws.Kinesis.FirehoseDeliveryStream("test_stream", new()
 *     {
 *         Name = "kinesis-firehose-test-stream",
 *         Destination = "opensearchserverless",
 *         OpensearchserverlessConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs
 *         {
 *             CollectionEndpoint = testCollection.CollectionEndpoint,
 *             RoleArn = firehoseRole.Arn,
 *             IndexName = "test",
 *             S3Configuration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationS3ConfigurationArgs
 *             {
 *                 RoleArn = firehoseRole.Arn,
 *                 BucketArn = bucket.Arn,
 *                 BufferingSize = 10,
 *                 BufferingInterval = 400,
 *                 CompressionFormat = "GZIP",
 *             },
 *             ProcessingConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs
 *             {
 *                 Enabled = true,
 *                 Processors = new[]
 *                 {
 *                     new Aws.Kinesis.Inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs
 *                     {
 *                         Type = "Lambda",
 *                         Parameters = new[]
 *                         {
 *                             new Aws.Kinesis.Inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorParameterArgs
 *                             {
 *                                 ParameterName = "LambdaArn",
 *                                 ParameterValue = $"{lambdaProcessor.Arn}:$LATEST",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testCollection, err := opensearch.NewServerlessCollection(ctx, "test_collection", &opensearch.ServerlessCollectionArgs{
 * 			Name: pulumi.String("firehose-osserverless-test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kinesis.NewFirehoseDeliveryStream(ctx, "test_stream", &kinesis.FirehoseDeliveryStreamArgs{
 * 			Name:        pulumi.String("kinesis-firehose-test-stream"),
 * 			Destination: pulumi.String("opensearchserverless"),
 * 			OpensearchserverlessConfiguration: &kinesis.FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs{
 * 				CollectionEndpoint: testCollection.CollectionEndpoint,
 * 				RoleArn:            pulumi.Any(firehoseRole.Arn),
 * 				IndexName:          pulumi.String("test"),
 * 				S3Configuration: &kinesis.FirehoseDeliveryStreamOpensearchserverlessConfigurationS3ConfigurationArgs{
 * 					RoleArn:           pulumi.Any(firehoseRole.Arn),
 * 					BucketArn:         pulumi.Any(bucket.Arn),
 * 					BufferingSize:     pulumi.Int(10),
 * 					BufferingInterval: pulumi.Int(400),
 * 					CompressionFormat: pulumi.String("GZIP"),
 * 				},
 * 				ProcessingConfiguration: &kinesis.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs{
 * 					Enabled: pulumi.Bool(true),
 * 					Processors: kinesis.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArray{
 * 						&kinesis.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs{
 * 							Type: pulumi.String("Lambda"),
 * 							Parameters: kinesis.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorParameterArray{
 * 								&kinesis.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorParameterArgs{
 * 									ParameterName:  pulumi.String("LambdaArn"),
 * 									ParameterValue: pulumi.Sprintf("%v:$LATEST", lambdaProcessor.Arn),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessCollection;
 * import com.pulumi.aws.opensearch.ServerlessCollectionArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCollection = new ServerlessCollection("testCollection", ServerlessCollectionArgs.builder()
 *             .name("firehose-osserverless-test")
 *             .build());
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .name("kinesis-firehose-test-stream")
 *             .destination("opensearchserverless")
 *             .opensearchserverlessConfiguration(FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs.builder()
 *                 .collectionEndpoint(testCollection.collectionEndpoint())
 *                 .roleArn(firehoseRole.arn())
 *                 .indexName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamOpensearchserverlessConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(firehoseRole.arn())
 *                     .bucketArn(bucket.arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .processingConfiguration(FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs.builder()
 *                         .type("Lambda")
 *                         .parameters(FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                             .parameterName("LambdaArn")
 *                             .parameterValue(String.format("%s:$LATEST", lambdaProcessor.arn()))
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testCollection:
 *     type: aws:opensearch:ServerlessCollection
 *     name: test_collection
 *     properties:
 *       name: firehose-osserverless-test
 *   testStream:
 *     type: aws:kinesis:FirehoseDeliveryStream
 *     name: test_stream
 *     properties:
 *       name: kinesis-firehose-test-stream
 *       destination: opensearchserverless
 *       opensearchserverlessConfiguration:
 *         collectionEndpoint: ${testCollection.collectionEndpoint}
 *         roleArn: ${firehoseRole.arn}
 *         indexName: test
 *         s3Configuration:
 *           roleArn: ${firehoseRole.arn}
 *           bucketArn: ${bucket.arn}
 *           bufferingSize: 10
 *           bufferingInterval: 400
 *           compressionFormat: GZIP
 *         processingConfiguration:
 *           enabled: 'true'
 *           processors:
 *             - type: Lambda
 *               parameters:
 *                 - parameterName: LambdaArn
 *                   parameterValue: ${lambdaProcessor.arn}:$LATEST
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Splunk Destination
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testStream = new aws.kinesis.FirehoseDeliveryStream("test_stream", {
 *     name: "kinesis-firehose-test-stream",
 *     destination: "splunk",
 *     splunkConfiguration: {
 *         hecEndpoint: "https://http-inputs-mydomain.splunkcloud.com:443",
 *         hecToken: "51D4DA16-C61B-4F5F-8EC7-ED4301342A4A",
 *         hecAcknowledgmentTimeout: 600,
 *         hecEndpointType: "Event",
 *         s3BackupMode: "FailedEventsOnly",
 *         s3Configuration: {
 *             roleArn: firehose.arn,
 *             bucketArn: bucket.arn,
 *             bufferingSize: 10,
 *             bufferingInterval: 400,
 *             compressionFormat: "GZIP",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_stream = aws.kinesis.FirehoseDeliveryStream("test_stream",
 *     name="kinesis-firehose-test-stream",
 *     destination="splunk",
 *     splunk_configuration={
 *         "hec_endpoint": "https://http-inputs-mydomain.splunkcloud.com:443",
 *         "hec_token": "51D4DA16-C61B-4F5F-8EC7-ED4301342A4A",
 *         "hec_acknowledgment_timeout": 600,
 *         "hec_endpoint_type": "Event",
 *         "s3_backup_mode": "FailedEventsOnly",
 *         "s3_configuration": {
 *             "role_arn": firehose["arn"],
 *             "bucket_arn": bucket["arn"],
 *             "buffering_size": 10,
 *             "buffering_interval": 400,
 *             "compression_format": "GZIP",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testStream = new Aws.Kinesis.FirehoseDeliveryStream("test_stream", new()
 *     {
 *         Name = "kinesis-firehose-test-stream",
 *         Destination = "splunk",
 *         SplunkConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamSplunkConfigurationArgs
 *         {
 *             HecEndpoint = "https://http-inputs-mydomain.splunkcloud.com:443",
 *             HecToken = "51D4DA16-C61B-4F5F-8EC7-ED4301342A4A",
 *             HecAcknowledgmentTimeout = 600,
 *             HecEndpointType = "Event",
 *             S3BackupMode = "FailedEventsOnly",
 *             S3Configuration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamSplunkConfigurationS3ConfigurationArgs
 *             {
 *                 RoleArn = firehose.Arn,
 *                 BucketArn = bucket.Arn,
 *                 BufferingSize = 10,
 *                 BufferingInterval = 400,
 *                 CompressionFormat = "GZIP",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kinesis.NewFirehoseDeliveryStream(ctx, "test_stream", &kinesis.FirehoseDeliveryStreamArgs{
 * 			Name:        pulumi.String("kinesis-firehose-test-stream"),
 * 			Destination: pulumi.String("splunk"),
 * 			SplunkConfiguration: &kinesis.FirehoseDeliveryStreamSplunkConfigurationArgs{
 * 				HecEndpoint:              pulumi.String("https://http-inputs-mydomain.splunkcloud.com:443"),
 * 				HecToken:                 pulumi.String("51D4DA16-C61B-4F5F-8EC7-ED4301342A4A"),
 * 				HecAcknowledgmentTimeout: pulumi.Int(600),
 * 				HecEndpointType:          pulumi.String("Event"),
 * 				S3BackupMode:             pulumi.String("FailedEventsOnly"),
 * 				S3Configuration: &kinesis.FirehoseDeliveryStreamSplunkConfigurationS3ConfigurationArgs{
 * 					RoleArn:           pulumi.Any(firehose.Arn),
 * 					BucketArn:         pulumi.Any(bucket.Arn),
 * 					BufferingSize:     pulumi.Int(10),
 * 					BufferingInterval: pulumi.Int(400),
 * 					CompressionFormat: pulumi.String("GZIP"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationS3ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .name("kinesis-firehose-test-stream")
 *             .destination("splunk")
 *             .splunkConfiguration(FirehoseDeliveryStreamSplunkConfigurationArgs.builder()
 *                 .hecEndpoint("https://http-inputs-mydomain.splunkcloud.com:443")
 *                 .hecToken("51D4DA16-C61B-4F5F-8EC7-ED4301342A4A")
 *                 .hecAcknowledgmentTimeout(600)
 *                 .hecEndpointType("Event")
 *                 .s3BackupMode("FailedEventsOnly")
 *                 .s3Configuration(FirehoseDeliveryStreamSplunkConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(firehose.arn())
 *                     .bucketArn(bucket.arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testStream:
 *     type: aws:kinesis:FirehoseDeliveryStream
 *     name: test_stream
 *     properties:
 *       name: kinesis-firehose-test-stream
 *       destination: splunk
 *       splunkConfiguration:
 *         hecEndpoint: https://http-inputs-mydomain.splunkcloud.com:443
 *         hecToken: 51D4DA16-C61B-4F5F-8EC7-ED4301342A4A
 *         hecAcknowledgmentTimeout: 600
 *         hecEndpointType: Event
 *         s3BackupMode: FailedEventsOnly
 *         s3Configuration:
 *           roleArn: ${firehose.arn}
 *           bucketArn: ${bucket.arn}
 *           bufferingSize: 10
 *           bufferingInterval: 400
 *           compressionFormat: GZIP
 * ```
 * <!--End PulumiCodeChooser -->
 * ### HTTP Endpoint (e.g., New Relic) Destination
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testStream = new aws.kinesis.FirehoseDeliveryStream("test_stream", {
 *     name: "kinesis-firehose-test-stream",
 *     destination: "http_endpoint",
 *     httpEndpointConfiguration: {
 *         url: "https://aws-api.newrelic.com/firehose/v1",
 *         name: "New Relic",
 *         accessKey: "my-key",
 *         bufferingSize: 15,
 *         bufferingInterval: 600,
 *         roleArn: firehose.arn,
 *         s3BackupMode: "FailedDataOnly",
 *         s3Configuration: {
 *             roleArn: firehose.arn,
 *             bucketArn: bucket.arn,
 *             bufferingSize: 10,
 *             bufferingInterval: 400,
 *             compressionFormat: "GZIP",
 *         },
 *         requestConfiguration: {
 *             contentEncoding: "GZIP",
 *             commonAttributes: [
 *                 {
 *                     name: "testname",
 *                     value: "testvalue",
 *                 },
 *                 {
 *                     name: "testname2",
 *                     value: "testvalue2",
 *                 },
 *             ],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_stream = aws.kinesis.FirehoseDeliveryStream("test_stream",
 *     name="kinesis-firehose-test-stream",
 *     destination="http_endpoint",
 *     http_endpoint_configuration={
 *         "url": "https://aws-api.newrelic.com/firehose/v1",
 *         "name": "New Relic",
 *         "access_key": "my-key",
 *         "buffering_size": 15,
 *         "buffering_interval": 600,
 *         "role_arn": firehose["arn"],
 *         "s3_backup_mode": "FailedDataOnly",
 *         "s3_configuration": {
 *             "role_arn": firehose["arn"],
 *             "bucket_arn": bucket["arn"],
 *             "buffering_size": 10,
 *             "buffering_interval": 400,
 *             "compression_format": "GZIP",
 *         },
 *         "request_configuration": {
 *             "content_encoding": "GZIP",
 *             "common_attributes": [
 *                 {
 *                     "name": "testname",
 *                     "value": "testvalue",
 *                 },
 *                 {
 *                     "name": "testname2",
 *                     "value": "testvalue2",
 *                 },
 *             ],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testStream = new Aws.Kinesis.FirehoseDeliveryStream("test_stream", new()
 *     {
 *         Name = "kinesis-firehose-test-stream",
 *         Destination = "http_endpoint",
 *         HttpEndpointConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamHttpEndpointConfigurationArgs
 *         {
 *             Url = "https://aws-api.newrelic.com/firehose/v1",
 *             Name = "New Relic",
 *             AccessKey = "my-key",
 *             BufferingSize = 15,
 *             BufferingInterval = 600,
 *             RoleArn = firehose.Arn,
 *             S3BackupMode = "FailedDataOnly",
 *             S3Configuration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs
 *             {
 *                 RoleArn = firehose.Arn,
 *                 BucketArn = bucket.Arn,
 *                 BufferingSize = 10,
 *                 BufferingInterval = 400,
 *                 CompressionFormat = "GZIP",
 *             },
 *             RequestConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs
 *             {
 *                 ContentEncoding = "GZIP",
 *                 CommonAttributes = new[]
 *                 {
 *                     new Aws.Kinesis.Inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs
 *                     {
 *                         Name = "testname",
 *                         Value = "testvalue",
 *                     },
 *                     new Aws.Kinesis.Inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs
 *                     {
 *                         Name = "testname2",
 *                         Value = "testvalue2",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kinesis.NewFirehoseDeliveryStream(ctx, "test_stream", &kinesis.FirehoseDeliveryStreamArgs{
 * 			Name:        pulumi.String("kinesis-firehose-test-stream"),
 * 			Destination: pulumi.String("http_endpoint"),
 * 			HttpEndpointConfiguration: &kinesis.FirehoseDeliveryStreamHttpEndpointConfigurationArgs{
 * 				Url:               pulumi.String("https://aws-api.newrelic.com/firehose/v1"),
 * 				Name:              pulumi.String("New Relic"),
 * 				AccessKey:         pulumi.String("my-key"),
 * 				BufferingSize:     pulumi.Int(15),
 * 				BufferingInterval: pulumi.Int(600),
 * 				RoleArn:           pulumi.Any(firehose.Arn),
 * 				S3BackupMode:      pulumi.String("FailedDataOnly"),
 * 				S3Configuration: &kinesis.FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs{
 * 					RoleArn:           pulumi.Any(firehose.Arn),
 * 					BucketArn:         pulumi.Any(bucket.Arn),
 * 					BufferingSize:     pulumi.Int(10),
 * 					BufferingInterval: pulumi.Int(400),
 * 					CompressionFormat: pulumi.String("GZIP"),
 * 				},
 * 				RequestConfiguration: &kinesis.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs{
 * 					ContentEncoding: pulumi.String("GZIP"),
 * 					CommonAttributes: kinesis.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArray{
 * 						&kinesis.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs{
 * 							Name:  pulumi.String("testname"),
 * 							Value: pulumi.String("testvalue"),
 * 						},
 * 						&kinesis.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs{
 * 							Name:  pulumi.String("testname2"),
 * 							Value: pulumi.String("testvalue2"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .name("kinesis-firehose-test-stream")
 *             .destination("http_endpoint")
 *             .httpEndpointConfiguration(FirehoseDeliveryStreamHttpEndpointConfigurationArgs.builder()
 *                 .url("https://aws-api.newrelic.com/firehose/v1")
 *                 .name("New Relic")
 *                 .accessKey("my-key")
 *                 .bufferingSize(15)
 *                 .bufferingInterval(600)
 *                 .roleArn(firehose.arn())
 *                 .s3BackupMode("FailedDataOnly")
 *                 .s3Configuration(FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(firehose.arn())
 *                     .bucketArn(bucket.arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .requestConfiguration(FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs.builder()
 *                     .contentEncoding("GZIP")
 *                     .commonAttributes(
 *                         FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs.builder()
 *                             .name("testname")
 *                             .value("testvalue")
 *                             .build(),
 *                         FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs.builder()
 *                             .name("testname2")
 *                             .value("testvalue2")
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testStream:
 *     type: aws:kinesis:FirehoseDeliveryStream
 *     name: test_stream
 *     properties:
 *       name: kinesis-firehose-test-stream
 *       destination: http_endpoint
 *       httpEndpointConfiguration:
 *         url: https://aws-api.newrelic.com/firehose/v1
 *         name: New Relic
 *         accessKey: my-key
 *         bufferingSize: 15
 *         bufferingInterval: 600
 *         roleArn: ${firehose.arn}
 *         s3BackupMode: FailedDataOnly
 *         s3Configuration:
 *           roleArn: ${firehose.arn}
 *           bucketArn: ${bucket.arn}
 *           bufferingSize: 10
 *           bufferingInterval: 400
 *           compressionFormat: GZIP
 *         requestConfiguration:
 *           contentEncoding: GZIP
 *           commonAttributes:
 *             - name: testname
 *               value: testvalue
 *             - name: testname2
 *               value: testvalue2
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Snowflake Destination
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleSnowflakeDestination = new aws.kinesis.FirehoseDeliveryStream("example_snowflake_destination", {
 *     name: "example-snowflake-destination",
 *     destination: "snowflake",
 *     snowflakeConfiguration: {
 *         accountUrl: "https://example.snowflakecomputing.com",
 *         database: "example-db",
 *         privateKey: "...",
 *         roleArn: firehose.arn,
 *         schema: "example-schema",
 *         table: "example-table",
 *         user: "example-usr",
 *         s3Configuration: {
 *             roleArn: firehose.arn,
 *             bucketArn: bucket.arn,
 *             bufferingSize: 10,
 *             bufferingInterval: 400,
 *             compressionFormat: "GZIP",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_snowflake_destination = aws.kinesis.FirehoseDeliveryStream("example_snowflake_destination",
 *     name="example-snowflake-destination",
 *     destination="snowflake",
 *     snowflake_configuration={
 *         "account_url": "https://example.snowflakecomputing.com",
 *         "database": "example-db",
 *         "private_key": "...",
 *         "role_arn": firehose["arn"],
 *         "schema": "example-schema",
 *         "table": "example-table",
 *         "user": "example-usr",
 *         "s3_configuration": {
 *             "role_arn": firehose["arn"],
 *             "bucket_arn": bucket["arn"],
 *             "buffering_size": 10,
 *             "buffering_interval": 400,
 *             "compression_format": "GZIP",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleSnowflakeDestination = new Aws.Kinesis.FirehoseDeliveryStream("example_snowflake_destination", new()
 *     {
 *         Name = "example-snowflake-destination",
 *         Destination = "snowflake",
 *         SnowflakeConfiguration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamSnowflakeConfigurationArgs
 *         {
 *             AccountUrl = "https://example.snowflakecomputing.com",
 *             Database = "example-db",
 *             PrivateKey = "...",
 *             RoleArn = firehose.Arn,
 *             Schema = "example-schema",
 *             Table = "example-table",
 *             User = "example-usr",
 *             S3Configuration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamSnowflakeConfigurationS3ConfigurationArgs
 *             {
 *                 RoleArn = firehose.Arn,
 *                 BucketArn = bucket.Arn,
 *                 BufferingSize = 10,
 *                 BufferingInterval = 400,
 *                 CompressionFormat = "GZIP",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kinesis.NewFirehoseDeliveryStream(ctx, "example_snowflake_destination", &kinesis.FirehoseDeliveryStreamArgs{
 * 			Name:        pulumi.String("example-snowflake-destination"),
 * 			Destination: pulumi.String("snowflake"),
 * 			SnowflakeConfiguration: &kinesis.FirehoseDeliveryStreamSnowflakeConfigurationArgs{
 * 				AccountUrl: pulumi.String("https://example.snowflakecomputing.com"),
 * 				Database:   pulumi.String("example-db"),
 * 				PrivateKey: pulumi.String("..."),
 * 				RoleArn:    pulumi.Any(firehose.Arn),
 * 				Schema:     pulumi.String("example-schema"),
 * 				Table:      pulumi.String("example-table"),
 * 				User:       pulumi.String("example-usr"),
 * 				S3Configuration: &kinesis.FirehoseDeliveryStreamSnowflakeConfigurationS3ConfigurationArgs{
 * 					RoleArn:           pulumi.Any(firehose.Arn),
 * 					BucketArn:         pulumi.Any(bucket.Arn),
 * 					BufferingSize:     pulumi.Int(10),
 * 					BufferingInterval: pulumi.Int(400),
 * 					CompressionFormat: pulumi.String("GZIP"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationS3ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSnowflakeDestination = new FirehoseDeliveryStream("exampleSnowflakeDestination", FirehoseDeliveryStreamArgs.builder()
 *             .name("example-snowflake-destination")
 *             .destination("snowflake")
 *             .snowflakeConfiguration(FirehoseDeliveryStreamSnowflakeConfigurationArgs.builder()
 *                 .accountUrl("https://example.snowflakecomputing.com")
 *                 .database("example-db")
 *                 .privateKey("...")
 *                 .roleArn(firehose.arn())
 *                 .schema("example-schema")
 *                 .table("example-table")
 *                 .user("example-usr")
 *                 .s3Configuration(FirehoseDeliveryStreamSnowflakeConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(firehose.arn())
 *                     .bucketArn(bucket.arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleSnowflakeDestination:
 *     type: aws:kinesis:FirehoseDeliveryStream
 *     name: example_snowflake_destination
 *     properties:
 *       name: example-snowflake-destination
 *       destination: snowflake
 *       snowflakeConfiguration:
 *         accountUrl: https://example.snowflakecomputing.com
 *         database: example-db
 *         privateKey: '...'
 *         roleArn: ${firehose.arn}
 *         schema: example-schema
 *         table: example-table
 *         user: example-usr
 *         s3Configuration:
 *           roleArn: ${firehose.arn}
 *           bucketArn: ${bucket.arn}
 *           bufferingSize: 10
 *           bufferingInterval: 400
 *           compressionFormat: GZIP
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Kinesis Firehose Delivery streams using the stream ARN. For example:
 * ```sh
 * $ pulumi import aws:kinesis/firehoseDeliveryStream:FirehoseDeliveryStream foo arn:aws:firehose:us-east-1:XXX:deliverystream/example
 * ```
 * Note: Import does not work for stream destination `s3`. Consider using `extended_s3` since `s3` destination is deprecated.
 * @property arn The Amazon Resource Name (ARN) specifying the Stream
 * @property destination This is the destination to where the data is delivered. The only options are `s3` (Deprecated, use `extended_s3` instead), `extended_s3`, `redshift`, `elasticsearch`, `splunk`, `http_endpoint`, `opensearch`, `opensearchserverless` and `snowflake`.
 * @property destinationId
 * @property elasticsearchConfiguration Configuration options when `destination` is `elasticsearch`. See `elasticsearch_configuration` block below for details.
 * @property extendedS3Configuration Enhanced configuration options for the s3 destination. See `extended_s3_configuration` block below for details.
 * @property httpEndpointConfiguration Configuration options when `destination` is `http_endpoint`. Requires the user to also specify an `s3_configuration` block.  See `http_endpoint_configuration` block below for details.
 * @property kinesisSourceConfiguration The stream and role Amazon Resource Names (ARNs) for a Kinesis data stream used as the source for a delivery stream. See `kinesis_source_configuration` block below for details.
 * @property mskSourceConfiguration The configuration for the Amazon MSK cluster to be used as the source for a delivery stream. See `msk_source_configuration` block below for details.
 * @property name A name to identify the stream. This is unique to the AWS account and region the Stream is created in. When using for WAF logging, name must be prefixed with `aws-waf-logs-`. See [AWS Documentation](https://docs.aws.amazon.com/waf/latest/developerguide/waf-policies.html#waf-policies-logging-config) for more details.
 * @property opensearchConfiguration Configuration options when `destination` is `opensearch`. See `opensearch_configuration` block below for details.
 * @property opensearchserverlessConfiguration Configuration options when `destination` is `opensearchserverless`. See `opensearchserverless_configuration` block below for details.
 * @property redshiftConfiguration Configuration options when `destination` is `redshift`. Requires the user to also specify an `s3_configuration` block. See `redshift_configuration` block below for details.
 * @property serverSideEncryption Encrypt at rest options. See `server_side_encryption` block below for details.
 * **NOTE:** Server-side encryption should not be enabled when a kinesis stream is configured as the source of the firehose delivery stream.
 * @property snowflakeConfiguration Configuration options when `destination` is `snowflake`. See `snowflake_configuration` block below for details.
 * @property splunkConfiguration Configuration options when `destination` is `splunk`. See `splunk_configuration` block below for details.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property versionId
 * */*/*/*/*/*/*/*/*/*/*/*/
 */
public data class FirehoseDeliveryStreamArgs(
    public val arn: Output<String>? = null,
    public val destination: Output<String>? = null,
    public val destinationId: Output<String>? = null,
    public val elasticsearchConfiguration: Output<FirehoseDeliveryStreamElasticsearchConfigurationArgs>? = null,
    public val extendedS3Configuration: Output<FirehoseDeliveryStreamExtendedS3ConfigurationArgs>? =
        null,
    public val httpEndpointConfiguration: Output<FirehoseDeliveryStreamHttpEndpointConfigurationArgs>? =
        null,
    public val kinesisSourceConfiguration: Output<FirehoseDeliveryStreamKinesisSourceConfigurationArgs>? = null,
    public val mskSourceConfiguration: Output<FirehoseDeliveryStreamMskSourceConfigurationArgs>? =
        null,
    public val name: Output<String>? = null,
    public val opensearchConfiguration: Output<FirehoseDeliveryStreamOpensearchConfigurationArgs>? =
        null,
    public val opensearchserverlessConfiguration: Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs>? = null,
    public val redshiftConfiguration: Output<FirehoseDeliveryStreamRedshiftConfigurationArgs>? = null,
    public val serverSideEncryption: Output<FirehoseDeliveryStreamServerSideEncryptionArgs>? = null,
    public val snowflakeConfiguration: Output<FirehoseDeliveryStreamSnowflakeConfigurationArgs>? =
        null,
    public val splunkConfiguration: Output<FirehoseDeliveryStreamSplunkConfigurationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val versionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs =
        com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .destination(destination?.applyValue({ args0 -> args0 }))
            .destinationId(destinationId?.applyValue({ args0 -> args0 }))
            .elasticsearchConfiguration(
                elasticsearchConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .extendedS3Configuration(
                extendedS3Configuration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .httpEndpointConfiguration(
                httpEndpointConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kinesisSourceConfiguration(
                kinesisSourceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .mskSourceConfiguration(
                mskSourceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .opensearchConfiguration(
                opensearchConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .opensearchserverlessConfiguration(
                opensearchserverlessConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .redshiftConfiguration(
                redshiftConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .serverSideEncryption(
                serverSideEncryption?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .snowflakeConfiguration(
                snowflakeConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .splunkConfiguration(
                splunkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .versionId(versionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var destination: Output<String>? = null

    private var destinationId: Output<String>? = null

    private var elasticsearchConfiguration:
        Output<FirehoseDeliveryStreamElasticsearchConfigurationArgs>? = null

    private var extendedS3Configuration: Output<FirehoseDeliveryStreamExtendedS3ConfigurationArgs>? =
        null

    private var httpEndpointConfiguration:
        Output<FirehoseDeliveryStreamHttpEndpointConfigurationArgs>? = null

    private var kinesisSourceConfiguration:
        Output<FirehoseDeliveryStreamKinesisSourceConfigurationArgs>? = null

    private var mskSourceConfiguration: Output<FirehoseDeliveryStreamMskSourceConfigurationArgs>? =
        null

    private var name: Output<String>? = null

    private var opensearchConfiguration: Output<FirehoseDeliveryStreamOpensearchConfigurationArgs>? =
        null

    private var opensearchserverlessConfiguration:
        Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs>? = null

    private var redshiftConfiguration: Output<FirehoseDeliveryStreamRedshiftConfigurationArgs>? = null

    private var serverSideEncryption: Output<FirehoseDeliveryStreamServerSideEncryptionArgs>? = null

    private var snowflakeConfiguration: Output<FirehoseDeliveryStreamSnowflakeConfigurationArgs>? =
        null

    private var splunkConfiguration: Output<FirehoseDeliveryStreamSplunkConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var versionId: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) specifying the Stream
     */
    @JvmName("qaahgvvtaywdjalo")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value This is the destination to where the data is delivered. The only options are `s3` (Deprecated, use `extended_s3` instead), `extended_s3`, `redshift`, `elasticsearch`, `splunk`, `http_endpoint`, `opensearch`, `opensearchserverless` and `snowflake`.
     */
    @JvmName("jrxqydmyvknbnlsh")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value
     */
    @JvmName("nyfmowfwfmnylvlj")
    public suspend fun destinationId(`value`: Output<String>) {
        this.destinationId = value
    }

    /**
     * @param value Configuration options when `destination` is `elasticsearch`. See `elasticsearch_configuration` block below for details.
     */
    @JvmName("cfgnjhetnqdmgpia")
    public suspend fun elasticsearchConfiguration(`value`: Output<FirehoseDeliveryStreamElasticsearchConfigurationArgs>) {
        this.elasticsearchConfiguration = value
    }

    /**
     * @param value Enhanced configuration options for the s3 destination. See `extended_s3_configuration` block below for details.
     */
    @JvmName("qwpxnylaskcctfec")
    public suspend fun extendedS3Configuration(`value`: Output<FirehoseDeliveryStreamExtendedS3ConfigurationArgs>) {
        this.extendedS3Configuration = value
    }

    /**
     * @param value Configuration options when `destination` is `http_endpoint`. Requires the user to also specify an `s3_configuration` block.  See `http_endpoint_configuration` block below for details.
     */
    @JvmName("ogkttowgsprolkpk")
    public suspend fun httpEndpointConfiguration(`value`: Output<FirehoseDeliveryStreamHttpEndpointConfigurationArgs>) {
        this.httpEndpointConfiguration = value
    }

    /**
     * @param value The stream and role Amazon Resource Names (ARNs) for a Kinesis data stream used as the source for a delivery stream. See `kinesis_source_configuration` block below for details.
     */
    @JvmName("wscivjflerksjuop")
    public suspend fun kinesisSourceConfiguration(`value`: Output<FirehoseDeliveryStreamKinesisSourceConfigurationArgs>) {
        this.kinesisSourceConfiguration = value
    }

    /**
     * @param value The configuration for the Amazon MSK cluster to be used as the source for a delivery stream. See `msk_source_configuration` block below for details.
     */
    @JvmName("neiphvnhauquolhd")
    public suspend fun mskSourceConfiguration(`value`: Output<FirehoseDeliveryStreamMskSourceConfigurationArgs>) {
        this.mskSourceConfiguration = value
    }

    /**
     * @param value A name to identify the stream. This is unique to the AWS account and region the Stream is created in. When using for WAF logging, name must be prefixed with `aws-waf-logs-`. See [AWS Documentation](https://docs.aws.amazon.com/waf/latest/developerguide/waf-policies.html#waf-policies-logging-config) for more details.
     */
    @JvmName("tbxujtrgftleqsbh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration options when `destination` is `opensearch`. See `opensearch_configuration` block below for details.
     */
    @JvmName("uwgembxcxdmeyklx")
    public suspend fun opensearchConfiguration(`value`: Output<FirehoseDeliveryStreamOpensearchConfigurationArgs>) {
        this.opensearchConfiguration = value
    }

    /**
     * @param value Configuration options when `destination` is `opensearchserverless`. See `opensearchserverless_configuration` block below for details.
     */
    @JvmName("vgkvgrjcjqcagnru")
    public suspend fun opensearchserverlessConfiguration(`value`: Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs>) {
        this.opensearchserverlessConfiguration = value
    }

    /**
     * @param value Configuration options when `destination` is `redshift`. Requires the user to also specify an `s3_configuration` block. See `redshift_configuration` block below for details.
     */
    @JvmName("savmvtspaxeytmew")
    public suspend fun redshiftConfiguration(`value`: Output<FirehoseDeliveryStreamRedshiftConfigurationArgs>) {
        this.redshiftConfiguration = value
    }

    /**
     * @param value Encrypt at rest options. See `server_side_encryption` block below for details.
     * **NOTE:** Server-side encryption should not be enabled when a kinesis stream is configured as the source of the firehose delivery stream.
     */
    @JvmName("oytqngubqxtntspx")
    public suspend fun serverSideEncryption(`value`: Output<FirehoseDeliveryStreamServerSideEncryptionArgs>) {
        this.serverSideEncryption = value
    }

    /**
     * @param value Configuration options when `destination` is `snowflake`. See `snowflake_configuration` block below for details.
     */
    @JvmName("lhyujxeyoqnhkpdm")
    public suspend fun snowflakeConfiguration(`value`: Output<FirehoseDeliveryStreamSnowflakeConfigurationArgs>) {
        this.snowflakeConfiguration = value
    }

    /**
     * @param value Configuration options when `destination` is `splunk`. See `splunk_configuration` block below for details.
     */
    @JvmName("aywmutuwbjjtmcnl")
    public suspend fun splunkConfiguration(`value`: Output<FirehoseDeliveryStreamSplunkConfigurationArgs>) {
        this.splunkConfiguration = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cwxgwlawdedogdaw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("cdobkeujbryeindl")
    public suspend fun versionId(`value`: Output<String>) {
        this.versionId = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) specifying the Stream
     */
    @JvmName("maxlpfpoyakicpag")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value This is the destination to where the data is delivered. The only options are `s3` (Deprecated, use `extended_s3` instead), `extended_s3`, `redshift`, `elasticsearch`, `splunk`, `http_endpoint`, `opensearch`, `opensearchserverless` and `snowflake`.
     */
    @JvmName("uiwvakadgrglhwet")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value
     */
    @JvmName("rmoeawjmfpfsmrkt")
    public suspend fun destinationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationId = mapped
    }

    /**
     * @param value Configuration options when `destination` is `elasticsearch`. See `elasticsearch_configuration` block below for details.
     */
    @JvmName("njvggunivxyundit")
    public suspend fun elasticsearchConfiguration(`value`: FirehoseDeliveryStreamElasticsearchConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchConfiguration = mapped
    }

    /**
     * @param argument Configuration options when `destination` is `elasticsearch`. See `elasticsearch_configuration` block below for details.
     */
    @JvmName("iphmkwdmdabggghk")
    public suspend fun elasticsearchConfiguration(argument: suspend FirehoseDeliveryStreamElasticsearchConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamElasticsearchConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.elasticsearchConfiguration = mapped
    }

    /**
     * @param value Enhanced configuration options for the s3 destination. See `extended_s3_configuration` block below for details.
     */
    @JvmName("xnyogyxnffaclleh")
    public suspend fun extendedS3Configuration(`value`: FirehoseDeliveryStreamExtendedS3ConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedS3Configuration = mapped
    }

    /**
     * @param argument Enhanced configuration options for the s3 destination. See `extended_s3_configuration` block below for details.
     */
    @JvmName("xypflwxvejrbpjns")
    public suspend fun extendedS3Configuration(argument: suspend FirehoseDeliveryStreamExtendedS3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamExtendedS3ConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.extendedS3Configuration = mapped
    }

    /**
     * @param value Configuration options when `destination` is `http_endpoint`. Requires the user to also specify an `s3_configuration` block.  See `http_endpoint_configuration` block below for details.
     */
    @JvmName("ksvvbryayctunbsy")
    public suspend fun httpEndpointConfiguration(`value`: FirehoseDeliveryStreamHttpEndpointConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpEndpointConfiguration = mapped
    }

    /**
     * @param argument Configuration options when `destination` is `http_endpoint`. Requires the user to also specify an `s3_configuration` block.  See `http_endpoint_configuration` block below for details.
     */
    @JvmName("dochihdhhjfetuiy")
    public suspend fun httpEndpointConfiguration(argument: suspend FirehoseDeliveryStreamHttpEndpointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamHttpEndpointConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.httpEndpointConfiguration = mapped
    }

    /**
     * @param value The stream and role Amazon Resource Names (ARNs) for a Kinesis data stream used as the source for a delivery stream. See `kinesis_source_configuration` block below for details.
     */
    @JvmName("bqlqtymmxnljgtjf")
    public suspend fun kinesisSourceConfiguration(`value`: FirehoseDeliveryStreamKinesisSourceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisSourceConfiguration = mapped
    }

    /**
     * @param argument The stream and role Amazon Resource Names (ARNs) for a Kinesis data stream used as the source for a delivery stream. See `kinesis_source_configuration` block below for details.
     */
    @JvmName("ydsfniqloxbicqnj")
    public suspend fun kinesisSourceConfiguration(argument: suspend FirehoseDeliveryStreamKinesisSourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamKinesisSourceConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kinesisSourceConfiguration = mapped
    }

    /**
     * @param value The configuration for the Amazon MSK cluster to be used as the source for a delivery stream. See `msk_source_configuration` block below for details.
     */
    @JvmName("mtkciyqgkpkjsfmf")
    public suspend fun mskSourceConfiguration(`value`: FirehoseDeliveryStreamMskSourceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mskSourceConfiguration = mapped
    }

    /**
     * @param argument The configuration for the Amazon MSK cluster to be used as the source for a delivery stream. See `msk_source_configuration` block below for details.
     */
    @JvmName("qusawovpwmlihokq")
    public suspend fun mskSourceConfiguration(argument: suspend FirehoseDeliveryStreamMskSourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamMskSourceConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mskSourceConfiguration = mapped
    }

    /**
     * @param value A name to identify the stream. This is unique to the AWS account and region the Stream is created in. When using for WAF logging, name must be prefixed with `aws-waf-logs-`. See [AWS Documentation](https://docs.aws.amazon.com/waf/latest/developerguide/waf-policies.html#waf-policies-logging-config) for more details.
     */
    @JvmName("vgsemigxypiijrav")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration options when `destination` is `opensearch`. See `opensearch_configuration` block below for details.
     */
    @JvmName("debgnqqdjijehgxb")
    public suspend fun opensearchConfiguration(`value`: FirehoseDeliveryStreamOpensearchConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opensearchConfiguration = mapped
    }

    /**
     * @param argument Configuration options when `destination` is `opensearch`. See `opensearch_configuration` block below for details.
     */
    @JvmName("nqclncrvliuixpiv")
    public suspend fun opensearchConfiguration(argument: suspend FirehoseDeliveryStreamOpensearchConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamOpensearchConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.opensearchConfiguration = mapped
    }

    /**
     * @param value Configuration options when `destination` is `opensearchserverless`. See `opensearchserverless_configuration` block below for details.
     */
    @JvmName("iepqirqhmcctthst")
    public suspend fun opensearchserverlessConfiguration(`value`: FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opensearchserverlessConfiguration = mapped
    }

    /**
     * @param argument Configuration options when `destination` is `opensearchserverless`. See `opensearchserverless_configuration` block below for details.
     */
    @JvmName("atjsqbvumbmylukg")
    public suspend fun opensearchserverlessConfiguration(argument: suspend FirehoseDeliveryStreamOpensearchserverlessConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchserverlessConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.opensearchserverlessConfiguration = mapped
    }

    /**
     * @param value Configuration options when `destination` is `redshift`. Requires the user to also specify an `s3_configuration` block. See `redshift_configuration` block below for details.
     */
    @JvmName("lpenkcfrjuxpwdgs")
    public suspend fun redshiftConfiguration(`value`: FirehoseDeliveryStreamRedshiftConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redshiftConfiguration = mapped
    }

    /**
     * @param argument Configuration options when `destination` is `redshift`. Requires the user to also specify an `s3_configuration` block. See `redshift_configuration` block below for details.
     */
    @JvmName("jmiebfjfysohgmjo")
    public suspend fun redshiftConfiguration(argument: suspend FirehoseDeliveryStreamRedshiftConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamRedshiftConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.redshiftConfiguration = mapped
    }

    /**
     * @param value Encrypt at rest options. See `server_side_encryption` block below for details.
     * **NOTE:** Server-side encryption should not be enabled when a kinesis stream is configured as the source of the firehose delivery stream.
     */
    @JvmName("frdidvhgoupbhwtr")
    public suspend fun serverSideEncryption(`value`: FirehoseDeliveryStreamServerSideEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryption = mapped
    }

    /**
     * @param argument Encrypt at rest options. See `server_side_encryption` block below for details.
     * **NOTE:** Server-side encryption should not be enabled when a kinesis stream is configured as the source of the firehose delivery stream.
     */
    @JvmName("vfwapkqtwngdpina")
    public suspend fun serverSideEncryption(argument: suspend FirehoseDeliveryStreamServerSideEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamServerSideEncryptionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serverSideEncryption = mapped
    }

    /**
     * @param value Configuration options when `destination` is `snowflake`. See `snowflake_configuration` block below for details.
     */
    @JvmName("cwxbvihcftrtrork")
    public suspend fun snowflakeConfiguration(`value`: FirehoseDeliveryStreamSnowflakeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snowflakeConfiguration = mapped
    }

    /**
     * @param argument Configuration options when `destination` is `snowflake`. See `snowflake_configuration` block below for details.
     */
    @JvmName("fdehsgkmobfstsig")
    public suspend fun snowflakeConfiguration(argument: suspend FirehoseDeliveryStreamSnowflakeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamSnowflakeConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.snowflakeConfiguration = mapped
    }

    /**
     * @param value Configuration options when `destination` is `splunk`. See `splunk_configuration` block below for details.
     */
    @JvmName("pamgbbilekvhklel")
    public suspend fun splunkConfiguration(`value`: FirehoseDeliveryStreamSplunkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.splunkConfiguration = mapped
    }

    /**
     * @param argument Configuration options when `destination` is `splunk`. See `splunk_configuration` block below for details.
     */
    @JvmName("orvyatojbgfxsgck")
    public suspend fun splunkConfiguration(argument: suspend FirehoseDeliveryStreamSplunkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamSplunkConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.splunkConfiguration = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wkcjkxrnpmamskex")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rxdubmgdeqbyttvi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("weabwctanesiejnx")
    public suspend fun versionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionId = mapped
    }

    internal fun build(): FirehoseDeliveryStreamArgs = FirehoseDeliveryStreamArgs(
        arn = arn,
        destination = destination,
        destinationId = destinationId,
        elasticsearchConfiguration = elasticsearchConfiguration,
        extendedS3Configuration = extendedS3Configuration,
        httpEndpointConfiguration = httpEndpointConfiguration,
        kinesisSourceConfiguration = kinesisSourceConfiguration,
        mskSourceConfiguration = mskSourceConfiguration,
        name = name,
        opensearchConfiguration = opensearchConfiguration,
        opensearchserverlessConfiguration = opensearchserverlessConfiguration,
        redshiftConfiguration = redshiftConfiguration,
        serverSideEncryption = serverSideEncryption,
        snowflakeConfiguration = snowflakeConfiguration,
        splunkConfiguration = splunkConfiguration,
        tags = tags,
        versionId = versionId,
    )
}
