@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ResourcePolicy].
 */
@PulumiTagMarker
public class ResourcePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourcePolicyArgs = ResourcePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourcePolicyArgsBuilder.() -> Unit) {
        val builder = ResourcePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourcePolicy {
        val builtJavaResource = com.pulumi.aws.kinesis.ResourcePolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResourcePolicy(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an Amazon Kinesis Streams resource policy.
 * Use a resource policy to manage cross-account access to your data streams or consumers.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kinesis.ResourcePolicy("example", {
 *     resourceArn: exampleAwsKinesisStream.arn,
 *     policy: `{
 *   "Version": "2012-10-17",
 *   "Id": "writePolicy",
 *   "Statement": [{
 *     "Sid": "writestatement",
 *     "Effect": "Allow",
 *     "Principal": {
 *       "AWS": "123456789456"
 *     },
 *     "Action": [
 *       "kinesis:DescribeStreamSummary",
 *       "kinesis:ListShards",
 *       "kinesis:PutRecord",
 *       "kinesis:PutRecords"
 *     ],
 *     "Resource": "${exampleAwsKinesisStream.arn}"
 *   }]
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kinesis.ResourcePolicy("example",
 *     resource_arn=example_aws_kinesis_stream["arn"],
 *     policy=f"""{{
 *   "Version": "2012-10-17",
 *   "Id": "writePolicy",
 *   "Statement": [{{
 *     "Sid": "writestatement",
 *     "Effect": "Allow",
 *     "Principal": {{
 *       "AWS": "123456789456"
 *     }},
 *     "Action": [
 *       "kinesis:DescribeStreamSummary",
 *       "kinesis:ListShards",
 *       "kinesis:PutRecord",
 *       "kinesis:PutRecords"
 *     ],
 *     "Resource": "{example_aws_kinesis_stream["arn"]}"
 *   }}]
 * }}
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kinesis.ResourcePolicy("example", new()
 *     {
 *         ResourceArn = exampleAwsKinesisStream.Arn,
 *         Policy = @$"{{
 *   ""Version"": ""2012-10-17"",
 *   ""Id"": ""writePolicy"",
 *   ""Statement"": [{{
 *     ""Sid"": ""writestatement"",
 *     ""Effect"": ""Allow"",
 *     ""Principal"": {{
 *       ""AWS"": ""123456789456""
 *     }},
 *     ""Action"": [
 *       ""kinesis:DescribeStreamSummary"",
 *       ""kinesis:ListShards"",
 *       ""kinesis:PutRecord"",
 *       ""kinesis:PutRecords""
 *     ],
 *     ""Resource"": ""{exampleAwsKinesisStream.Arn}""
 *   }}]
 * }}
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kinesis.NewResourcePolicy(ctx, "example", &kinesis.ResourcePolicyArgs{
 * 			ResourceArn: pulumi.Any(exampleAwsKinesisStream.Arn),
 * 			Policy: pulumi.Sprintf(`{
 *   "Version": "2012-10-17",
 *   "Id": "writePolicy",
 *   "Statement": [{
 *     "Sid": "writestatement",
 *     "Effect": "Allow",
 *     "Principal": {
 *       "AWS": "123456789456"
 *     },
 *     "Action": [
 *       "kinesis:DescribeStreamSummary",
 *       "kinesis:ListShards",
 *       "kinesis:PutRecord",
 *       "kinesis:PutRecords"
 *     ],
 *     "Resource": "%v"
 *   }]
 * }
 * `, exampleAwsKinesisStream.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.ResourcePolicy;
 * import com.pulumi.aws.kinesis.ResourcePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourcePolicy("example", ResourcePolicyArgs.builder()
 *             .resourceArn(exampleAwsKinesisStream.arn())
 *             .policy("""
 * {
 *   "Version": "2012-10-17",
 *   "Id": "writePolicy",
 *   "Statement": [{
 *     "Sid": "writestatement",
 *     "Effect": "Allow",
 *     "Principal": {
 *       "AWS": "123456789456"
 *     },
 *     "Action": [
 *       "kinesis:DescribeStreamSummary",
 *       "kinesis:ListShards",
 *       "kinesis:PutRecord",
 *       "kinesis:PutRecords"
 *     ],
 *     "Resource": "%s"
 *   }]
 * }
 * ", exampleAwsKinesisStream.arn()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kinesis:ResourcePolicy
 *     properties:
 *       resourceArn: ${exampleAwsKinesisStream.arn}
 *       policy: |
 *         {
 *           "Version": "2012-10-17",
 *           "Id": "writePolicy",
 *           "Statement": [{
 *             "Sid": "writestatement",
 *             "Effect": "Allow",
 *             "Principal": {
 *               "AWS": "123456789456"
 *             },
 *             "Action": [
 *               "kinesis:DescribeStreamSummary",
 *               "kinesis:ListShards",
 *               "kinesis:PutRecord",
 *               "kinesis:PutRecords"
 *             ],
 *             "Resource": "${exampleAwsKinesisStream.arn}"
 *           }]
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Kinesis resource policies using the `resource_arn`. For example:
 * ```sh
 * $ pulumi import aws:kinesis/resourcePolicy:ResourcePolicy example arn:aws:kinesis:us-west-2:123456789012:stream/example
 * ```
 */
public class ResourcePolicy internal constructor(
    override val javaResource: com.pulumi.aws.kinesis.ResourcePolicy,
) : KotlinCustomResource(javaResource, ResourcePolicyMapper) {
    /**
     * The policy document.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the data stream or consumer.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })
}

public object ResourcePolicyMapper : ResourceMapper<ResourcePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kinesis.ResourcePolicy::class == javaResource::class

    override fun map(javaResource: Resource): ResourcePolicy = ResourcePolicy(
        javaResource as
            com.pulumi.aws.kinesis.ResourcePolicy,
    )
}

/**
 * @see [ResourcePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourcePolicy].
 */
public suspend fun resourcePolicy(
    name: String,
    block: suspend ResourcePolicyResourceBuilder.() -> Unit,
): ResourcePolicy {
    val builder = ResourcePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourcePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourcePolicy(name: String): ResourcePolicy {
    val builder = ResourcePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
