@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin

import com.pulumi.aws.kinesis.ResourcePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an Amazon Kinesis Streams resource policy.
 * Use a resource policy to manage cross-account access to your data streams or consumers.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kinesis.ResourcePolicy("example", {
 *     resourceArn: exampleAwsKinesisStream.arn,
 *     policy: `{
 *   "Version": "2012-10-17",
 *   "Id": "writePolicy",
 *   "Statement": [{
 *     "Sid": "writestatement",
 *     "Effect": "Allow",
 *     "Principal": {
 *       "AWS": "123456789456"
 *     },
 *     "Action": [
 *       "kinesis:DescribeStreamSummary",
 *       "kinesis:ListShards",
 *       "kinesis:PutRecord",
 *       "kinesis:PutRecords"
 *     ],
 *     "Resource": "${exampleAwsKinesisStream.arn}"
 *   }]
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kinesis.ResourcePolicy("example",
 *     resource_arn=example_aws_kinesis_stream["arn"],
 *     policy=f"""{{
 *   "Version": "2012-10-17",
 *   "Id": "writePolicy",
 *   "Statement": [{{
 *     "Sid": "writestatement",
 *     "Effect": "Allow",
 *     "Principal": {{
 *       "AWS": "123456789456"
 *     }},
 *     "Action": [
 *       "kinesis:DescribeStreamSummary",
 *       "kinesis:ListShards",
 *       "kinesis:PutRecord",
 *       "kinesis:PutRecords"
 *     ],
 *     "Resource": "{example_aws_kinesis_stream["arn"]}"
 *   }}]
 * }}
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kinesis.ResourcePolicy("example", new()
 *     {
 *         ResourceArn = exampleAwsKinesisStream.Arn,
 *         Policy = @$"{{
 *   ""Version"": ""2012-10-17"",
 *   ""Id"": ""writePolicy"",
 *   ""Statement"": [{{
 *     ""Sid"": ""writestatement"",
 *     ""Effect"": ""Allow"",
 *     ""Principal"": {{
 *       ""AWS"": ""123456789456""
 *     }},
 *     ""Action"": [
 *       ""kinesis:DescribeStreamSummary"",
 *       ""kinesis:ListShards"",
 *       ""kinesis:PutRecord"",
 *       ""kinesis:PutRecords""
 *     ],
 *     ""Resource"": ""{exampleAwsKinesisStream.Arn}""
 *   }}]
 * }}
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kinesis.NewResourcePolicy(ctx, "example", &kinesis.ResourcePolicyArgs{
 * 			ResourceArn: pulumi.Any(exampleAwsKinesisStream.Arn),
 * 			Policy: pulumi.Sprintf(`{
 *   "Version": "2012-10-17",
 *   "Id": "writePolicy",
 *   "Statement": [{
 *     "Sid": "writestatement",
 *     "Effect": "Allow",
 *     "Principal": {
 *       "AWS": "123456789456"
 *     },
 *     "Action": [
 *       "kinesis:DescribeStreamSummary",
 *       "kinesis:ListShards",
 *       "kinesis:PutRecord",
 *       "kinesis:PutRecords"
 *     ],
 *     "Resource": "%v"
 *   }]
 * }
 * `, exampleAwsKinesisStream.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.ResourcePolicy;
 * import com.pulumi.aws.kinesis.ResourcePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourcePolicy("example", ResourcePolicyArgs.builder()
 *             .resourceArn(exampleAwsKinesisStream.arn())
 *             .policy("""
 * {
 *   "Version": "2012-10-17",
 *   "Id": "writePolicy",
 *   "Statement": [{
 *     "Sid": "writestatement",
 *     "Effect": "Allow",
 *     "Principal": {
 *       "AWS": "123456789456"
 *     },
 *     "Action": [
 *       "kinesis:DescribeStreamSummary",
 *       "kinesis:ListShards",
 *       "kinesis:PutRecord",
 *       "kinesis:PutRecords"
 *     ],
 *     "Resource": "%s"
 *   }]
 * }
 * ", exampleAwsKinesisStream.arn()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kinesis:ResourcePolicy
 *     properties:
 *       resourceArn: ${exampleAwsKinesisStream.arn}
 *       policy: |
 *         {
 *           "Version": "2012-10-17",
 *           "Id": "writePolicy",
 *           "Statement": [{
 *             "Sid": "writestatement",
 *             "Effect": "Allow",
 *             "Principal": {
 *               "AWS": "123456789456"
 *             },
 *             "Action": [
 *               "kinesis:DescribeStreamSummary",
 *               "kinesis:ListShards",
 *               "kinesis:PutRecord",
 *               "kinesis:PutRecords"
 *             ],
 *             "Resource": "${exampleAwsKinesisStream.arn}"
 *           }]
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Kinesis resource policies using the `resource_arn`. For example:
 * ```sh
 * $ pulumi import aws:kinesis/resourcePolicy:ResourcePolicy example arn:aws:kinesis:us-west-2:123456789012:stream/example
 * ```
 * @property policy The policy document.
 * @property resourceArn The Amazon Resource Name (ARN) of the data stream or consumer.
 */
public data class ResourcePolicyArgs(
    public val policy: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kinesis.ResourcePolicyArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.ResourcePolicyArgs =
        com.pulumi.aws.kinesis.ResourcePolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourcePolicyArgs].
 */
@PulumiTagMarker
public class ResourcePolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value The policy document.
     */
    @JvmName("gtdpcfptrjgvruoc")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the data stream or consumer.
     */
    @JvmName("okohvtshlaoqhafo")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The policy document.
     */
    @JvmName("qxitpvxfugnmjrmg")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the data stream or consumer.
     */
    @JvmName("eusgcjrgoonkrghb")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): ResourcePolicyArgs = ResourcePolicyArgs(
        policy = policy,
        resourceArn = resourceArn,
    )
}
