@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin

import com.pulumi.aws.kinesis.kotlin.outputs.StreamStreamModeDetails
import com.pulumi.aws.kinesis.kotlin.outputs.StreamStreamModeDetails.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Stream].
 */
@PulumiTagMarker
public class StreamResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StreamArgs = StreamArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StreamArgsBuilder.() -> Unit) {
        val builder = StreamArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Stream {
        val builtJavaResource = com.pulumi.aws.kinesis.Stream(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Stream(builtJavaResource)
    }
}

/**
 * Provides a Kinesis Stream resource. Amazon Kinesis is a managed service that
 * scales elastically for real-time processing of streaming big data.
 * For more details, see the [Amazon Kinesis Documentation](https://aws.amazon.com/documentation/kinesis/).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testStream = new aws.kinesis.Stream("test_stream", {
 *     name: "kinesis-test",
 *     shardCount: 1,
 *     retentionPeriod: 48,
 *     shardLevelMetrics: [
 *         "IncomingBytes",
 *         "OutgoingBytes",
 *     ],
 *     streamModeDetails: {
 *         streamMode: "PROVISIONED",
 *     },
 *     tags: {
 *         Environment: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_stream = aws.kinesis.Stream("test_stream",
 *     name="kinesis-test",
 *     shard_count=1,
 *     retention_period=48,
 *     shard_level_metrics=[
 *         "IncomingBytes",
 *         "OutgoingBytes",
 *     ],
 *     stream_mode_details={
 *         "stream_mode": "PROVISIONED",
 *     },
 *     tags={
 *         "Environment": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testStream = new Aws.Kinesis.Stream("test_stream", new()
 *     {
 *         Name = "kinesis-test",
 *         ShardCount = 1,
 *         RetentionPeriod = 48,
 *         ShardLevelMetrics = new[]
 *         {
 *             "IncomingBytes",
 *             "OutgoingBytes",
 *         },
 *         StreamModeDetails = new Aws.Kinesis.Inputs.StreamStreamModeDetailsArgs
 *         {
 *             StreamMode = "PROVISIONED",
 *         },
 *         Tags =
 *         {
 *             { "Environment", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kinesis.NewStream(ctx, "test_stream", &kinesis.StreamArgs{
 * 			Name:            pulumi.String("kinesis-test"),
 * 			ShardCount:      pulumi.Int(1),
 * 			RetentionPeriod: pulumi.Int(48),
 * 			ShardLevelMetrics: pulumi.StringArray{
 * 				pulumi.String("IncomingBytes"),
 * 				pulumi.String("OutgoingBytes"),
 * 			},
 * 			StreamModeDetails: &kinesis.StreamStreamModeDetailsArgs{
 * 				StreamMode: pulumi.String("PROVISIONED"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.kinesis.inputs.StreamStreamModeDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStream = new Stream("testStream", StreamArgs.builder()
 *             .name("kinesis-test")
 *             .shardCount(1)
 *             .retentionPeriod(48)
 *             .shardLevelMetrics(
 *                 "IncomingBytes",
 *                 "OutgoingBytes")
 *             .streamModeDetails(StreamStreamModeDetailsArgs.builder()
 *                 .streamMode("PROVISIONED")
 *                 .build())
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testStream:
 *     type: aws:kinesis:Stream
 *     name: test_stream
 *     properties:
 *       name: kinesis-test
 *       shardCount: 1
 *       retentionPeriod: 48
 *       shardLevelMetrics:
 *         - IncomingBytes
 *         - OutgoingBytes
 *       streamModeDetails:
 *         streamMode: PROVISIONED
 *       tags:
 *         Environment: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Kinesis Streams using the `name`. For example:
 * ```sh
 * $ pulumi import aws:kinesis/stream:Stream test_stream pulumi-kinesis-test
 * ```
 */
public class Stream internal constructor(
    override val javaResource: com.pulumi.aws.kinesis.Stream,
) : KotlinCustomResource(javaResource, StreamMapper) {
    /**
     * The Amazon Resource Name (ARN) specifying the Stream (same as `id`)
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The encryption type to use. The only acceptable values are `NONE` or `KMS`. The default value is `NONE`.
     */
    public val encryptionType: Output<String>?
        get() = javaResource.encryptionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A boolean that indicates all registered consumers should be deregistered from the stream so that the stream can be destroyed without error. The default value is `false`.
     */
    public val enforceConsumerDeletion: Output<Boolean>?
        get() = javaResource.enforceConsumerDeletion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The GUID for the customer-managed KMS key to use for encryption. You can also use a Kinesis-owned master key by specifying the alias `alias/aws/kinesis`.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A name to identify the stream. This is unique to the AWS account and region the Stream is created in.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Length of time data records are accessible after they are added to the stream. The maximum value of a stream's retention period is 8760 hours. Minimum value is 24. Default is 24.
     */
    public val retentionPeriod: Output<Int>?
        get() = javaResource.retentionPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of shards that the stream will use. If the `stream_mode` is `PROVISIONED`, this field is required.
     * Amazon has guidelines for specifying the Stream size that should be referenced when creating a Kinesis stream. See [Amazon Kinesis Streams](https://docs.aws.amazon.com/kinesis/latest/dev/amazon-kinesis-streams.html) for more.
     */
    public val shardCount: Output<Int>?
        get() = javaResource.shardCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of shard-level CloudWatch metrics which can be enabled for the stream. See [Monitoring with CloudWatch](https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html) for more. Note that the value ALL should not be used; instead you should provide an explicit list of metrics you wish to enable.
     */
    public val shardLevelMetrics: Output<List<String>>?
        get() = javaResource.shardLevelMetrics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Indicates the [capacity mode](https://docs.aws.amazon.com/streams/latest/dev/how-do-i-size-a-stream.html) of the data stream. Detailed below.
     */
    public val streamModeDetails: Output<StreamStreamModeDetails>
        get() = javaResource.streamModeDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object StreamMapper : ResourceMapper<Stream> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kinesis.Stream::class == javaResource::class

    override fun map(javaResource: Resource): Stream = Stream(
        javaResource as
            com.pulumi.aws.kinesis.Stream,
    )
}

/**
 * @see [Stream].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Stream].
 */
public suspend fun stream(name: String, block: suspend StreamResourceBuilder.() -> Unit): Stream {
    val builder = StreamResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Stream].
 * @param name The _unique_ name of the resulting resource.
 */
public fun stream(name: String): Stream {
    val builder = StreamResourceBuilder()
    builder.name(name)
    return builder.build()
}
