@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StreamConsumer].
 */
@PulumiTagMarker
public class StreamConsumerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StreamConsumerArgs = StreamConsumerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StreamConsumerArgsBuilder.() -> Unit) {
        val builder = StreamConsumerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StreamConsumer {
        val builtJavaResource = com.pulumi.aws.kinesis.StreamConsumer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StreamConsumer(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a Kinesis Stream Consumer.
 * > **Note:** You can register up to 20 consumers per stream. A given consumer can only be registered with one stream at a time.
 * For more details, see the [Amazon Kinesis Stream Consumer Documentation](https://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-consumers.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kinesis.Stream("example", {
 *     name: "example-stream",
 *     shardCount: 1,
 * });
 * const exampleStreamConsumer = new aws.kinesis.StreamConsumer("example", {
 *     name: "example-consumer",
 *     streamArn: example.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kinesis.Stream("example",
 *     name="example-stream",
 *     shard_count=1)
 * example_stream_consumer = aws.kinesis.StreamConsumer("example",
 *     name="example-consumer",
 *     stream_arn=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kinesis.Stream("example", new()
 *     {
 *         Name = "example-stream",
 *         ShardCount = 1,
 *     });
 *     var exampleStreamConsumer = new Aws.Kinesis.StreamConsumer("example", new()
 *     {
 *         Name = "example-consumer",
 *         StreamArn = example.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kinesis.NewStream(ctx, "example", &kinesis.StreamArgs{
 * 			Name:       pulumi.String("example-stream"),
 * 			ShardCount: pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kinesis.NewStreamConsumer(ctx, "example", &kinesis.StreamConsumerArgs{
 * 			Name:      pulumi.String("example-consumer"),
 * 			StreamArn: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.kinesis.StreamConsumer;
 * import com.pulumi.aws.kinesis.StreamConsumerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Stream("example", StreamArgs.builder()
 *             .name("example-stream")
 *             .shardCount(1)
 *             .build());
 *         var exampleStreamConsumer = new StreamConsumer("exampleStreamConsumer", StreamConsumerArgs.builder()
 *             .name("example-consumer")
 *             .streamArn(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kinesis:Stream
 *     properties:
 *       name: example-stream
 *       shardCount: 1
 *   exampleStreamConsumer:
 *     type: aws:kinesis:StreamConsumer
 *     name: example
 *     properties:
 *       name: example-consumer
 *       streamArn: ${example.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Kinesis Stream Consumers using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:kinesis/streamConsumer:StreamConsumer example arn:aws:kinesis:us-west-2:123456789012:stream/example/consumer/example:1616044553
 * ```
 */
public class StreamConsumer internal constructor(
    override val javaResource: com.pulumi.aws.kinesis.StreamConsumer,
) : KotlinCustomResource(javaResource, StreamConsumerMapper) {
    /**
     * Amazon Resource Name (ARN) of the stream consumer.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Approximate timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of when the stream consumer was created.
     */
    public val creationTimestamp: Output<String>
        get() = javaResource.creationTimestamp().applyValue({ args0 -> args0 })

    /**
     * Name of the stream consumer.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the data stream the consumer is registered with.
     */
    public val streamArn: Output<String>
        get() = javaResource.streamArn().applyValue({ args0 -> args0 })
}

public object StreamConsumerMapper : ResourceMapper<StreamConsumer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kinesis.StreamConsumer::class == javaResource::class

    override fun map(javaResource: Resource): StreamConsumer = StreamConsumer(
        javaResource as
            com.pulumi.aws.kinesis.StreamConsumer,
    )
}

/**
 * @see [StreamConsumer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StreamConsumer].
 */
public suspend fun streamConsumer(
    name: String,
    block: suspend StreamConsumerResourceBuilder.() -> Unit,
): StreamConsumer {
    val builder = StreamConsumerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StreamConsumer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun streamConsumer(name: String): StreamConsumer {
    val builder = StreamConsumerResourceBuilder()
    builder.name(name)
    return builder.build()
}
