@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsKinesisFirehoseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceArn The ARN of the Kinesis Firehose delivery stream.
 * @property roleArn The ARN of the IAM Role used to access the stream.
 */
public data class AnalyticsApplicationInputsKinesisFirehoseArgs(
    public val resourceArn: Output<String>,
    public val roleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsKinesisFirehoseArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsKinesisFirehoseArgs = com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsKinesisFirehoseArgs.builder()
        .resourceArn(resourceArn.applyValue({ args0 -> args0 }))
        .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsApplicationInputsKinesisFirehoseArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationInputsKinesisFirehoseArgsBuilder internal constructor() {
    private var resourceArn: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The ARN of the Kinesis Firehose delivery stream.
     */
    @JvmName("hvdvjijnyikrnyqi")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The ARN of the IAM Role used to access the stream.
     */
    @JvmName("mtktiopuvkykkanc")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The ARN of the Kinesis Firehose delivery stream.
     */
    @JvmName("gqddymofgyddvits")
    public suspend fun resourceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    /**
     * @param value The ARN of the IAM Role used to access the stream.
     */
    @JvmName("qlhvecgtrclsrdvt")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): AnalyticsApplicationInputsKinesisFirehoseArgs =
        AnalyticsApplicationInputsKinesisFirehoseArgs(
            resourceArn = resourceArn ?: throw PulumiNullFieldException("resourceArn"),
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        )
}
