@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsProcessingConfigurationLambdaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceArn The ARN of the Lambda function.
 * @property roleArn The ARN of the IAM Role used to access the Lambda function.
 */
public data class AnalyticsApplicationInputsProcessingConfigurationLambdaArgs(
    public val resourceArn: Output<String>,
    public val roleArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsProcessingConfigurationLambdaArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsProcessingConfigurationLambdaArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsProcessingConfigurationLambdaArgs.builder()
            .resourceArn(resourceArn.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsApplicationInputsProcessingConfigurationLambdaArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationInputsProcessingConfigurationLambdaArgsBuilder internal constructor() {
    private var resourceArn: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The ARN of the Lambda function.
     */
    @JvmName("mbroncgxbbcbuisk")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The ARN of the IAM Role used to access the Lambda function.
     */
    @JvmName("nuuufftnhyhieddx")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The ARN of the Lambda function.
     */
    @JvmName("skdygvjdjprkimxj")
    public suspend fun resourceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    /**
     * @param value The ARN of the IAM Role used to access the Lambda function.
     */
    @JvmName("ofqshrdvnfcyrsnf")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): AnalyticsApplicationInputsProcessingConfigurationLambdaArgs =
        AnalyticsApplicationInputsProcessingConfigurationLambdaArgs(
            resourceArn = resourceArn ?: throw PulumiNullFieldException("resourceArn"),
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        )
}
