@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mapping The Mapping reference to the data element.
 * @property name Name of the column.
 * @property sqlType The SQL Type of the column.
 */
public data class AnalyticsApplicationInputsSchemaRecordColumnArgs(
    public val mapping: Output<String>? = null,
    public val name: Output<String>,
    public val sqlType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordColumnArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordColumnArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordColumnArgs.builder()
            .mapping(mapping?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .sqlType(sqlType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsApplicationInputsSchemaRecordColumnArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationInputsSchemaRecordColumnArgsBuilder internal constructor() {
    private var mapping: Output<String>? = null

    private var name: Output<String>? = null

    private var sqlType: Output<String>? = null

    /**
     * @param value The Mapping reference to the data element.
     */
    @JvmName("coypajsdwlkufnhg")
    public suspend fun mapping(`value`: Output<String>) {
        this.mapping = value
    }

    /**
     * @param value Name of the column.
     */
    @JvmName("chvrmsqioculhvhs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The SQL Type of the column.
     */
    @JvmName("eyfyvwjytewprmko")
    public suspend fun sqlType(`value`: Output<String>) {
        this.sqlType = value
    }

    /**
     * @param value The Mapping reference to the data element.
     */
    @JvmName("kpuqinlqtljefvcn")
    public suspend fun mapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mapping = mapped
    }

    /**
     * @param value Name of the column.
     */
    @JvmName("mjpghrqhibqtdqgp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The SQL Type of the column.
     */
    @JvmName("rtjhtopkgpwnbdjb")
    public suspend fun sqlType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlType = mapped
    }

    internal fun build(): AnalyticsApplicationInputsSchemaRecordColumnArgs =
        AnalyticsApplicationInputsSchemaRecordColumnArgs(
            mapping = mapping,
            name = name ?: throw PulumiNullFieldException("name"),
            sqlType = sqlType ?: throw PulumiNullFieldException("sqlType"),
        )
}
