@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property recordRowPath Path to the top-level parent that contains the records.
 */
public data class AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs(
    public val recordRowPath: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs.builder()
            .recordRowPath(recordRowPath.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgsBuilder internal constructor() {
    private var recordRowPath: Output<String>? = null

    /**
     * @param value Path to the top-level parent that contains the records.
     */
    @JvmName("mhbrogouvlaycdsw")
    public suspend fun recordRowPath(`value`: Output<String>) {
        this.recordRowPath = value
    }

    /**
     * @param value Path to the top-level parent that contains the records.
     */
    @JvmName("nbirwrlkmtdbgltp")
    public suspend fun recordRowPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordRowPath = mapped
    }

    internal fun build(): AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs =
        AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs(
            recordRowPath = recordRowPath ?: throw PulumiNullFieldException("recordRowPath"),
        )
}
