@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property id The ARN of the Kinesis Analytics Application.
 * @property kinesisFirehose The Kinesis Firehose configuration for the destination stream. Conflicts with `kinesis_stream`.
 * See Kinesis Firehose below for more details.
 * @property kinesisStream The Kinesis Stream configuration for the destination stream. Conflicts with `kinesis_firehose`.
 * See Kinesis Stream below for more details.
 * @property lambda The Lambda function destination. See Lambda below for more details.
 * @property name The Name of the in-application stream.
 * @property schema The Schema format of the data written to the destination. See Destination Schema below for more details.
 */
public data class AnalyticsApplicationOutputArgs(
    public val id: Output<String>? = null,
    public val kinesisFirehose: Output<AnalyticsApplicationOutputKinesisFirehoseArgs>? = null,
    public val kinesisStream: Output<AnalyticsApplicationOutputKinesisStreamArgs>? = null,
    public val lambda: Output<AnalyticsApplicationOutputLambdaArgs>? = null,
    public val name: Output<String>,
    public val schema: Output<AnalyticsApplicationOutputSchemaArgs>,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .kinesisFirehose(kinesisFirehose?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kinesisStream(kinesisStream?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lambda(lambda?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .schema(schema.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AnalyticsApplicationOutputArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationOutputArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var kinesisFirehose: Output<AnalyticsApplicationOutputKinesisFirehoseArgs>? = null

    private var kinesisStream: Output<AnalyticsApplicationOutputKinesisStreamArgs>? = null

    private var lambda: Output<AnalyticsApplicationOutputLambdaArgs>? = null

    private var name: Output<String>? = null

    private var schema: Output<AnalyticsApplicationOutputSchemaArgs>? = null

    /**
     * @param value The ARN of the Kinesis Analytics Application.
     */
    @JvmName("muncxijcssstkbfu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The Kinesis Firehose configuration for the destination stream. Conflicts with `kinesis_stream`.
     * See Kinesis Firehose below for more details.
     */
    @JvmName("qvqgunwxouhrrsxd")
    public suspend fun kinesisFirehose(`value`: Output<AnalyticsApplicationOutputKinesisFirehoseArgs>) {
        this.kinesisFirehose = value
    }

    /**
     * @param value The Kinesis Stream configuration for the destination stream. Conflicts with `kinesis_firehose`.
     * See Kinesis Stream below for more details.
     */
    @JvmName("nxhkgcouwlasomul")
    public suspend fun kinesisStream(`value`: Output<AnalyticsApplicationOutputKinesisStreamArgs>) {
        this.kinesisStream = value
    }

    /**
     * @param value The Lambda function destination. See Lambda below for more details.
     */
    @JvmName("rnauthhmeekrvhxp")
    public suspend fun lambda(`value`: Output<AnalyticsApplicationOutputLambdaArgs>) {
        this.lambda = value
    }

    /**
     * @param value The Name of the in-application stream.
     */
    @JvmName("cmqbwqhvckbapymw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Schema format of the data written to the destination. See Destination Schema below for more details.
     */
    @JvmName("mppelxbjnlswscsb")
    public suspend fun schema(`value`: Output<AnalyticsApplicationOutputSchemaArgs>) {
        this.schema = value
    }

    /**
     * @param value The ARN of the Kinesis Analytics Application.
     */
    @JvmName("hbvfvtysdfushipw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The Kinesis Firehose configuration for the destination stream. Conflicts with `kinesis_stream`.
     * See Kinesis Firehose below for more details.
     */
    @JvmName("ggakfkipwfqnrpfs")
    public suspend fun kinesisFirehose(`value`: AnalyticsApplicationOutputKinesisFirehoseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisFirehose = mapped
    }

    /**
     * @param argument The Kinesis Firehose configuration for the destination stream. Conflicts with `kinesis_stream`.
     * See Kinesis Firehose below for more details.
     */
    @JvmName("ocvpxghscwmnopop")
    public suspend fun kinesisFirehose(argument: suspend AnalyticsApplicationOutputKinesisFirehoseArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationOutputKinesisFirehoseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kinesisFirehose = mapped
    }

    /**
     * @param value The Kinesis Stream configuration for the destination stream. Conflicts with `kinesis_firehose`.
     * See Kinesis Stream below for more details.
     */
    @JvmName("fblincweodkqrloh")
    public suspend fun kinesisStream(`value`: AnalyticsApplicationOutputKinesisStreamArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisStream = mapped
    }

    /**
     * @param argument The Kinesis Stream configuration for the destination stream. Conflicts with `kinesis_firehose`.
     * See Kinesis Stream below for more details.
     */
    @JvmName("sxtgvlahnnmtuvhg")
    public suspend fun kinesisStream(argument: suspend AnalyticsApplicationOutputKinesisStreamArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationOutputKinesisStreamArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kinesisStream = mapped
    }

    /**
     * @param value The Lambda function destination. See Lambda below for more details.
     */
    @JvmName("nlmtxfvylkwlqgvc")
    public suspend fun lambda(`value`: AnalyticsApplicationOutputLambdaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambda = mapped
    }

    /**
     * @param argument The Lambda function destination. See Lambda below for more details.
     */
    @JvmName("qgwkbucpfahnqlbj")
    public suspend fun lambda(argument: suspend AnalyticsApplicationOutputLambdaArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationOutputLambdaArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.lambda = mapped
    }

    /**
     * @param value The Name of the in-application stream.
     */
    @JvmName("emoibhbfgdwsedti")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Schema format of the data written to the destination. See Destination Schema below for more details.
     */
    @JvmName("wykddvkrupedlncb")
    public suspend fun schema(`value`: AnalyticsApplicationOutputSchemaArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param argument The Schema format of the data written to the destination. See Destination Schema below for more details.
     */
    @JvmName("ufsebggdglksiqvn")
    public suspend fun schema(argument: suspend AnalyticsApplicationOutputSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationOutputSchemaArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    internal fun build(): AnalyticsApplicationOutputArgs = AnalyticsApplicationOutputArgs(
        id = id,
        kinesisFirehose = kinesisFirehose,
        kinesisStream = kinesisStream,
        lambda = lambda,
        name = name ?: throw PulumiNullFieldException("name"),
        schema = schema ?: throw PulumiNullFieldException("schema"),
    )
}
