@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputKinesisFirehoseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceArn The ARN of the Kinesis Firehose delivery stream.
 * @property roleArn The ARN of the IAM Role used to access the stream.
 */
public data class AnalyticsApplicationOutputKinesisFirehoseArgs(
    public val resourceArn: Output<String>,
    public val roleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputKinesisFirehoseArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputKinesisFirehoseArgs = com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputKinesisFirehoseArgs.builder()
        .resourceArn(resourceArn.applyValue({ args0 -> args0 }))
        .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsApplicationOutputKinesisFirehoseArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationOutputKinesisFirehoseArgsBuilder internal constructor() {
    private var resourceArn: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The ARN of the Kinesis Firehose delivery stream.
     */
    @JvmName("uniastudkjhfhdkw")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The ARN of the IAM Role used to access the stream.
     */
    @JvmName("lecqogsgklvpmwsw")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The ARN of the Kinesis Firehose delivery stream.
     */
    @JvmName("mqdhqkkvmqjmsojo")
    public suspend fun resourceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    /**
     * @param value The ARN of the IAM Role used to access the stream.
     */
    @JvmName("mmlppqnxqdnoxihj")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): AnalyticsApplicationOutputKinesisFirehoseArgs =
        AnalyticsApplicationOutputKinesisFirehoseArgs(
            resourceArn = resourceArn ?: throw PulumiNullFieldException("resourceArn"),
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        )
}
