@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property recordFormatType The Format Type of the records on the output stream. Can be `CSV` or `JSON`.
 */
public data class AnalyticsApplicationOutputSchemaArgs(
    public val recordFormatType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputSchemaArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputSchemaArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputSchemaArgs.builder()
            .recordFormatType(recordFormatType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsApplicationOutputSchemaArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationOutputSchemaArgsBuilder internal constructor() {
    private var recordFormatType: Output<String>? = null

    /**
     * @param value The Format Type of the records on the output stream. Can be `CSV` or `JSON`.
     */
    @JvmName("fxqmajdoccyhmqju")
    public suspend fun recordFormatType(`value`: Output<String>) {
        this.recordFormatType = value
    }

    /**
     * @param value The Format Type of the records on the output stream. Can be `CSV` or `JSON`.
     */
    @JvmName("vftigejpyiqfiocr")
    public suspend fun recordFormatType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordFormatType = mapped
    }

    internal fun build(): AnalyticsApplicationOutputSchemaArgs = AnalyticsApplicationOutputSchemaArgs(
        recordFormatType = recordFormatType ?: throw PulumiNullFieldException("recordFormatType"),
    )
}
