@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property recordColumns The Record Column mapping for the streaming source data element.
 * See Record Columns below for more details.
 * @property recordEncoding The Encoding of the record in the streaming source.
 * @property recordFormat The Record Format and mapping information to schematize a record.
 * See Record Format below for more details.
 */
public data class AnalyticsApplicationReferenceDataSourcesSchemaArgs(
    public val recordColumns: Output<List<AnalyticsApplicationReferenceDataSourcesSchemaRecordColumnArgs>>,
    public val recordEncoding: Output<String>? = null,
    public val recordFormat: Output<AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesSchemaArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesSchemaArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesSchemaArgs.builder()
            .recordColumns(
                recordColumns.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .recordEncoding(recordEncoding?.applyValue({ args0 -> args0 }))
            .recordFormat(recordFormat.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AnalyticsApplicationReferenceDataSourcesSchemaArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationReferenceDataSourcesSchemaArgsBuilder internal constructor() {
    private var recordColumns:
        Output<List<AnalyticsApplicationReferenceDataSourcesSchemaRecordColumnArgs>>? = null

    private var recordEncoding: Output<String>? = null

    private var recordFormat: Output<AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgs>? =
        null

    /**
     * @param value The Record Column mapping for the streaming source data element.
     * See Record Columns below for more details.
     */
    @JvmName("mqrjsxhkfdwbgsde")
    public suspend fun recordColumns(`value`: Output<List<AnalyticsApplicationReferenceDataSourcesSchemaRecordColumnArgs>>) {
        this.recordColumns = value
    }

    @JvmName("jxjjwjgirssmfosu")
    public suspend fun recordColumns(vararg values: Output<AnalyticsApplicationReferenceDataSourcesSchemaRecordColumnArgs>) {
        this.recordColumns = Output.all(values.asList())
    }

    /**
     * @param values The Record Column mapping for the streaming source data element.
     * See Record Columns below for more details.
     */
    @JvmName("opmcdrxkpcdpprpe")
    public suspend fun recordColumns(values: List<Output<AnalyticsApplicationReferenceDataSourcesSchemaRecordColumnArgs>>) {
        this.recordColumns = Output.all(values)
    }

    /**
     * @param value The Encoding of the record in the streaming source.
     */
    @JvmName("xrhwqpycmmwobrsc")
    public suspend fun recordEncoding(`value`: Output<String>) {
        this.recordEncoding = value
    }

    /**
     * @param value The Record Format and mapping information to schematize a record.
     * See Record Format below for more details.
     */
    @JvmName("vsduknqaljhdusdy")
    public suspend fun recordFormat(`value`: Output<AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgs>) {
        this.recordFormat = value
    }

    /**
     * @param value The Record Column mapping for the streaming source data element.
     * See Record Columns below for more details.
     */
    @JvmName("momitumksjpysdqa")
    public suspend fun recordColumns(`value`: List<AnalyticsApplicationReferenceDataSourcesSchemaRecordColumnArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordColumns = mapped
    }

    /**
     * @param argument The Record Column mapping for the streaming source data element.
     * See Record Columns below for more details.
     */
    @JvmName("vpfbrjouyeaefxsw")
    public suspend fun recordColumns(argument: List<suspend AnalyticsApplicationReferenceDataSourcesSchemaRecordColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AnalyticsApplicationReferenceDataSourcesSchemaRecordColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.recordColumns = mapped
    }

    /**
     * @param argument The Record Column mapping for the streaming source data element.
     * See Record Columns below for more details.
     */
    @JvmName("bwhggtxiwmxsgtoa")
    public suspend fun recordColumns(vararg argument: suspend AnalyticsApplicationReferenceDataSourcesSchemaRecordColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AnalyticsApplicationReferenceDataSourcesSchemaRecordColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.recordColumns = mapped
    }

    /**
     * @param argument The Record Column mapping for the streaming source data element.
     * See Record Columns below for more details.
     */
    @JvmName("txkdxfvnikrnvaml")
    public suspend fun recordColumns(argument: suspend AnalyticsApplicationReferenceDataSourcesSchemaRecordColumnArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                AnalyticsApplicationReferenceDataSourcesSchemaRecordColumnArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.recordColumns = mapped
    }

    /**
     * @param values The Record Column mapping for the streaming source data element.
     * See Record Columns below for more details.
     */
    @JvmName("xiljnbmdjoehquag")
    public suspend fun recordColumns(vararg values: AnalyticsApplicationReferenceDataSourcesSchemaRecordColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordColumns = mapped
    }

    /**
     * @param value The Encoding of the record in the streaming source.
     */
    @JvmName("pqvxwtdnuebqkfcm")
    public suspend fun recordEncoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordEncoding = mapped
    }

    /**
     * @param value The Record Format and mapping information to schematize a record.
     * See Record Format below for more details.
     */
    @JvmName("csrslgnyyowpghcd")
    public suspend fun recordFormat(`value`: AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordFormat = mapped
    }

    /**
     * @param argument The Record Format and mapping information to schematize a record.
     * See Record Format below for more details.
     */
    @JvmName("yumefptgkmgjwddy")
    public suspend fun recordFormat(argument: suspend AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgsBuilder.() -> Unit) {
        val toBeMapped =
            AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.recordFormat = mapped
    }

    internal fun build(): AnalyticsApplicationReferenceDataSourcesSchemaArgs =
        AnalyticsApplicationReferenceDataSourcesSchemaArgs(
            recordColumns = recordColumns ?: throw PulumiNullFieldException("recordColumns"),
            recordEncoding = recordEncoding,
            recordFormat = recordFormat ?: throw PulumiNullFieldException("recordFormat"),
        )
}
