@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property mappingParameters The Mapping Information for the record format.
 * See Mapping Parameters below for more details.
 * @property recordFormatType The type of Record Format. Can be `CSV` or `JSON`.
 */
public data class AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgs(
    public val mappingParameters: Output<AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgs>? =
        null,
    public val recordFormatType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgs.builder()
            .mappingParameters(mappingParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .recordFormatType(recordFormatType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgsBuilder internal constructor() {
    private var mappingParameters:
        Output<AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgs>? =
        null

    private var recordFormatType: Output<String>? = null

    /**
     * @param value The Mapping Information for the record format.
     * See Mapping Parameters below for more details.
     */
    @JvmName("pkpsbihuqntfkbdo")
    public suspend fun mappingParameters(`value`: Output<AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgs>) {
        this.mappingParameters = value
    }

    /**
     * @param value The type of Record Format. Can be `CSV` or `JSON`.
     */
    @JvmName("jursnnlftjyuswnk")
    public suspend fun recordFormatType(`value`: Output<String>) {
        this.recordFormatType = value
    }

    /**
     * @param value The Mapping Information for the record format.
     * See Mapping Parameters below for more details.
     */
    @JvmName("oxwcxmcpsusgfpys")
    public suspend fun mappingParameters(`value`: AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappingParameters = mapped
    }

    /**
     * @param argument The Mapping Information for the record format.
     * See Mapping Parameters below for more details.
     */
    @JvmName("yfawededrbsoujvr")
    public suspend fun mappingParameters(argument: suspend AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.mappingParameters = mapped
    }

    /**
     * @param value The type of Record Format. Can be `CSV` or `JSON`.
     */
    @JvmName("xigiuacjwgbhkuxd")
    public suspend fun recordFormatType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordFormatType = mapped
    }

    internal fun build(): AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgs =
        AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatArgs(
            mappingParameters = mappingParameters,
            recordFormatType = recordFormatType,
        )
}
