@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bufferingInterval Buffer incoming data for the specified period of time, in seconds between 0 to 900, before delivering it to the destination.  The default value is 300s.
 * @property bufferingSize Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
 * @property clusterEndpoint The endpoint to use when communicating with the cluster. Conflicts with `domain_arn`.
 * @property domainArn The ARN of the Amazon ES domain.  The pattern needs to be `arn:.*`.  Conflicts with `cluster_endpoint`.
 * @property indexName The Elasticsearch index name.
 * @property indexRotationPeriod The Elasticsearch index rotation period.  Index rotation appends a timestamp to the IndexName to facilitate expiration of old data.  Valid values are `NoRotation`, `OneHour`, `OneDay`, `OneWeek`, and `OneMonth`.  The default value is `OneDay`.
 * @property processingConfiguration The data processing configuration.  See `processing_configuration` block below for details.
 * @property retryDuration After an initial failure to deliver to Amazon Elasticsearch, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
 * @property roleArn The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for indexing documents.  The IAM role must have permission for `DescribeElasticsearchDomain`, `DescribeElasticsearchDomains`, and `DescribeElasticsearchDomainConfig`.  The pattern needs to be `arn:.*`.
 * @property s3BackupMode Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
 * @property s3Configuration The S3 Configuration. See `s3_configuration` block below for details.
 * @property typeName The Elasticsearch type name with maximum length of 100 characters.
 * @property vpcConfig The VPC configuration for the delivery stream to connect to Elastic Search associated with the VPC. See `vpc_config` block below for details.
 */
public data class FirehoseDeliveryStreamElasticsearchConfigurationArgs(
    public val bufferingInterval: Output<Int>? = null,
    public val bufferingSize: Output<Int>? = null,
    public val cloudwatchLoggingOptions: Output<FirehoseDeliveryStreamElasticsearchConfigurationCloudwatchLoggingOptionsArgs>? = null,
    public val clusterEndpoint: Output<String>? = null,
    public val domainArn: Output<String>? = null,
    public val indexName: Output<String>,
    public val indexRotationPeriod: Output<String>? = null,
    public val processingConfiguration: Output<FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs>? = null,
    public val retryDuration: Output<Int>? = null,
    public val roleArn: Output<String>,
    public val s3BackupMode: Output<String>? = null,
    public val s3Configuration: Output<FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs>,
    public val typeName: Output<String>? = null,
    public val vpcConfig: Output<FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgs.builder()
            .bufferingInterval(bufferingInterval?.applyValue({ args0 -> args0 }))
            .bufferingSize(bufferingSize?.applyValue({ args0 -> args0 }))
            .cloudwatchLoggingOptions(
                cloudwatchLoggingOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clusterEndpoint(clusterEndpoint?.applyValue({ args0 -> args0 }))
            .domainArn(domainArn?.applyValue({ args0 -> args0 }))
            .indexName(indexName.applyValue({ args0 -> args0 }))
            .indexRotationPeriod(indexRotationPeriod?.applyValue({ args0 -> args0 }))
            .processingConfiguration(
                processingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .retryDuration(retryDuration?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .s3BackupMode(s3BackupMode?.applyValue({ args0 -> args0 }))
            .s3Configuration(s3Configuration.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .typeName(typeName?.applyValue({ args0 -> args0 }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamElasticsearchConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamElasticsearchConfigurationArgsBuilder internal constructor() {
    private var bufferingInterval: Output<Int>? = null

    private var bufferingSize: Output<Int>? = null

    private var cloudwatchLoggingOptions:
        Output<FirehoseDeliveryStreamElasticsearchConfigurationCloudwatchLoggingOptionsArgs>? = null

    private var clusterEndpoint: Output<String>? = null

    private var domainArn: Output<String>? = null

    private var indexName: Output<String>? = null

    private var indexRotationPeriod: Output<String>? = null

    private var processingConfiguration:
        Output<FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs>? = null

    private var retryDuration: Output<Int>? = null

    private var roleArn: Output<String>? = null

    private var s3BackupMode: Output<String>? = null

    private var s3Configuration:
        Output<FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs>? = null

    private var typeName: Output<String>? = null

    private var vpcConfig: Output<FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs>? =
        null

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds between 0 to 900, before delivering it to the destination.  The default value is 300s.
     */
    @JvmName("xplgxvxulpjgvpoo")
    public suspend fun bufferingInterval(`value`: Output<Int>) {
        this.bufferingInterval = value
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
     */
    @JvmName("beawkxoxhkeascsm")
    public suspend fun bufferingSize(`value`: Output<Int>) {
        this.bufferingSize = value
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("kvxsjupfhipevtrs")
    public suspend fun cloudwatchLoggingOptions(`value`: Output<FirehoseDeliveryStreamElasticsearchConfigurationCloudwatchLoggingOptionsArgs>) {
        this.cloudwatchLoggingOptions = value
    }

    /**
     * @param value The endpoint to use when communicating with the cluster. Conflicts with `domain_arn`.
     */
    @JvmName("ccblqvyhqojcgxsk")
    public suspend fun clusterEndpoint(`value`: Output<String>) {
        this.clusterEndpoint = value
    }

    /**
     * @param value The ARN of the Amazon ES domain.  The pattern needs to be `arn:.*`.  Conflicts with `cluster_endpoint`.
     */
    @JvmName("cjusnarsruhjjkpl")
    public suspend fun domainArn(`value`: Output<String>) {
        this.domainArn = value
    }

    /**
     * @param value The Elasticsearch index name.
     */
    @JvmName("tydthncgghtgseup")
    public suspend fun indexName(`value`: Output<String>) {
        this.indexName = value
    }

    /**
     * @param value The Elasticsearch index rotation period.  Index rotation appends a timestamp to the IndexName to facilitate expiration of old data.  Valid values are `NoRotation`, `OneHour`, `OneDay`, `OneWeek`, and `OneMonth`.  The default value is `OneDay`.
     */
    @JvmName("beshtebedjbxcdct")
    public suspend fun indexRotationPeriod(`value`: Output<String>) {
        this.indexRotationPeriod = value
    }

    /**
     * @param value The data processing configuration.  See `processing_configuration` block below for details.
     */
    @JvmName("lfgpvayaidhfqvgp")
    public suspend fun processingConfiguration(`value`: Output<FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs>) {
        this.processingConfiguration = value
    }

    /**
     * @param value After an initial failure to deliver to Amazon Elasticsearch, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
     */
    @JvmName("xpcxlujdadriyoib")
    public suspend fun retryDuration(`value`: Output<Int>) {
        this.retryDuration = value
    }

    /**
     * @param value The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for indexing documents.  The IAM role must have permission for `DescribeElasticsearchDomain`, `DescribeElasticsearchDomains`, and `DescribeElasticsearchDomainConfig`.  The pattern needs to be `arn:.*`.
     */
    @JvmName("scspcuetxytsicoq")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
     */
    @JvmName("bsqnaaddlasmgurk")
    public suspend fun s3BackupMode(`value`: Output<String>) {
        this.s3BackupMode = value
    }

    /**
     * @param value The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("djcjilertufivuki")
    public suspend fun s3Configuration(`value`: Output<FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs>) {
        this.s3Configuration = value
    }

    /**
     * @param value The Elasticsearch type name with maximum length of 100 characters.
     */
    @JvmName("rcehggfxerdnthyf")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value The VPC configuration for the delivery stream to connect to Elastic Search associated with the VPC. See `vpc_config` block below for details.
     */
    @JvmName("nqwdmgwpeovrmlrg")
    public suspend fun vpcConfig(`value`: Output<FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds between 0 to 900, before delivering it to the destination.  The default value is 300s.
     */
    @JvmName("ialedhdxdyqjyxtr")
    public suspend fun bufferingInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingInterval = mapped
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
     */
    @JvmName("kcmfjshvfnetqemi")
    public suspend fun bufferingSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingSize = mapped
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("cvbfjsqeitollmcp")
    public suspend fun cloudwatchLoggingOptions(`value`: FirehoseDeliveryStreamElasticsearchConfigurationCloudwatchLoggingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param argument The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("oewmlvehocbexxql")
    public suspend fun cloudwatchLoggingOptions(argument: suspend FirehoseDeliveryStreamElasticsearchConfigurationCloudwatchLoggingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamElasticsearchConfigurationCloudwatchLoggingOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param value The endpoint to use when communicating with the cluster. Conflicts with `domain_arn`.
     */
    @JvmName("rwtodmdvbxilxogn")
    public suspend fun clusterEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterEndpoint = mapped
    }

    /**
     * @param value The ARN of the Amazon ES domain.  The pattern needs to be `arn:.*`.  Conflicts with `cluster_endpoint`.
     */
    @JvmName("jnabxxfxjkjyedks")
    public suspend fun domainArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainArn = mapped
    }

    /**
     * @param value The Elasticsearch index name.
     */
    @JvmName("mvxcdxunkqgjejvs")
    public suspend fun indexName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexName = mapped
    }

    /**
     * @param value The Elasticsearch index rotation period.  Index rotation appends a timestamp to the IndexName to facilitate expiration of old data.  Valid values are `NoRotation`, `OneHour`, `OneDay`, `OneWeek`, and `OneMonth`.  The default value is `OneDay`.
     */
    @JvmName("fijmrwseyflreuby")
    public suspend fun indexRotationPeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexRotationPeriod = mapped
    }

    /**
     * @param value The data processing configuration.  See `processing_configuration` block below for details.
     */
    @JvmName("kuwcawrcdswbbxxi")
    public suspend fun processingConfiguration(`value`: FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processingConfiguration = mapped
    }

    /**
     * @param argument The data processing configuration.  See `processing_configuration` block below for details.
     */
    @JvmName("jqxesivcjalxswpb")
    public suspend fun processingConfiguration(argument: suspend FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.processingConfiguration = mapped
    }

    /**
     * @param value After an initial failure to deliver to Amazon Elasticsearch, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
     */
    @JvmName("ouynnhknifkbqwad")
    public suspend fun retryDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryDuration = mapped
    }

    /**
     * @param value The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for indexing documents.  The IAM role must have permission for `DescribeElasticsearchDomain`, `DescribeElasticsearchDomains`, and `DescribeElasticsearchDomainConfig`.  The pattern needs to be `arn:.*`.
     */
    @JvmName("kbaokjhptigkasjb")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
     */
    @JvmName("qwhtapjsixicrskf")
    public suspend fun s3BackupMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BackupMode = mapped
    }

    /**
     * @param value The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("opeiwqkollvwxret")
    public suspend fun s3Configuration(`value`: FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Configuration = mapped
    }

    /**
     * @param argument The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("xwkrlnhruvhoeqmb")
    public suspend fun s3Configuration(argument: suspend FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3Configuration = mapped
    }

    /**
     * @param value The Elasticsearch type name with maximum length of 100 characters.
     */
    @JvmName("qxptkhgmgarjxtvu")
    public suspend fun typeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    /**
     * @param value The VPC configuration for the delivery stream to connect to Elastic Search associated with the VPC. See `vpc_config` block below for details.
     */
    @JvmName("nblvdyslvjcgbnvv")
    public suspend fun vpcConfig(`value`: FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument The VPC configuration for the delivery stream to connect to Elastic Search associated with the VPC. See `vpc_config` block below for details.
     */
    @JvmName("criglqbjvgxlheqp")
    public suspend fun vpcConfig(argument: suspend FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): FirehoseDeliveryStreamElasticsearchConfigurationArgs =
        FirehoseDeliveryStreamElasticsearchConfigurationArgs(
            bufferingInterval = bufferingInterval,
            bufferingSize = bufferingSize,
            cloudwatchLoggingOptions = cloudwatchLoggingOptions,
            clusterEndpoint = clusterEndpoint,
            domainArn = domainArn,
            indexName = indexName ?: throw PulumiNullFieldException("indexName"),
            indexRotationPeriod = indexRotationPeriod,
            processingConfiguration = processingConfiguration,
            retryDuration = retryDuration,
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            s3BackupMode = s3BackupMode,
            s3Configuration = s3Configuration ?: throw PulumiNullFieldException("s3Configuration"),
            typeName = typeName,
            vpcConfig = vpcConfig,
        )
}
