@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property roleArn The ARN of the IAM role to be assumed by Firehose for calling the Amazon EC2 configuration API and for creating network interfaces. Make sure role has necessary [IAM permissions](https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-es-vpc)
 * @property securityGroupIds A list of security group IDs to associate with Kinesis Firehose.
 * @property subnetIds A list of subnet IDs to associate with Kinesis Firehose.
 * @property vpcId
 */
public data class FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs(
    public val roleArn: Output<String>,
    public val securityGroupIds: Output<List<String>>,
    public val subnetIds: Output<List<String>>,
    public val vpcId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs.builder()
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgsBuilder internal constructor() {
    private var roleArn: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The ARN of the IAM role to be assumed by Firehose for calling the Amazon EC2 configuration API and for creating network interfaces. Make sure role has necessary [IAM permissions](https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-es-vpc)
     */
    @JvmName("ovfgmgchnistwvai")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A list of security group IDs to associate with Kinesis Firehose.
     */
    @JvmName("demggjgcvgdbivoi")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("xecohfgxwupywmwj")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of security group IDs to associate with Kinesis Firehose.
     */
    @JvmName("ygihxfurrgkglhov")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value A list of subnet IDs to associate with Kinesis Firehose.
     */
    @JvmName("xbqurpblphinrljl")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("lhmhockrrpjkvbig")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of subnet IDs to associate with Kinesis Firehose.
     */
    @JvmName("wqgvcqqffikibusx")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("lvopkdddxmhrcabt")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ARN of the IAM role to be assumed by Firehose for calling the Amazon EC2 configuration API and for creating network interfaces. Make sure role has necessary [IAM permissions](https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-es-vpc)
     */
    @JvmName("aqwugwvmivihdynf")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A list of security group IDs to associate with Kinesis Firehose.
     */
    @JvmName("olichdoygxmdfpel")
    public suspend fun securityGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of security group IDs to associate with Kinesis Firehose.
     */
    @JvmName("voynforjyjtauehe")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value A list of subnet IDs to associate with Kinesis Firehose.
     */
    @JvmName("ykkxsofplpheesdw")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of subnet IDs to associate with Kinesis Firehose.
     */
    @JvmName("bnbgommymjqkhapi")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("cbbdtcqdffrmbgsd")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs =
        FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs(
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            securityGroupIds = securityGroupIds ?: throw PulumiNullFieldException("securityGroupIds"),
            subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
            vpcId = vpcId,
        )
}
