@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables data processing.
 * @property processors Specifies the data processors as multiple blocks. See `processors` block below for details.
 */
public data class FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val processors: Output<List<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .processors(
                processors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var processors:
        Output<List<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs>>? =
        null

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("pmwcmqjeuawtuagd")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("vihkkqsgbailrwpu")
    public suspend fun processors(`value`: Output<List<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = value
    }

    @JvmName("gwfxrxyydxcradpp")
    public suspend fun processors(vararg values: Output<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs>) {
        this.processors = Output.all(values.asList())
    }

    /**
     * @param values Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("giahxldsnqklcddm")
    public suspend fun processors(values: List<Output<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = Output.all(values)
    }

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("ibnuaixwmubjnhlp")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("amsuoxlogjjjadxc")
    public suspend fun processors(`value`: List<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("pnamuciauvvtnegs")
    public suspend fun processors(argument: List<suspend FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("jvddfyxgnnpahgyi")
    public suspend fun processors(vararg argument: suspend FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("tkqugcglumxtrvwv")
    public suspend fun processors(argument: suspend FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param values Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("oyijxepmqgqlhybi")
    public suspend fun processors(vararg values: FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    internal fun build(): FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs =
        FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs(
            enabled = enabled,
            processors = processors,
        )
}
