@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationCloudwatchLoggingOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables the logging. Defaults to `false`.
 * @property logGroupName The CloudWatch group name for logging. This value is required if `enabled` is true.
 * @property logStreamName The CloudWatch log stream name for logging. This value is required if `enabled` is true.
 */
public data class
FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationCloudwatchLoggingOptionsArgs(
    public val enabled: Output<Boolean>? = null,
    public val logGroupName: Output<String>? = null,
    public val logStreamName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationCloudwatchLoggingOptionsArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationCloudwatchLoggingOptionsArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationCloudwatchLoggingOptionsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .logGroupName(logGroupName?.applyValue({ args0 -> args0 }))
            .logStreamName(logStreamName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationCloudwatchLoggingOptionsArgs].
 */
@PulumiTagMarker
public class
FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationCloudwatchLoggingOptionsArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var logGroupName: Output<String>? = null

    private var logStreamName: Output<String>? = null

    /**
     * @param value Enables or disables the logging. Defaults to `false`.
     */
    @JvmName("nhrcoadvpddmqlwx")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The CloudWatch group name for logging. This value is required if `enabled` is true.
     */
    @JvmName("xrmagmpbihwranip")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value The CloudWatch log stream name for logging. This value is required if `enabled` is true.
     */
    @JvmName("diirwxqrvwprfhrh")
    public suspend fun logStreamName(`value`: Output<String>) {
        this.logStreamName = value
    }

    /**
     * @param value Enables or disables the logging. Defaults to `false`.
     */
    @JvmName("rsxjhdvvbhopncur")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The CloudWatch group name for logging. This value is required if `enabled` is true.
     */
    @JvmName("rvclsusldhpkgfdr")
    public suspend fun logGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value The CloudWatch log stream name for logging. This value is required if `enabled` is true.
     */
    @JvmName("xcduyuyupwmcshlr")
    public suspend fun logStreamName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStreamName = mapped
    }

    internal fun build(): FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationCloudwatchLoggingOptionsArgs =
        FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationCloudwatchLoggingOptionsArgs(
            enabled = enabled,
            logGroupName = logGroupName,
            logStreamName = logStreamName,
        )
}
