@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessKey The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
 * @property bufferingInterval Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).
 * @property bufferingSize Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
 * @property name The HTTP endpoint name.
 * @property processingConfiguration The data processing configuration.  See `processing_configuration` block below for details.
 * @property requestConfiguration The request configuration.  See `request_configuration` block below for details.
 * @property retryDuration Total amount of seconds Firehose spends on retries. This duration starts after the initial attempt fails, It does not include the time periods during which Firehose waits for acknowledgment from the specified destination after each attempt. Valid values between `0` and `7200`. Default is `300`.
 * @property roleArn Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs. The pattern needs to be `arn:.*`.
 * @property s3BackupMode Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDataOnly` and `AllData`.  Default value is `FailedDataOnly`.
 * @property s3Configuration The S3 Configuration. See `s3_configuration` block below for details.
 * @property secretsManagerConfiguration The Secret Manager Configuration. See `secrets_manager_configuration` block below for details.
 * @property url The HTTP endpoint URL to which Kinesis Firehose sends your data.
 */
public data class FirehoseDeliveryStreamHttpEndpointConfigurationArgs(
    public val accessKey: Output<String>? = null,
    public val bufferingInterval: Output<Int>? = null,
    public val bufferingSize: Output<Int>? = null,
    public val cloudwatchLoggingOptions: Output<FirehoseDeliveryStreamHttpEndpointConfigurationCloudwatchLoggingOptionsArgs>? = null,
    public val name: Output<String>? = null,
    public val processingConfiguration: Output<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs>? = null,
    public val requestConfiguration: Output<FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs>? = null,
    public val retryDuration: Output<Int>? = null,
    public val roleArn: Output<String>? = null,
    public val s3BackupMode: Output<String>? = null,
    public val s3Configuration: Output<FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs>,
    public val secretsManagerConfiguration: Output<FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgs>? =
        null,
    public val url: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationArgs.builder()
            .accessKey(accessKey?.applyValue({ args0 -> args0 }))
            .bufferingInterval(bufferingInterval?.applyValue({ args0 -> args0 }))
            .bufferingSize(bufferingSize?.applyValue({ args0 -> args0 }))
            .cloudwatchLoggingOptions(
                cloudwatchLoggingOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .processingConfiguration(
                processingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .requestConfiguration(
                requestConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .retryDuration(retryDuration?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .s3BackupMode(s3BackupMode?.applyValue({ args0 -> args0 }))
            .s3Configuration(s3Configuration.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secretsManagerConfiguration(
                secretsManagerConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamHttpEndpointConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamHttpEndpointConfigurationArgsBuilder internal constructor() {
    private var accessKey: Output<String>? = null

    private var bufferingInterval: Output<Int>? = null

    private var bufferingSize: Output<Int>? = null

    private var cloudwatchLoggingOptions:
        Output<FirehoseDeliveryStreamHttpEndpointConfigurationCloudwatchLoggingOptionsArgs>? = null

    private var name: Output<String>? = null

    private var processingConfiguration:
        Output<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs>? = null

    private var requestConfiguration:
        Output<FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs>? = null

    private var retryDuration: Output<Int>? = null

    private var roleArn: Output<String>? = null

    private var s3BackupMode: Output<String>? = null

    private var s3Configuration:
        Output<FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs>? = null

    private var secretsManagerConfiguration:
        Output<FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgs>? = null

    private var url: Output<String>? = null

    /**
     * @param value The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
     */
    @JvmName("aokndaqlfhfrdmei")
    public suspend fun accessKey(`value`: Output<String>) {
        this.accessKey = value
    }

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).
     */
    @JvmName("tistfuyhpdbmsori")
    public suspend fun bufferingInterval(`value`: Output<Int>) {
        this.bufferingInterval = value
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.
     */
    @JvmName("nwwndseifrhxydhy")
    public suspend fun bufferingSize(`value`: Output<Int>) {
        this.bufferingSize = value
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("qiwgtyatwwqtelei")
    public suspend fun cloudwatchLoggingOptions(`value`: Output<FirehoseDeliveryStreamHttpEndpointConfigurationCloudwatchLoggingOptionsArgs>) {
        this.cloudwatchLoggingOptions = value
    }

    /**
     * @param value The HTTP endpoint name.
     */
    @JvmName("iceetnmavgiwjuag")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The data processing configuration.  See `processing_configuration` block below for details.
     */
    @JvmName("iyyxkduafdqgkkox")
    public suspend fun processingConfiguration(`value`: Output<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs>) {
        this.processingConfiguration = value
    }

    /**
     * @param value The request configuration.  See `request_configuration` block below for details.
     */
    @JvmName("kpniovbmackbparn")
    public suspend fun requestConfiguration(`value`: Output<FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs>) {
        this.requestConfiguration = value
    }

    /**
     * @param value Total amount of seconds Firehose spends on retries. This duration starts after the initial attempt fails, It does not include the time periods during which Firehose waits for acknowledgment from the specified destination after each attempt. Valid values between `0` and `7200`. Default is `300`.
     */
    @JvmName("pdraweqmtmxvukdi")
    public suspend fun retryDuration(`value`: Output<Int>) {
        this.retryDuration = value
    }

    /**
     * @param value Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs. The pattern needs to be `arn:.*`.
     */
    @JvmName("ffedsmtfbhmkhnoq")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDataOnly` and `AllData`.  Default value is `FailedDataOnly`.
     */
    @JvmName("ebihxjiuoicnujif")
    public suspend fun s3BackupMode(`value`: Output<String>) {
        this.s3BackupMode = value
    }

    /**
     * @param value The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("ljrbsxjprexcpaap")
    public suspend fun s3Configuration(`value`: Output<FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs>) {
        this.s3Configuration = value
    }

    /**
     * @param value The Secret Manager Configuration. See `secrets_manager_configuration` block below for details.
     */
    @JvmName("glncqgcfsqwlqsvg")
    public suspend fun secretsManagerConfiguration(`value`: Output<FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgs>) {
        this.secretsManagerConfiguration = value
    }

    /**
     * @param value The HTTP endpoint URL to which Kinesis Firehose sends your data.
     */
    @JvmName("ntaukhbmmrnpuaow")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
     */
    @JvmName("rcxeesdaggvhwugf")
    public suspend fun accessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKey = mapped
    }

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).
     */
    @JvmName("vpxxqccgnieyxidf")
    public suspend fun bufferingInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingInterval = mapped
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.
     */
    @JvmName("lwhceyusrkmleedt")
    public suspend fun bufferingSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingSize = mapped
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("ekxxejwuyliqotjp")
    public suspend fun cloudwatchLoggingOptions(`value`: FirehoseDeliveryStreamHttpEndpointConfigurationCloudwatchLoggingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param argument The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("dvuanooxaplflpff")
    public suspend fun cloudwatchLoggingOptions(argument: suspend FirehoseDeliveryStreamHttpEndpointConfigurationCloudwatchLoggingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamHttpEndpointConfigurationCloudwatchLoggingOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param value The HTTP endpoint name.
     */
    @JvmName("tqshipgfhhallufa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The data processing configuration.  See `processing_configuration` block below for details.
     */
    @JvmName("evfcrkpvheydrbpa")
    public suspend fun processingConfiguration(`value`: FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processingConfiguration = mapped
    }

    /**
     * @param argument The data processing configuration.  See `processing_configuration` block below for details.
     */
    @JvmName("pvlcrsbxtedmeeks")
    public suspend fun processingConfiguration(argument: suspend FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.processingConfiguration = mapped
    }

    /**
     * @param value The request configuration.  See `request_configuration` block below for details.
     */
    @JvmName("txhmadcxvipvxqyf")
    public suspend fun requestConfiguration(`value`: FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestConfiguration = mapped
    }

    /**
     * @param argument The request configuration.  See `request_configuration` block below for details.
     */
    @JvmName("iialvrtnfatmiitg")
    public suspend fun requestConfiguration(argument: suspend FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.requestConfiguration = mapped
    }

    /**
     * @param value Total amount of seconds Firehose spends on retries. This duration starts after the initial attempt fails, It does not include the time periods during which Firehose waits for acknowledgment from the specified destination after each attempt. Valid values between `0` and `7200`. Default is `300`.
     */
    @JvmName("glolwwfljkxuinjx")
    public suspend fun retryDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryDuration = mapped
    }

    /**
     * @param value Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs. The pattern needs to be `arn:.*`.
     */
    @JvmName("ewqliyfctdvwpwkm")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDataOnly` and `AllData`.  Default value is `FailedDataOnly`.
     */
    @JvmName("cbirygsovwuooipp")
    public suspend fun s3BackupMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BackupMode = mapped
    }

    /**
     * @param value The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("voyijamxjqtbuacr")
    public suspend fun s3Configuration(`value`: FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Configuration = mapped
    }

    /**
     * @param argument The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("dwrqjqmoyujhfqbb")
    public suspend fun s3Configuration(argument: suspend FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3Configuration = mapped
    }

    /**
     * @param value The Secret Manager Configuration. See `secrets_manager_configuration` block below for details.
     */
    @JvmName("ukmoqaxshwiuykeo")
    public suspend fun secretsManagerConfiguration(`value`: FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsManagerConfiguration = mapped
    }

    /**
     * @param argument The Secret Manager Configuration. See `secrets_manager_configuration` block below for details.
     */
    @JvmName("dfmyhkblnorafskw")
    public suspend fun secretsManagerConfiguration(argument: suspend FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.secretsManagerConfiguration = mapped
    }

    /**
     * @param value The HTTP endpoint URL to which Kinesis Firehose sends your data.
     */
    @JvmName("icratqjlbfuernfu")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): FirehoseDeliveryStreamHttpEndpointConfigurationArgs =
        FirehoseDeliveryStreamHttpEndpointConfigurationArgs(
            accessKey = accessKey,
            bufferingInterval = bufferingInterval,
            bufferingSize = bufferingSize,
            cloudwatchLoggingOptions = cloudwatchLoggingOptions,
            name = name,
            processingConfiguration = processingConfiguration,
            requestConfiguration = requestConfiguration,
            retryDuration = retryDuration,
            roleArn = roleArn,
            s3BackupMode = s3BackupMode,
            s3Configuration = s3Configuration ?: throw PulumiNullFieldException("s3Configuration"),
            secretsManagerConfiguration = secretsManagerConfiguration,
            url = url ?: throw PulumiNullFieldException("url"),
        )
}
