@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the HTTP endpoint common attribute.
 * @property value The value of the HTTP endpoint common attribute.
 */
public data class
FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs].
 */
@PulumiTagMarker
public class
FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgsBuilder
internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the HTTP endpoint common attribute.
     */
    @JvmName("aaexsgqhkjfdyqot")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the HTTP endpoint common attribute.
     */
    @JvmName("lnfhxalsrrypwcda")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the HTTP endpoint common attribute.
     */
    @JvmName("kqraomdrbvyxqgsd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the HTTP endpoint common attribute.
     */
    @JvmName("jrqghkqraicennrd")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs =
        FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
