@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables the Secrets Manager configuration.
 * @property roleArn The ARN of the role the stream assumes.
 * @property secretArn The ARN of the Secrets Manager secret. This value is required if `enabled` is true.
 */
public data class FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val roleArn: Output<String>? = null,
    public val secretArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .secretArn(secretArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var roleArn: Output<String>? = null

    private var secretArn: Output<String>? = null

    /**
     * @param value Enables or disables the Secrets Manager configuration.
     */
    @JvmName("gahofwberodkgbnm")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The ARN of the role the stream assumes.
     */
    @JvmName("ysqsjqdyjvkiwrmw")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The ARN of the Secrets Manager secret. This value is required if `enabled` is true.
     */
    @JvmName("ypihjtxdpsenrvlr")
    public suspend fun secretArn(`value`: Output<String>) {
        this.secretArn = value
    }

    /**
     * @param value Enables or disables the Secrets Manager configuration.
     */
    @JvmName("quyxnixfnnrxcnwt")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The ARN of the role the stream assumes.
     */
    @JvmName("qnjbqtkgqpqmxcsr")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The ARN of the Secrets Manager secret. This value is required if `enabled` is true.
     */
    @JvmName("lukctygawqhxtwyg")
    public suspend fun secretArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretArn = mapped
    }

    internal fun build(): FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgs =
        FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfigurationArgs(
            enabled = enabled,
            roleArn = roleArn,
            secretArn = secretArn,
        )
}
