@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamMskSourceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationConfiguration The authentication configuration of the Amazon MSK cluster. See `authentication_configuration` block below for details.
 * @property mskClusterArn The ARN of the Amazon MSK cluster.
 * @property topicName The topic name within the Amazon MSK cluster.
 */
public data class FirehoseDeliveryStreamMskSourceConfigurationArgs(
    public val authenticationConfiguration: Output<FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgs>,
    public val mskClusterArn: Output<String>,
    public val topicName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamMskSourceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamMskSourceConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamMskSourceConfigurationArgs.builder()
            .authenticationConfiguration(
                authenticationConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .mskClusterArn(mskClusterArn.applyValue({ args0 -> args0 }))
            .topicName(topicName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamMskSourceConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamMskSourceConfigurationArgsBuilder internal constructor() {
    private var authenticationConfiguration:
        Output<FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgs>? = null

    private var mskClusterArn: Output<String>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value The authentication configuration of the Amazon MSK cluster. See `authentication_configuration` block below for details.
     */
    @JvmName("ycrchnblhewhvjhq")
    public suspend fun authenticationConfiguration(`value`: Output<FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgs>) {
        this.authenticationConfiguration = value
    }

    /**
     * @param value The ARN of the Amazon MSK cluster.
     */
    @JvmName("crxvtwxsrwnhdamo")
    public suspend fun mskClusterArn(`value`: Output<String>) {
        this.mskClusterArn = value
    }

    /**
     * @param value The topic name within the Amazon MSK cluster.
     */
    @JvmName("bksjlffmfvudnqhn")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value The authentication configuration of the Amazon MSK cluster. See `authentication_configuration` block below for details.
     */
    @JvmName("nufqlgvkbdmlfwla")
    public suspend fun authenticationConfiguration(`value`: FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationConfiguration = mapped
    }

    /**
     * @param argument The authentication configuration of the Amazon MSK cluster. See `authentication_configuration` block below for details.
     */
    @JvmName("tqmcrwqqfcecobrl")
    public suspend fun authenticationConfiguration(argument: suspend FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.authenticationConfiguration = mapped
    }

    /**
     * @param value The ARN of the Amazon MSK cluster.
     */
    @JvmName("ujxijkjlyjhnxmhv")
    public suspend fun mskClusterArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mskClusterArn = mapped
    }

    /**
     * @param value The topic name within the Amazon MSK cluster.
     */
    @JvmName("gngfftnertsmsovy")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): FirehoseDeliveryStreamMskSourceConfigurationArgs =
        FirehoseDeliveryStreamMskSourceConfigurationArgs(
            authenticationConfiguration = authenticationConfiguration ?: throw
                PulumiNullFieldException("authenticationConfiguration"),
            mskClusterArn = mskClusterArn ?: throw PulumiNullFieldException("mskClusterArn"),
            topicName = topicName ?: throw PulumiNullFieldException("topicName"),
        )
}
