@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bufferingInterval Buffer incoming data for the specified period of time, in seconds between 0 to 900, before delivering it to the destination.  The default value is 300s.
 * @property bufferingSize Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
 * @property clusterEndpoint The endpoint to use when communicating with the cluster. Conflicts with `domain_arn`.
 * @property documentIdOptions The method for setting up document ID. See [`document_id_options` block] below for details.
 * @property domainArn The ARN of the Amazon ES domain.  The pattern needs to be `arn:.*`.  Conflicts with `cluster_endpoint`.
 * @property indexName The OpenSearch index name.
 * @property indexRotationPeriod The OpenSearch index rotation period.  Index rotation appends a timestamp to the IndexName to facilitate expiration of old data.  Valid values are `NoRotation`, `OneHour`, `OneDay`, `OneWeek`, and `OneMonth`.  The default value is `OneDay`.
 * @property processingConfiguration The data processing configuration. See `processing_configuration` block below for details.
 * @property retryDuration After an initial failure to deliver to Amazon OpenSearch, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
 * @property roleArn The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for indexing documents.  The IAM role must have permission for `DescribeDomain`, `DescribeDomains`, and `DescribeDomainConfig`.  The pattern needs to be `arn:.*`.
 * @property s3BackupMode Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
 * @property s3Configuration The S3 Configuration. See `s3_configuration` block below for details.
 * @property typeName The Elasticsearch type name with maximum length of 100 characters. Types are deprecated in OpenSearch_1.1. TypeName must be empty.
 * @property vpcConfig The VPC configuration for the delivery stream to connect to OpenSearch associated with the VPC. See `vpc_config` block below for details.
 */
public data class FirehoseDeliveryStreamOpensearchConfigurationArgs(
    public val bufferingInterval: Output<Int>? = null,
    public val bufferingSize: Output<Int>? = null,
    public val cloudwatchLoggingOptions: Output<FirehoseDeliveryStreamOpensearchConfigurationCloudwatchLoggingOptionsArgs>? = null,
    public val clusterEndpoint: Output<String>? = null,
    public val documentIdOptions: Output<FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgs>? = null,
    public val domainArn: Output<String>? = null,
    public val indexName: Output<String>,
    public val indexRotationPeriod: Output<String>? = null,
    public val processingConfiguration: Output<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs>? = null,
    public val retryDuration: Output<Int>? = null,
    public val roleArn: Output<String>,
    public val s3BackupMode: Output<String>? = null,
    public val s3Configuration: Output<FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs>,
    public val typeName: Output<String>? = null,
    public val vpcConfig: Output<FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs.builder()
            .bufferingInterval(bufferingInterval?.applyValue({ args0 -> args0 }))
            .bufferingSize(bufferingSize?.applyValue({ args0 -> args0 }))
            .cloudwatchLoggingOptions(
                cloudwatchLoggingOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clusterEndpoint(clusterEndpoint?.applyValue({ args0 -> args0 }))
            .documentIdOptions(documentIdOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .domainArn(domainArn?.applyValue({ args0 -> args0 }))
            .indexName(indexName.applyValue({ args0 -> args0 }))
            .indexRotationPeriod(indexRotationPeriod?.applyValue({ args0 -> args0 }))
            .processingConfiguration(
                processingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .retryDuration(retryDuration?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .s3BackupMode(s3BackupMode?.applyValue({ args0 -> args0 }))
            .s3Configuration(s3Configuration.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .typeName(typeName?.applyValue({ args0 -> args0 }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamOpensearchConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamOpensearchConfigurationArgsBuilder internal constructor() {
    private var bufferingInterval: Output<Int>? = null

    private var bufferingSize: Output<Int>? = null

    private var cloudwatchLoggingOptions:
        Output<FirehoseDeliveryStreamOpensearchConfigurationCloudwatchLoggingOptionsArgs>? = null

    private var clusterEndpoint: Output<String>? = null

    private var documentIdOptions:
        Output<FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgs>? = null

    private var domainArn: Output<String>? = null

    private var indexName: Output<String>? = null

    private var indexRotationPeriod: Output<String>? = null

    private var processingConfiguration:
        Output<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs>? = null

    private var retryDuration: Output<Int>? = null

    private var roleArn: Output<String>? = null

    private var s3BackupMode: Output<String>? = null

    private var s3Configuration:
        Output<FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs>? = null

    private var typeName: Output<String>? = null

    private var vpcConfig: Output<FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs>? = null

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds between 0 to 900, before delivering it to the destination.  The default value is 300s.
     */
    @JvmName("gogqacnifglgdsky")
    public suspend fun bufferingInterval(`value`: Output<Int>) {
        this.bufferingInterval = value
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
     */
    @JvmName("mqgkbrkrmgwbmhws")
    public suspend fun bufferingSize(`value`: Output<Int>) {
        this.bufferingSize = value
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("vddjxjdlfaxtthaf")
    public suspend fun cloudwatchLoggingOptions(`value`: Output<FirehoseDeliveryStreamOpensearchConfigurationCloudwatchLoggingOptionsArgs>) {
        this.cloudwatchLoggingOptions = value
    }

    /**
     * @param value The endpoint to use when communicating with the cluster. Conflicts with `domain_arn`.
     */
    @JvmName("tohimutrkqygxvph")
    public suspend fun clusterEndpoint(`value`: Output<String>) {
        this.clusterEndpoint = value
    }

    /**
     * @param value The method for setting up document ID. See [`document_id_options` block] below for details.
     */
    @JvmName("unvwybrhxfebtsmn")
    public suspend fun documentIdOptions(`value`: Output<FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgs>) {
        this.documentIdOptions = value
    }

    /**
     * @param value The ARN of the Amazon ES domain.  The pattern needs to be `arn:.*`.  Conflicts with `cluster_endpoint`.
     */
    @JvmName("qxrysxshngjguxdt")
    public suspend fun domainArn(`value`: Output<String>) {
        this.domainArn = value
    }

    /**
     * @param value The OpenSearch index name.
     */
    @JvmName("jhuhdaeldwxbpkob")
    public suspend fun indexName(`value`: Output<String>) {
        this.indexName = value
    }

    /**
     * @param value The OpenSearch index rotation period.  Index rotation appends a timestamp to the IndexName to facilitate expiration of old data.  Valid values are `NoRotation`, `OneHour`, `OneDay`, `OneWeek`, and `OneMonth`.  The default value is `OneDay`.
     */
    @JvmName("imjwakcwkyjwlwwb")
    public suspend fun indexRotationPeriod(`value`: Output<String>) {
        this.indexRotationPeriod = value
    }

    /**
     * @param value The data processing configuration. See `processing_configuration` block below for details.
     */
    @JvmName("vcfblokfxxucnlcy")
    public suspend fun processingConfiguration(`value`: Output<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs>) {
        this.processingConfiguration = value
    }

    /**
     * @param value After an initial failure to deliver to Amazon OpenSearch, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
     */
    @JvmName("rbepqvktqvuxldjv")
    public suspend fun retryDuration(`value`: Output<Int>) {
        this.retryDuration = value
    }

    /**
     * @param value The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for indexing documents.  The IAM role must have permission for `DescribeDomain`, `DescribeDomains`, and `DescribeDomainConfig`.  The pattern needs to be `arn:.*`.
     */
    @JvmName("moqxykhtfplyivxu")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
     */
    @JvmName("blljjmncheggmcgp")
    public suspend fun s3BackupMode(`value`: Output<String>) {
        this.s3BackupMode = value
    }

    /**
     * @param value The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("rrsqutmhaecnidsp")
    public suspend fun s3Configuration(`value`: Output<FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs>) {
        this.s3Configuration = value
    }

    /**
     * @param value The Elasticsearch type name with maximum length of 100 characters. Types are deprecated in OpenSearch_1.1. TypeName must be empty.
     */
    @JvmName("dqrwleqyvyahmoih")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value The VPC configuration for the delivery stream to connect to OpenSearch associated with the VPC. See `vpc_config` block below for details.
     */
    @JvmName("vimxdywixagaqewt")
    public suspend fun vpcConfig(`value`: Output<FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds between 0 to 900, before delivering it to the destination.  The default value is 300s.
     */
    @JvmName("elqvnlllqgjofhqe")
    public suspend fun bufferingInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingInterval = mapped
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
     */
    @JvmName("jfnntlcupmrrgfow")
    public suspend fun bufferingSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingSize = mapped
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("dpofaxoeflwxavlq")
    public suspend fun cloudwatchLoggingOptions(`value`: FirehoseDeliveryStreamOpensearchConfigurationCloudwatchLoggingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param argument The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("xbbkfcpuvipulnxo")
    public suspend fun cloudwatchLoggingOptions(argument: suspend FirehoseDeliveryStreamOpensearchConfigurationCloudwatchLoggingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchConfigurationCloudwatchLoggingOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param value The endpoint to use when communicating with the cluster. Conflicts with `domain_arn`.
     */
    @JvmName("ogmrrvebtmwpxwbp")
    public suspend fun clusterEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterEndpoint = mapped
    }

    /**
     * @param value The method for setting up document ID. See [`document_id_options` block] below for details.
     */
    @JvmName("pgtlcbwmybanpiqi")
    public suspend fun documentIdOptions(`value`: FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentIdOptions = mapped
    }

    /**
     * @param argument The method for setting up document ID. See [`document_id_options` block] below for details.
     */
    @JvmName("qaskgltpewiiuwvg")
    public suspend fun documentIdOptions(argument: suspend FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.documentIdOptions = mapped
    }

    /**
     * @param value The ARN of the Amazon ES domain.  The pattern needs to be `arn:.*`.  Conflicts with `cluster_endpoint`.
     */
    @JvmName("dkbhyyxgerrmyqqs")
    public suspend fun domainArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainArn = mapped
    }

    /**
     * @param value The OpenSearch index name.
     */
    @JvmName("wyxbfixdjjauhdgr")
    public suspend fun indexName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexName = mapped
    }

    /**
     * @param value The OpenSearch index rotation period.  Index rotation appends a timestamp to the IndexName to facilitate expiration of old data.  Valid values are `NoRotation`, `OneHour`, `OneDay`, `OneWeek`, and `OneMonth`.  The default value is `OneDay`.
     */
    @JvmName("tcufmhewoujleqtl")
    public suspend fun indexRotationPeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexRotationPeriod = mapped
    }

    /**
     * @param value The data processing configuration. See `processing_configuration` block below for details.
     */
    @JvmName("iwklwbmxfxncfugh")
    public suspend fun processingConfiguration(`value`: FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processingConfiguration = mapped
    }

    /**
     * @param argument The data processing configuration. See `processing_configuration` block below for details.
     */
    @JvmName("nkhueyihuejsbdwg")
    public suspend fun processingConfiguration(argument: suspend FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.processingConfiguration = mapped
    }

    /**
     * @param value After an initial failure to deliver to Amazon OpenSearch, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
     */
    @JvmName("uwujwsjjfntlecai")
    public suspend fun retryDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryDuration = mapped
    }

    /**
     * @param value The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for indexing documents.  The IAM role must have permission for `DescribeDomain`, `DescribeDomains`, and `DescribeDomainConfig`.  The pattern needs to be `arn:.*`.
     */
    @JvmName("yqwndgddjemcrpfv")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
     */
    @JvmName("dcvbuuqytnkrskwi")
    public suspend fun s3BackupMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BackupMode = mapped
    }

    /**
     * @param value The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("iommdohvnenbljij")
    public suspend fun s3Configuration(`value`: FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Configuration = mapped
    }

    /**
     * @param argument The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("pjbwehguslsalbdp")
    public suspend fun s3Configuration(argument: suspend FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3Configuration = mapped
    }

    /**
     * @param value The Elasticsearch type name with maximum length of 100 characters. Types are deprecated in OpenSearch_1.1. TypeName must be empty.
     */
    @JvmName("nnsbrigbogalrcej")
    public suspend fun typeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    /**
     * @param value The VPC configuration for the delivery stream to connect to OpenSearch associated with the VPC. See `vpc_config` block below for details.
     */
    @JvmName("nukbpxmyarjaxbxl")
    public suspend fun vpcConfig(`value`: FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument The VPC configuration for the delivery stream to connect to OpenSearch associated with the VPC. See `vpc_config` block below for details.
     */
    @JvmName("jcicovwhkusvieay")
    public suspend fun vpcConfig(argument: suspend FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): FirehoseDeliveryStreamOpensearchConfigurationArgs =
        FirehoseDeliveryStreamOpensearchConfigurationArgs(
            bufferingInterval = bufferingInterval,
            bufferingSize = bufferingSize,
            cloudwatchLoggingOptions = cloudwatchLoggingOptions,
            clusterEndpoint = clusterEndpoint,
            documentIdOptions = documentIdOptions,
            domainArn = domainArn,
            indexName = indexName ?: throw PulumiNullFieldException("indexName"),
            indexRotationPeriod = indexRotationPeriod,
            processingConfiguration = processingConfiguration,
            retryDuration = retryDuration,
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            s3BackupMode = s3BackupMode,
            s3Configuration = s3Configuration ?: throw PulumiNullFieldException("s3Configuration"),
            typeName = typeName,
            vpcConfig = vpcConfig,
        )
}
