@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultDocumentIdFormat The method for setting up document ID. Valid values: `FIREHOSE_DEFAULT`, `NO_DOCUMENT_ID`.
 */
public data class FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgs(
    public val defaultDocumentIdFormat: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgs.builder()
            .defaultDocumentIdFormat(defaultDocumentIdFormat.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgsBuilder internal constructor() {
    private var defaultDocumentIdFormat: Output<String>? = null

    /**
     * @param value The method for setting up document ID. Valid values: `FIREHOSE_DEFAULT`, `NO_DOCUMENT_ID`.
     */
    @JvmName("qctfjmntqpnqfrgf")
    public suspend fun defaultDocumentIdFormat(`value`: Output<String>) {
        this.defaultDocumentIdFormat = value
    }

    /**
     * @param value The method for setting up document ID. Valid values: `FIREHOSE_DEFAULT`, `NO_DOCUMENT_ID`.
     */
    @JvmName("soidekqgetncvbpf")
    public suspend fun defaultDocumentIdFormat(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultDocumentIdFormat = mapped
    }

    internal fun build(): FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgs =
        FirehoseDeliveryStreamOpensearchConfigurationDocumentIdOptionsArgs(
            defaultDocumentIdFormat = defaultDocumentIdFormat ?: throw
                PulumiNullFieldException("defaultDocumentIdFormat"),
        )
}
