@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables data processing.
 * @property processors Specifies the data processors as multiple blocks. See `processors` block below for details.
 */
public data class FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val processors: Output<List<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .processors(
                processors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var processors:
        Output<List<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs>>? =
        null

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("lciysgdeskompqlh")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("jgiableuaewvawbx")
    public suspend fun processors(`value`: Output<List<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = value
    }

    @JvmName("jwmqnisykyjjxdqb")
    public suspend fun processors(vararg values: Output<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs>) {
        this.processors = Output.all(values.asList())
    }

    /**
     * @param values Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("tbkdwgsajcqovpkf")
    public suspend fun processors(values: List<Output<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = Output.all(values)
    }

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("tcaerhiecxngytvl")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("llwhfwirfhxbtaqc")
    public suspend fun processors(`value`: List<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("gqetaousnpgaymwa")
    public suspend fun processors(argument: List<suspend FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("edaaucxoecgdrcjn")
    public suspend fun processors(vararg argument: suspend FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("tcmtenglkkvmntlf")
    public suspend fun processors(argument: suspend FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param values Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("coohctwkmwqojsfh")
    public suspend fun processors(vararg values: FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    internal fun build(): FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs =
        FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs(
            enabled = enabled,
            processors = processors,
        )
}
