@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property parameters Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
 * @property type The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
 */
public data class FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs(
    public val parameters: Output<List<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgs>>? =
        null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs].
 */
@PulumiTagMarker
public class
FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgsBuilder
internal constructor() {
    private var parameters:
        Output<List<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgs>>? =
        null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
     */
    @JvmName("gtspgiqfswnuaffk")
    public suspend fun parameters(`value`: Output<List<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("cvjqyeweofjnhhms")
    public suspend fun parameters(vararg values: Output<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
     */
    @JvmName("hjhgkahwowiscnby")
    public suspend fun parameters(values: List<Output<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
     */
    @JvmName("oysrxbgafnhwuwjy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
     */
    @JvmName("xqjvoxqsgpaquvde")
    public suspend fun parameters(`value`: List<FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
     */
    @JvmName("wmvucjgqarwrpvkw")
    public suspend fun parameters(argument: List<suspend FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
     */
    @JvmName("nwaepjbgnysycnly")
    public suspend fun parameters(vararg argument: suspend FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
     */
    @JvmName("orvxqxnxrhrnmwjw")
    public suspend fun parameters(argument: suspend FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
     */
    @JvmName("ldiyrvnptjhpuecp")
    public suspend fun parameters(vararg values: FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
     */
    @JvmName("rvhscnvuhcglmgtg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs =
        FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs(
            parameters = parameters,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
