@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bufferingInterval Buffer incoming data for the specified period of time, in seconds between 0 to 900, before delivering it to the destination.  The default value is 300s.
 * @property bufferingSize Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
 * @property collectionEndpoint The endpoint to use when communicating with the collection in the Serverless offering for Amazon OpenSearch Service.
 * @property indexName The Serverless offering for Amazon OpenSearch Service index name.
 * @property processingConfiguration The data processing configuration.  See `processing_configuration` block below for details.
 * @property retryDuration After an initial failure to deliver to the Serverless offering for Amazon OpenSearch Service, the total amount of time, in seconds between 0 to 7200, during which Kinesis Data Firehose retries delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
 * @property roleArn The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Serverless offering for Amazon OpenSearch Service Configuration API and for indexing documents.  The pattern needs to be `arn:.*`.
 * @property s3BackupMode Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
 * @property s3Configuration The S3 Configuration. See `s3_configuration` block below for details.
 * @property vpcConfig The VPC configuration for the delivery stream to connect to OpenSearch Serverless associated with the VPC. See `vpc_config` block below for details.
 */
public data class FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs(
    public val bufferingInterval: Output<Int>? = null,
    public val bufferingSize: Output<Int>? = null,
    public val cloudwatchLoggingOptions: Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgs>? =
        null,
    public val collectionEndpoint: Output<String>,
    public val indexName: Output<String>,
    public val processingConfiguration: Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs>? =
        null,
    public val retryDuration: Output<Int>? = null,
    public val roleArn: Output<String>,
    public val s3BackupMode: Output<String>? = null,
    public val s3Configuration: Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationS3ConfigurationArgs>,
    public val vpcConfig: Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationVpcConfigArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs.builder()
            .bufferingInterval(bufferingInterval?.applyValue({ args0 -> args0 }))
            .bufferingSize(bufferingSize?.applyValue({ args0 -> args0 }))
            .cloudwatchLoggingOptions(
                cloudwatchLoggingOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .collectionEndpoint(collectionEndpoint.applyValue({ args0 -> args0 }))
            .indexName(indexName.applyValue({ args0 -> args0 }))
            .processingConfiguration(
                processingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .retryDuration(retryDuration?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .s3BackupMode(s3BackupMode?.applyValue({ args0 -> args0 }))
            .s3Configuration(s3Configuration.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamOpensearchserverlessConfigurationArgsBuilder internal constructor() {
    private var bufferingInterval: Output<Int>? = null

    private var bufferingSize: Output<Int>? = null

    private var cloudwatchLoggingOptions:
        Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgs>? =
        null

    private var collectionEndpoint: Output<String>? = null

    private var indexName: Output<String>? = null

    private var processingConfiguration:
        Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs>? =
        null

    private var retryDuration: Output<Int>? = null

    private var roleArn: Output<String>? = null

    private var s3BackupMode: Output<String>? = null

    private var s3Configuration:
        Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationS3ConfigurationArgs>? = null

    private var vpcConfig:
        Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationVpcConfigArgs>? = null

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds between 0 to 900, before delivering it to the destination.  The default value is 300s.
     */
    @JvmName("xpniufddhnoeyctl")
    public suspend fun bufferingInterval(`value`: Output<Int>) {
        this.bufferingInterval = value
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
     */
    @JvmName("bepwjskdoasveslf")
    public suspend fun bufferingSize(`value`: Output<Int>) {
        this.bufferingSize = value
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("ebdsdciqidwlhedy")
    public suspend fun cloudwatchLoggingOptions(`value`: Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgs>) {
        this.cloudwatchLoggingOptions = value
    }

    /**
     * @param value The endpoint to use when communicating with the collection in the Serverless offering for Amazon OpenSearch Service.
     */
    @JvmName("ffprcvcuucbwutcn")
    public suspend fun collectionEndpoint(`value`: Output<String>) {
        this.collectionEndpoint = value
    }

    /**
     * @param value The Serverless offering for Amazon OpenSearch Service index name.
     */
    @JvmName("subfyomtfcsltens")
    public suspend fun indexName(`value`: Output<String>) {
        this.indexName = value
    }

    /**
     * @param value The data processing configuration.  See `processing_configuration` block below for details.
     */
    @JvmName("mwvrlsrpikowskwd")
    public suspend fun processingConfiguration(`value`: Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs>) {
        this.processingConfiguration = value
    }

    /**
     * @param value After an initial failure to deliver to the Serverless offering for Amazon OpenSearch Service, the total amount of time, in seconds between 0 to 7200, during which Kinesis Data Firehose retries delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
     */
    @JvmName("udewaamnhhqkydrw")
    public suspend fun retryDuration(`value`: Output<Int>) {
        this.retryDuration = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Serverless offering for Amazon OpenSearch Service Configuration API and for indexing documents.  The pattern needs to be `arn:.*`.
     */
    @JvmName("rahstmpikwbhymrd")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
     */
    @JvmName("smfbkhnbjkmxkgoq")
    public suspend fun s3BackupMode(`value`: Output<String>) {
        this.s3BackupMode = value
    }

    /**
     * @param value The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("wigikumknanbhddl")
    public suspend fun s3Configuration(`value`: Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationS3ConfigurationArgs>) {
        this.s3Configuration = value
    }

    /**
     * @param value The VPC configuration for the delivery stream to connect to OpenSearch Serverless associated with the VPC. See `vpc_config` block below for details.
     */
    @JvmName("ovyioehbfocjorbs")
    public suspend fun vpcConfig(`value`: Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds between 0 to 900, before delivering it to the destination.  The default value is 300s.
     */
    @JvmName("kcltblahldrbyagq")
    public suspend fun bufferingInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingInterval = mapped
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
     */
    @JvmName("lerkixllqwjdlclx")
    public suspend fun bufferingSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingSize = mapped
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("ptulqdgydludeqld")
    public suspend fun cloudwatchLoggingOptions(`value`: FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param argument The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("iebfglufrfiakhjv")
    public suspend fun cloudwatchLoggingOptions(argument: suspend FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param value The endpoint to use when communicating with the collection in the Serverless offering for Amazon OpenSearch Service.
     */
    @JvmName("bjcjdkdjngpevfmd")
    public suspend fun collectionEndpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.collectionEndpoint = mapped
    }

    /**
     * @param value The Serverless offering for Amazon OpenSearch Service index name.
     */
    @JvmName("qjggryoalsivfcdd")
    public suspend fun indexName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexName = mapped
    }

    /**
     * @param value The data processing configuration.  See `processing_configuration` block below for details.
     */
    @JvmName("fsaniktoidqapeem")
    public suspend fun processingConfiguration(`value`: FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processingConfiguration = mapped
    }

    /**
     * @param argument The data processing configuration.  See `processing_configuration` block below for details.
     */
    @JvmName("cggeeclfhyjcvntc")
    public suspend fun processingConfiguration(argument: suspend FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.processingConfiguration = mapped
    }

    /**
     * @param value After an initial failure to deliver to the Serverless offering for Amazon OpenSearch Service, the total amount of time, in seconds between 0 to 7200, during which Kinesis Data Firehose retries delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
     */
    @JvmName("yircneufqcsbuirg")
    public suspend fun retryDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryDuration = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Serverless offering for Amazon OpenSearch Service Configuration API and for indexing documents.  The pattern needs to be `arn:.*`.
     */
    @JvmName("gkpgfnxwgvoxnhlt")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
     */
    @JvmName("yaokdguqlbkavlqg")
    public suspend fun s3BackupMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BackupMode = mapped
    }

    /**
     * @param value The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("qpdfgnyvmlbrfebm")
    public suspend fun s3Configuration(`value`: FirehoseDeliveryStreamOpensearchserverlessConfigurationS3ConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Configuration = mapped
    }

    /**
     * @param argument The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("kuhuffwtjgmnhikh")
    public suspend fun s3Configuration(argument: suspend FirehoseDeliveryStreamOpensearchserverlessConfigurationS3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchserverlessConfigurationS3ConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3Configuration = mapped
    }

    /**
     * @param value The VPC configuration for the delivery stream to connect to OpenSearch Serverless associated with the VPC. See `vpc_config` block below for details.
     */
    @JvmName("ejjlprtdfuysrxou")
    public suspend fun vpcConfig(`value`: FirehoseDeliveryStreamOpensearchserverlessConfigurationVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument The VPC configuration for the delivery stream to connect to OpenSearch Serverless associated with the VPC. See `vpc_config` block below for details.
     */
    @JvmName("oggcmmutoepjidwe")
    public suspend fun vpcConfig(argument: suspend FirehoseDeliveryStreamOpensearchserverlessConfigurationVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchserverlessConfigurationVpcConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs =
        FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs(
            bufferingInterval = bufferingInterval,
            bufferingSize = bufferingSize,
            cloudwatchLoggingOptions = cloudwatchLoggingOptions,
            collectionEndpoint = collectionEndpoint ?: throw PulumiNullFieldException("collectionEndpoint"),
            indexName = indexName ?: throw PulumiNullFieldException("indexName"),
            processingConfiguration = processingConfiguration,
            retryDuration = retryDuration,
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            s3BackupMode = s3BackupMode,
            s3Configuration = s3Configuration ?: throw PulumiNullFieldException("s3Configuration"),
            vpcConfig = vpcConfig,
        )
}
