@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables the logging. Defaults to `false`.
 * @property logGroupName The CloudWatch group name for logging. This value is required if `enabled` is true.
 * @property logStreamName The CloudWatch log stream name for logging. This value is required if `enabled` is true.
 */
public data class
FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgs(
    public val enabled: Output<Boolean>? = null,
    public val logGroupName: Output<String>? = null,
    public val logStreamName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .logGroupName(logGroupName?.applyValue({ args0 -> args0 }))
            .logStreamName(logStreamName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgs].
 */
@PulumiTagMarker
public class
FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var logGroupName: Output<String>? = null

    private var logStreamName: Output<String>? = null

    /**
     * @param value Enables or disables the logging. Defaults to `false`.
     */
    @JvmName("pasewfihhfkdcplv")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The CloudWatch group name for logging. This value is required if `enabled` is true.
     */
    @JvmName("kvmsykqmdnvjfgdl")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value The CloudWatch log stream name for logging. This value is required if `enabled` is true.
     */
    @JvmName("ovheiigjjpcobbho")
    public suspend fun logStreamName(`value`: Output<String>) {
        this.logStreamName = value
    }

    /**
     * @param value Enables or disables the logging. Defaults to `false`.
     */
    @JvmName("gaddukitrojeynrk")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The CloudWatch group name for logging. This value is required if `enabled` is true.
     */
    @JvmName("oivtjkrtrvxbdcxe")
    public suspend fun logGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value The CloudWatch log stream name for logging. This value is required if `enabled` is true.
     */
    @JvmName("qvsljfryxwfydiia")
    public suspend fun logStreamName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStreamName = mapped
    }

    internal fun build(): FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgs =
        FirehoseDeliveryStreamOpensearchserverlessConfigurationCloudwatchLoggingOptionsArgs(
            enabled = enabled,
            logGroupName = logGroupName,
            logStreamName = logStreamName,
        )
}
