@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables data processing.
 * @property processors Specifies the data processors as multiple blocks. See `processors` block below for details.
 */
public data class
FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val processors: Output<List<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .processors(
                processors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs].
 */
@PulumiTagMarker
public class
FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var processors:
        Output<List<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs>>? =
        null

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("rpevrywolkluaeco")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("dmvrgmjbykqpivsu")
    public suspend fun processors(`value`: Output<List<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = value
    }

    @JvmName("bdfafggufxayewtm")
    public suspend fun processors(vararg values: Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs>) {
        this.processors = Output.all(values.asList())
    }

    /**
     * @param values Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("kjtfowhqylefytbl")
    public suspend fun processors(values: List<Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = Output.all(values)
    }

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("pskcelwsfpmhfnyn")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("vvthkjludpcxcdwb")
    public suspend fun processors(`value`: List<FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("ybavmolhnnryhpsi")
    public suspend fun processors(argument: List<suspend FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("rvdvcvxpmgvjkive")
    public suspend fun processors(vararg argument: suspend FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("fkdtxgydfqhxwmyd")
    public suspend fun processors(argument: suspend FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param values Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("ubimoydholfvbfac")
    public suspend fun processors(vararg values: FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    internal fun build(): FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs =
        FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs(
            enabled = enabled,
            processors = processors,
        )
}
