@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables data processing.
 * @property processors Specifies the data processors as multiple blocks. See `processors` block below for details.
 */
public data class FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val processors: Output<List<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .processors(
                processors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var processors:
        Output<List<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs>>? =
        null

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("bdvbmyvdghgfqkid")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("mwrrjpgoukhhumcy")
    public suspend fun processors(`value`: Output<List<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = value
    }

    @JvmName("uamoeqeihcpeeebf")
    public suspend fun processors(vararg values: Output<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs>) {
        this.processors = Output.all(values.asList())
    }

    /**
     * @param values Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("eupespdbwdaakvjp")
    public suspend fun processors(values: List<Output<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = Output.all(values)
    }

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("lnhuedcaynvfusqo")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("dkqmknxhvnsmeqwh")
    public suspend fun processors(`value`: List<FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("pafbilfpwrlewbml")
    public suspend fun processors(argument: List<suspend FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("lpikbowytgedbrhy")
    public suspend fun processors(vararg argument: suspend FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("rdbohyfgbdbfgagk")
    public suspend fun processors(argument: suspend FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param values Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("wcdrhxwkjvjvtwbs")
    public suspend fun processors(vararg values: FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    internal fun build(): FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs =
        FirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationArgs(
            enabled = enabled,
            processors = processors,
        )
}
