@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables data processing.
 * @property processors Specifies the data processors as multiple blocks. See `processors` block below for details.
 */
public data class FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val processors: Output<List<FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .processors(
                processors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var processors:
        Output<List<FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs>>? =
        null

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("otvtxxniivtdqpjh")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("coylctgadfeydsoa")
    public suspend fun processors(`value`: Output<List<FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = value
    }

    @JvmName("pxvykvxxrdjnqtfi")
    public suspend fun processors(vararg values: Output<FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs>) {
        this.processors = Output.all(values.asList())
    }

    /**
     * @param values Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("iuhghpmhnkiapuqv")
    public suspend fun processors(values: List<Output<FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = Output.all(values)
    }

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("wreqqmmwmdpljoyh")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("qatolmgesphoqvvj")
    public suspend fun processors(`value`: List<FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("dnoycfphtipccpif")
    public suspend fun processors(argument: List<suspend FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("rtaioytkgvivliuf")
    public suspend fun processors(vararg argument: suspend FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("dftfncerjocelife")
    public suspend fun processors(argument: suspend FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param values Specifies the data processors as multiple blocks. See `processors` block below for details.
     */
    @JvmName("evabibmyxafodsrb")
    public suspend fun processors(vararg values: FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    internal fun build(): FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationArgs =
        FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationArgs(
            enabled = enabled,
            processors = processors,
        )
}
