@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property parameters Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
 * @property type The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
 */
public data class FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs(
    public val parameters: Output<List<FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorParameterArgs>>? =
        null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgsBuilder
internal constructor() {
    private var parameters:
        Output<List<FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorParameterArgs>>? =
        null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
     */
    @JvmName("piboawdmfwlowoum")
    public suspend fun parameters(`value`: Output<List<FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("nriqxphfgdjunbmj")
    public suspend fun parameters(vararg values: Output<FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
     */
    @JvmName("yhsjjxjhnnrpoiae")
    public suspend fun parameters(values: List<Output<FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
     */
    @JvmName("ainqljvthukbiith")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
     */
    @JvmName("tursvfscyvdhemja")
    public suspend fun parameters(`value`: List<FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
     */
    @JvmName("bhmqyxdgnwhtasmf")
    public suspend fun parameters(argument: List<suspend FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
     */
    @JvmName("aauqtatogajcmpny")
    public suspend fun parameters(vararg argument: suspend FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
     */
    @JvmName("gyivesbbpvgoxjek")
    public suspend fun parameters(argument: suspend FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
     */
    @JvmName("gynwpjpyiqqbmvye")
    public suspend fun parameters(vararg values: FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
     */
    @JvmName("vkivitjthjwejjjq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs =
        FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfigurationProcessorArgs(
            parameters = parameters,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
