@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeRoleConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether the Snowflake role is enabled.
 * @property snowflakeRole The Snowflake role.
 */
public data class FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeRoleConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val snowflakeRole: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeRoleConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeRoleConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeRoleConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .snowflakeRole(snowflakeRole?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeRoleConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeRoleConfigurationArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var snowflakeRole: Output<String>? = null

    /**
     * @param value Whether the Snowflake role is enabled.
     */
    @JvmName("lkfcfnkcoypohnrs")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The Snowflake role.
     */
    @JvmName("xlaeghryomshwjnw")
    public suspend fun snowflakeRole(`value`: Output<String>) {
        this.snowflakeRole = value
    }

    /**
     * @param value Whether the Snowflake role is enabled.
     */
    @JvmName("tfliaarekdjkhrrq")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The Snowflake role.
     */
    @JvmName("mfcgofnojwcwejbt")
    public suspend fun snowflakeRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snowflakeRole = mapped
    }

    internal fun build(): FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeRoleConfigurationArgs =
        FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeRoleConfigurationArgs(
            enabled = enabled,
            snowflakeRole = snowflakeRole,
        )
}
