@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeVpcConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateLinkVpceId The VPCE ID for Firehose to privately connect with Snowflake.
 */
public data class FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeVpcConfigurationArgs(
    public val privateLinkVpceId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeVpcConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeVpcConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeVpcConfigurationArgs.builder()
            .privateLinkVpceId(privateLinkVpceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeVpcConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeVpcConfigurationArgsBuilder
internal constructor() {
    private var privateLinkVpceId: Output<String>? = null

    /**
     * @param value The VPCE ID for Firehose to privately connect with Snowflake.
     */
    @JvmName("kxitkvocslbvcvix")
    public suspend fun privateLinkVpceId(`value`: Output<String>) {
        this.privateLinkVpceId = value
    }

    /**
     * @param value The VPCE ID for Firehose to privately connect with Snowflake.
     */
    @JvmName("mspwjqoujvxypnoq")
    public suspend fun privateLinkVpceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkVpceId = mapped
    }

    internal fun build(): FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeVpcConfigurationArgs =
        FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeVpcConfigurationArgs(
            privateLinkVpceId = privateLinkVpceId ?: throw PulumiNullFieldException("privateLinkVpceId"),
        )
}
