@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bufferingInterval Buffer incoming data for the specified period of time, in seconds between 0 to 60, before delivering it to the destination.  The default value is 60s.
 * @property bufferingSize Buffer incoming data to the specified size, in MBs between 1 to 5, before delivering it to the destination.  The default value is 5MB.
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
 * @property hecAcknowledgmentTimeout The amount of time, in seconds between 180 and 600, that Kinesis Firehose waits to receive an acknowledgment from Splunk after it sends it data.
 * @property hecEndpoint The HTTP Event Collector (HEC) endpoint to which Kinesis Firehose sends your data.
 * @property hecEndpointType The HEC endpoint type. Valid values are `Raw` or `Event`. The default value is `Raw`.
 * @property hecToken The GUID that you obtain from your Splunk cluster when you create a new HEC endpoint. This value is required if `secrets_manager_configuration` is not provided.
 * @property processingConfiguration The data processing configuration.  See `processing_configuration` block below for details.
 * @property retryDuration After an initial failure to deliver to Splunk, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
 * @property s3BackupMode Defines how documents should be delivered to Amazon S3.  Valid values are `FailedEventsOnly` and `AllEvents`.  Default value is `FailedEventsOnly`.
 * `secrets_manager_configuration` - (Optional) The Secrets Manager configuration. See `secrets_manager_configuration` block below for details. This value is required if `hec_token` is not provided.
 * @property s3Configuration The S3 Configuration. See `s3_configuration` block below for details.
 * @property secretsManagerConfiguration
 */
public data class FirehoseDeliveryStreamSplunkConfigurationArgs(
    public val bufferingInterval: Output<Int>? = null,
    public val bufferingSize: Output<Int>? = null,
    public val cloudwatchLoggingOptions: Output<FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgs>? = null,
    public val hecAcknowledgmentTimeout: Output<Int>? = null,
    public val hecEndpoint: Output<String>,
    public val hecEndpointType: Output<String>? = null,
    public val hecToken: Output<String>? = null,
    public val processingConfiguration: Output<FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgs>? = null,
    public val retryDuration: Output<Int>? = null,
    public val s3BackupMode: Output<String>? = null,
    public val s3Configuration: Output<FirehoseDeliveryStreamSplunkConfigurationS3ConfigurationArgs>,
    public val secretsManagerConfiguration: Output<FirehoseDeliveryStreamSplunkConfigurationSecretsManagerConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationArgs = com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationArgs.builder()
        .bufferingInterval(bufferingInterval?.applyValue({ args0 -> args0 }))
        .bufferingSize(bufferingSize?.applyValue({ args0 -> args0 }))
        .cloudwatchLoggingOptions(
            cloudwatchLoggingOptions?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .hecAcknowledgmentTimeout(hecAcknowledgmentTimeout?.applyValue({ args0 -> args0 }))
        .hecEndpoint(hecEndpoint.applyValue({ args0 -> args0 }))
        .hecEndpointType(hecEndpointType?.applyValue({ args0 -> args0 }))
        .hecToken(hecToken?.applyValue({ args0 -> args0 }))
        .processingConfiguration(
            processingConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .retryDuration(retryDuration?.applyValue({ args0 -> args0 }))
        .s3BackupMode(s3BackupMode?.applyValue({ args0 -> args0 }))
        .s3Configuration(s3Configuration.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .secretsManagerConfiguration(
            secretsManagerConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        ).build()
}

/**
 * Builder for [FirehoseDeliveryStreamSplunkConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamSplunkConfigurationArgsBuilder internal constructor() {
    private var bufferingInterval: Output<Int>? = null

    private var bufferingSize: Output<Int>? = null

    private var cloudwatchLoggingOptions:
        Output<FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgs>? = null

    private var hecAcknowledgmentTimeout: Output<Int>? = null

    private var hecEndpoint: Output<String>? = null

    private var hecEndpointType: Output<String>? = null

    private var hecToken: Output<String>? = null

    private var processingConfiguration:
        Output<FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgs>? = null

    private var retryDuration: Output<Int>? = null

    private var s3BackupMode: Output<String>? = null

    private var s3Configuration: Output<FirehoseDeliveryStreamSplunkConfigurationS3ConfigurationArgs>? =
        null

    private var secretsManagerConfiguration:
        Output<FirehoseDeliveryStreamSplunkConfigurationSecretsManagerConfigurationArgs>? = null

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds between 0 to 60, before delivering it to the destination.  The default value is 60s.
     */
    @JvmName("bkllfjmbdcooycst")
    public suspend fun bufferingInterval(`value`: Output<Int>) {
        this.bufferingInterval = value
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs between 1 to 5, before delivering it to the destination.  The default value is 5MB.
     */
    @JvmName("uotjegodxyxbyoiu")
    public suspend fun bufferingSize(`value`: Output<Int>) {
        this.bufferingSize = value
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("adxwgscprdvronrr")
    public suspend fun cloudwatchLoggingOptions(`value`: Output<FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgs>) {
        this.cloudwatchLoggingOptions = value
    }

    /**
     * @param value The amount of time, in seconds between 180 and 600, that Kinesis Firehose waits to receive an acknowledgment from Splunk after it sends it data.
     */
    @JvmName("vvkfdgqaihpryauy")
    public suspend fun hecAcknowledgmentTimeout(`value`: Output<Int>) {
        this.hecAcknowledgmentTimeout = value
    }

    /**
     * @param value The HTTP Event Collector (HEC) endpoint to which Kinesis Firehose sends your data.
     */
    @JvmName("pdeeucyracbbqplr")
    public suspend fun hecEndpoint(`value`: Output<String>) {
        this.hecEndpoint = value
    }

    /**
     * @param value The HEC endpoint type. Valid values are `Raw` or `Event`. The default value is `Raw`.
     */
    @JvmName("knddwdumdaheqlkk")
    public suspend fun hecEndpointType(`value`: Output<String>) {
        this.hecEndpointType = value
    }

    /**
     * @param value The GUID that you obtain from your Splunk cluster when you create a new HEC endpoint. This value is required if `secrets_manager_configuration` is not provided.
     */
    @JvmName("cgnubmuiwlfhksgy")
    public suspend fun hecToken(`value`: Output<String>) {
        this.hecToken = value
    }

    /**
     * @param value The data processing configuration.  See `processing_configuration` block below for details.
     */
    @JvmName("rajfpnnjxhcetbao")
    public suspend fun processingConfiguration(`value`: Output<FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgs>) {
        this.processingConfiguration = value
    }

    /**
     * @param value After an initial failure to deliver to Splunk, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
     */
    @JvmName("ccrbdhnshjybmjas")
    public suspend fun retryDuration(`value`: Output<Int>) {
        this.retryDuration = value
    }

    /**
     * @param value Defines how documents should be delivered to Amazon S3.  Valid values are `FailedEventsOnly` and `AllEvents`.  Default value is `FailedEventsOnly`.
     * `secrets_manager_configuration` - (Optional) The Secrets Manager configuration. See `secrets_manager_configuration` block below for details. This value is required if `hec_token` is not provided.
     */
    @JvmName("isegkljxrbbcyuep")
    public suspend fun s3BackupMode(`value`: Output<String>) {
        this.s3BackupMode = value
    }

    /**
     * @param value The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("bfkfodeqlybjwcks")
    public suspend fun s3Configuration(`value`: Output<FirehoseDeliveryStreamSplunkConfigurationS3ConfigurationArgs>) {
        this.s3Configuration = value
    }

    /**
     * @param value
     */
    @JvmName("pkdyksxwkulhtbhs")
    public suspend fun secretsManagerConfiguration(`value`: Output<FirehoseDeliveryStreamSplunkConfigurationSecretsManagerConfigurationArgs>) {
        this.secretsManagerConfiguration = value
    }

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds between 0 to 60, before delivering it to the destination.  The default value is 60s.
     */
    @JvmName("tjgkhmrjdjvryodh")
    public suspend fun bufferingInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingInterval = mapped
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs between 1 to 5, before delivering it to the destination.  The default value is 5MB.
     */
    @JvmName("jpkdtwrrdilpkxpw")
    public suspend fun bufferingSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingSize = mapped
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("wxvioqtwunsqxscl")
    public suspend fun cloudwatchLoggingOptions(`value`: FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param argument The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
     */
    @JvmName("jyvavcsjtrnwbcmu")
    public suspend fun cloudwatchLoggingOptions(argument: suspend FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param value The amount of time, in seconds between 180 and 600, that Kinesis Firehose waits to receive an acknowledgment from Splunk after it sends it data.
     */
    @JvmName("lwkorryexfnasydy")
    public suspend fun hecAcknowledgmentTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hecAcknowledgmentTimeout = mapped
    }

    /**
     * @param value The HTTP Event Collector (HEC) endpoint to which Kinesis Firehose sends your data.
     */
    @JvmName("mvaiimofdwdxxnye")
    public suspend fun hecEndpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hecEndpoint = mapped
    }

    /**
     * @param value The HEC endpoint type. Valid values are `Raw` or `Event`. The default value is `Raw`.
     */
    @JvmName("mykpvpxqldryonjm")
    public suspend fun hecEndpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hecEndpointType = mapped
    }

    /**
     * @param value The GUID that you obtain from your Splunk cluster when you create a new HEC endpoint. This value is required if `secrets_manager_configuration` is not provided.
     */
    @JvmName("xlfayganmnvlkbyq")
    public suspend fun hecToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hecToken = mapped
    }

    /**
     * @param value The data processing configuration.  See `processing_configuration` block below for details.
     */
    @JvmName("awbujmcaloyewuac")
    public suspend fun processingConfiguration(`value`: FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processingConfiguration = mapped
    }

    /**
     * @param argument The data processing configuration.  See `processing_configuration` block below for details.
     */
    @JvmName("lkriidbfoypdbmwm")
    public suspend fun processingConfiguration(argument: suspend FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.processingConfiguration = mapped
    }

    /**
     * @param value After an initial failure to deliver to Splunk, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
     */
    @JvmName("shamumaxhilgdhxk")
    public suspend fun retryDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryDuration = mapped
    }

    /**
     * @param value Defines how documents should be delivered to Amazon S3.  Valid values are `FailedEventsOnly` and `AllEvents`.  Default value is `FailedEventsOnly`.
     * `secrets_manager_configuration` - (Optional) The Secrets Manager configuration. See `secrets_manager_configuration` block below for details. This value is required if `hec_token` is not provided.
     */
    @JvmName("kjjmpiovcwcdllcp")
    public suspend fun s3BackupMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BackupMode = mapped
    }

    /**
     * @param value The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("effqdbaopwopbker")
    public suspend fun s3Configuration(`value`: FirehoseDeliveryStreamSplunkConfigurationS3ConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Configuration = mapped
    }

    /**
     * @param argument The S3 Configuration. See `s3_configuration` block below for details.
     */
    @JvmName("sjgrpcnpqwfofqmc")
    public suspend fun s3Configuration(argument: suspend FirehoseDeliveryStreamSplunkConfigurationS3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamSplunkConfigurationS3ConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3Configuration = mapped
    }

    /**
     * @param value
     */
    @JvmName("kssohgefqxnnxusv")
    public suspend fun secretsManagerConfiguration(`value`: FirehoseDeliveryStreamSplunkConfigurationSecretsManagerConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsManagerConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("erdyxwhxjdkwimav")
    public suspend fun secretsManagerConfiguration(argument: suspend FirehoseDeliveryStreamSplunkConfigurationSecretsManagerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamSplunkConfigurationSecretsManagerConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.secretsManagerConfiguration = mapped
    }

    internal fun build(): FirehoseDeliveryStreamSplunkConfigurationArgs =
        FirehoseDeliveryStreamSplunkConfigurationArgs(
            bufferingInterval = bufferingInterval,
            bufferingSize = bufferingSize,
            cloudwatchLoggingOptions = cloudwatchLoggingOptions,
            hecAcknowledgmentTimeout = hecAcknowledgmentTimeout,
            hecEndpoint = hecEndpoint ?: throw PulumiNullFieldException("hecEndpoint"),
            hecEndpointType = hecEndpointType,
            hecToken = hecToken,
            processingConfiguration = processingConfiguration,
            retryDuration = retryDuration,
            s3BackupMode = s3BackupMode,
            s3Configuration = s3Configuration ?: throw PulumiNullFieldException("s3Configuration"),
            secretsManagerConfiguration = secretsManagerConfiguration,
        )
}
