@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.GetFirehoseDeliveryStreamPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFirehoseDeliveryStream.
 * @property name Name of the Kinesis Stream.
 */
public data class GetFirehoseDeliveryStreamPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.GetFirehoseDeliveryStreamPlainArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.GetFirehoseDeliveryStreamPlainArgs =
        com.pulumi.aws.kinesis.inputs.GetFirehoseDeliveryStreamPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFirehoseDeliveryStreamPlainArgs].
 */
@PulumiTagMarker
public class GetFirehoseDeliveryStreamPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the Kinesis Stream.
     */
    @JvmName("yvtwdlmsbodduemp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetFirehoseDeliveryStreamPlainArgs = GetFirehoseDeliveryStreamPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
