@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id The ARN of the Kinesis Analytics Application.
 * @property kinesisFirehose The Kinesis Firehose configuration for the streaming source. Conflicts with `kinesis_stream`.
 * See Kinesis Firehose below for more details.
 * @property kinesisStream The Kinesis Stream configuration for the streaming source. Conflicts with `kinesis_firehose`.
 * See Kinesis Stream below for more details.
 * @property namePrefix The Name Prefix to use when creating an in-application stream.
 * @property parallelism The number of Parallel in-application streams to create.
 * See Parallelism below for more details.
 * @property processingConfiguration The Processing Configuration to transform records as they are received from the stream.
 * See Processing Configuration below for more details.
 * @property schema The Schema format of the data in the streaming source. See Source Schema below for more details.
 * @property startingPositionConfigurations The point at which the application starts processing records from the streaming source.
 * See Starting Position Configuration below for more details.
 * @property streamNames
 */
public data class AnalyticsApplicationInputs(
    public val id: String? = null,
    public val kinesisFirehose: AnalyticsApplicationInputsKinesisFirehose? = null,
    public val kinesisStream: AnalyticsApplicationInputsKinesisStream? = null,
    public val namePrefix: String,
    public val parallelism: AnalyticsApplicationInputsParallelism? = null,
    public val processingConfiguration: AnalyticsApplicationInputsProcessingConfiguration? = null,
    public val schema: AnalyticsApplicationInputsSchema,
    public val startingPositionConfigurations: List<AnalyticsApplicationInputsStartingPositionConfiguration>? = null,
    public val streamNames: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.AnalyticsApplicationInputs): AnalyticsApplicationInputs = AnalyticsApplicationInputs(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            kinesisFirehose = javaType.kinesisFirehose().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationInputsKinesisFirehose.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kinesisStream = javaType.kinesisStream().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationInputsKinesisStream.Companion.toKotlin(args0)
                })
            }).orElse(null),
            namePrefix = javaType.namePrefix(),
            parallelism = javaType.parallelism().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationInputsParallelism.Companion.toKotlin(args0)
                })
            }).orElse(null),
            processingConfiguration = javaType.processingConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationInputsProcessingConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            schema = javaType.schema().let({ args0 ->
                com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationInputsSchema.Companion.toKotlin(args0)
            }),
            startingPositionConfigurations = javaType.startingPositionConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationInputsStartingPositionConfiguration.Companion.toKotlin(args0)
                })
            }),
            streamNames = javaType.streamNames().map({ args0 -> args0 }),
        )
    }
}
