@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property mapping The Mapping reference to the data element.
 * @property name Name of the column.
 * @property sqlType The SQL Type of the column.
 */
public data class AnalyticsApplicationInputsSchemaRecordColumn(
    public val mapping: String? = null,
    public val name: String,
    public val sqlType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.AnalyticsApplicationInputsSchemaRecordColumn): AnalyticsApplicationInputsSchemaRecordColumn = AnalyticsApplicationInputsSchemaRecordColumn(
            mapping = javaType.mapping().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            sqlType = javaType.sqlType(),
        )
    }
}
