@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property mappingParameters The Mapping Information for the record format.
 * See Mapping Parameters below for more details.
 * @property recordFormatType The type of Record Format. Can be `CSV` or `JSON`.
 */
public data class AnalyticsApplicationInputsSchemaRecordFormat(
    public val mappingParameters: AnalyticsApplicationInputsSchemaRecordFormatMappingParameters? =
        null,
    public val recordFormatType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.AnalyticsApplicationInputsSchemaRecordFormat): AnalyticsApplicationInputsSchemaRecordFormat = AnalyticsApplicationInputsSchemaRecordFormat(
            mappingParameters = javaType.mappingParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            recordFormatType = javaType.recordFormatType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
