@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ARN of the Kinesis Analytics Application.
 * @property kinesisFirehose The Kinesis Firehose configuration for the destination stream. Conflicts with `kinesis_stream`.
 * See Kinesis Firehose below for more details.
 * @property kinesisStream The Kinesis Stream configuration for the destination stream. Conflicts with `kinesis_firehose`.
 * See Kinesis Stream below for more details.
 * @property lambda The Lambda function destination. See Lambda below for more details.
 * @property name The Name of the in-application stream.
 * @property schema The Schema format of the data written to the destination. See Destination Schema below for more details.
 */
public data class AnalyticsApplicationOutput(
    public val id: String? = null,
    public val kinesisFirehose: AnalyticsApplicationOutputKinesisFirehose? = null,
    public val kinesisStream: AnalyticsApplicationOutputKinesisStream? = null,
    public val lambda: AnalyticsApplicationOutputLambda? = null,
    public val name: String,
    public val schema: AnalyticsApplicationOutputSchema,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.AnalyticsApplicationOutput): AnalyticsApplicationOutput = AnalyticsApplicationOutput(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            kinesisFirehose = javaType.kinesisFirehose().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationOutputKinesisFirehose.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kinesisStream = javaType.kinesisStream().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationOutputKinesisStream.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lambda = javaType.lambda().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationOutputLambda.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            schema = javaType.schema().let({ args0 ->
                com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationOutputSchema.Companion.toKotlin(args0)
            }),
        )
    }
}
