@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ARN of the Kinesis Analytics Application.
 * @property s3 The S3 configuration for the reference data source. See S3 Reference below for more details.
 * @property schema The Schema format of the data in the streaming source. See Source Schema below for more details.
 * @property tableName The in-application Table Name.
 */
public data class AnalyticsApplicationReferenceDataSources(
    public val id: String? = null,
    public val s3: AnalyticsApplicationReferenceDataSourcesS3,
    public val schema: AnalyticsApplicationReferenceDataSourcesSchema,
    public val tableName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.AnalyticsApplicationReferenceDataSources): AnalyticsApplicationReferenceDataSources = AnalyticsApplicationReferenceDataSources(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            s3 = javaType.s3().let({ args0 ->
                com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationReferenceDataSourcesS3.Companion.toKotlin(args0)
            }),
            schema = javaType.schema().let({ args0 ->
                com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationReferenceDataSourcesSchema.Companion.toKotlin(args0)
            }),
            tableName = javaType.tableName(),
        )
    }
}
