@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Enables or disables the logging. Defaults to `false`.
 * @property logGroupName The CloudWatch group name for logging. This value is required if `enabled` is true.
 * @property logStreamName The CloudWatch log stream name for logging. This value is required if `enabled` is true.
 */
public data class FirehoseDeliveryStreamElasticsearchConfigurationCloudwatchLoggingOptions(
    public val enabled: Boolean? = null,
    public val logGroupName: String? = null,
    public val logStreamName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamElasticsearchConfigurationCloudwatchLoggingOptions): FirehoseDeliveryStreamElasticsearchConfigurationCloudwatchLoggingOptions =
            FirehoseDeliveryStreamElasticsearchConfigurationCloudwatchLoggingOptions(
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                logGroupName = javaType.logGroupName().map({ args0 -> args0 }).orElse(null),
                logStreamName = javaType.logStreamName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
