@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property catalogId The ID of the AWS Glue Data Catalog. If you don't supply this, the AWS account ID is used by default.
 * @property databaseName Specifies the name of the AWS Glue database that contains the schema for the output data.
 * @property region If you don't specify an AWS Region, the default is the current region.
 * @property roleArn The role that Kinesis Data Firehose can use to access AWS Glue. This role must be in the same account you use for Kinesis Data Firehose. Cross-account roles aren't allowed.
 * @property tableName Specifies the AWS Glue table that contains the column information that constitutes your data schema.
 * @property versionId Specifies the table version for the output data schema. Defaults to `LATEST`.
 */
public data class
FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfiguration(
    public val catalogId: String? = null,
    public val databaseName: String,
    public val region: String? = null,
    public val roleArn: String,
    public val tableName: String,
    public val versionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfiguration): FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfiguration =
            FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfiguration(
                catalogId = javaType.catalogId().map({ args0 -> args0 }).orElse(null),
                databaseName = javaType.databaseName(),
                region = javaType.region().map({ args0 -> args0 }).orElse(null),
                roleArn = javaType.roleArn(),
                tableName = javaType.tableName(),
                versionId = javaType.versionId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
