@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property enabled Enables or disables dynamic partitioning. Defaults to `false`.
 * @property retryDuration Total amount of seconds Firehose spends on retries. Valid values between 0 and 7200. Default is 300.
 * > **NOTE:** You can enable dynamic partitioning only when you create a new delivery stream. Once you enable dynamic partitioning on a delivery stream, it cannot be disabled on this delivery stream. Therefore, the provider will recreate the resource whenever dynamic partitioning is enabled or disabled.
 */
public data class FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfiguration(
    public val enabled: Boolean? = null,
    public val retryDuration: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfiguration): FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfiguration =
            FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfiguration(
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                retryDuration = javaType.retryDuration().map({ args0 -> args0 }).orElse(null),
            )
    }
}
