@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property enabled Enables or disables data processing.
 * @property processors Specifies the data processors as multiple blocks. See `processors` block below for details.
 */
public data class FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfiguration(
    public val enabled: Boolean? = null,
    public val processors: List<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessor>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfiguration): FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfiguration =
            FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfiguration(
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                processors = javaType.processors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessor.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
