@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessKey The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
 * @property bufferingInterval Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).
 * @property bufferingSize Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
 * @property name The HTTP endpoint name.
 * @property processingConfiguration The data processing configuration.  See `processing_configuration` block below for details.
 * @property requestConfiguration The request configuration.  See `request_configuration` block below for details.
 * @property retryDuration Total amount of seconds Firehose spends on retries. This duration starts after the initial attempt fails, It does not include the time periods during which Firehose waits for acknowledgment from the specified destination after each attempt. Valid values between `0` and `7200`. Default is `300`.
 * @property roleArn Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs. The pattern needs to be `arn:.*`.
 * @property s3BackupMode Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDataOnly` and `AllData`.  Default value is `FailedDataOnly`.
 * @property s3Configuration The S3 Configuration. See `s3_configuration` block below for details.
 * @property secretsManagerConfiguration The Secret Manager Configuration. See `secrets_manager_configuration` block below for details.
 * @property url The HTTP endpoint URL to which Kinesis Firehose sends your data.
 */
public data class FirehoseDeliveryStreamHttpEndpointConfiguration(
    public val accessKey: String? = null,
    public val bufferingInterval: Int? = null,
    public val bufferingSize: Int? = null,
    public val cloudwatchLoggingOptions: FirehoseDeliveryStreamHttpEndpointConfigurationCloudwatchLoggingOptions? = null,
    public val name: String? = null,
    public val processingConfiguration: FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfiguration? = null,
    public val requestConfiguration: FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfiguration? = null,
    public val retryDuration: Int? = null,
    public val roleArn: String? = null,
    public val s3BackupMode: String? = null,
    public val s3Configuration: FirehoseDeliveryStreamHttpEndpointConfigurationS3Configuration,
    public val secretsManagerConfiguration: FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfiguration? = null,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamHttpEndpointConfiguration): FirehoseDeliveryStreamHttpEndpointConfiguration =
            FirehoseDeliveryStreamHttpEndpointConfiguration(
                accessKey = javaType.accessKey().map({ args0 -> args0 }).orElse(null),
                bufferingInterval = javaType.bufferingInterval().map({ args0 -> args0 }).orElse(null),
                bufferingSize = javaType.bufferingSize().map({ args0 -> args0 }).orElse(null),
                cloudwatchLoggingOptions = javaType.cloudwatchLoggingOptions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamHttpEndpointConfigurationCloudwatchLoggingOptions.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                processingConfiguration = javaType.processingConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                requestConfiguration = javaType.requestConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                retryDuration = javaType.retryDuration().map({ args0 -> args0 }).orElse(null),
                roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
                s3BackupMode = javaType.s3BackupMode().map({ args0 -> args0 }).orElse(null),
                s3Configuration = javaType.s3Configuration().let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamHttpEndpointConfigurationS3Configuration.Companion.toKotlin(args0)
                }),
                secretsManagerConfiguration = javaType.secretsManagerConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamHttpEndpointConfigurationSecretsManagerConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                url = javaType.url(),
            )
    }
}
